function top_idx = hit2loci(p,chr,pos,trh)

sel = find(sum(isnan([p chr pos]),2)==0);
p = p(sel);
chr = chr(sel);
pos = pos(sel);

if nargin<4
    trh = 1e6;
end

uchr = unique(chr);
k = match_names(chr,uchr);

top_idx = [];
for i=1:length(uchr)
    ii = uchr(i);

    ss = find(k(:,i)==1);
    pos1 = pos(ss);
    pp = p(ss);
        
    sele_in = 1:length(ss);
    sele_out = [];

    while ~isempty(sele_in)
        [mv mp] = min(pp(sele_in));
        mp = sele_in(mp(1));
        
        sele_out = [sele_out;mp];
        sele_in = sele_in(abs(pos1(sele_in)-pos1(mp))>trh);
    end

    top_idx = [top_idx;ss(sele_out)];
end

top_idx = sel(top_idx);
