function C = read_file(fn,n_rows,delim,hl,n_cols,type,bufsize)
if nargin<2
    n_rows = 0;
end
if nargin<3
    delim = '\t';
end
if nargin<4
    hl = 0;
end
if nargin<5
    n_cols = get_col_num(fn,delim,hl);
end
if nargin<6
    type = '%s';
end
if nargin<7
    bufsize = 1e7;
end

if n_rows==0
    fid = fopen(fn);
    C = textscan(fid,repmat(type,1,n_cols),'delimiter',delim,'headerlines',hl,'bufsize',bufsize);
    fclose(fid);
else
    fid = fopen(fn);
    C = textscan(fid,repmat(type,1,n_cols),n_rows,'delimiter',delim,'headerlines',hl,'bufsize',bufsize);
    fclose(fid);
end
