function manhattan_plot_sel(p,chr,pos,rep_sel)

fsz = 14;

%% pre-check
if iscell(chr)
    for i=1:length(chr)
        if isempty(chr{i})
            chr{i} = '';
        end
        if chr{i}=='X'
            chr{i} = '23';
        end
    end
    chr = str2double(chr);
end

if iscell(pos)
    pos = str2double(pos);
end

%%
k = match_names(chr,1:23);

mpval = max(-log10(p));

lp = 0;
lps = zeros(23,1);
for i=1:23
    lps(i) = lp;
    if mod(i,2)==1
        seli = find(k(:,i));
        plot(lp+pos(seli),-log10(p(seli)),'.','color','b');
        if i~=23
            text(lp+mean(pos(seli)),-.05*(mpval/7),num2str(i),'verticalalignment','top','horizontalalignment','center',...
                'fontsize',fsz);
        else
            text(lp+mean(pos(seli)),-.05*(mpval/7),'X','verticalalignment','top','horizontalalignment','center',...
                'fontsize',fsz);
        end    
    else
        seli = find(k(:,i));
        plot(lp+pos(seli),-log10(p(seli)),'.','color',[.6 .6 .6]);
        if i~=23
            text(lp+mean(pos(seli)),-.5*(mpval/7),num2str(i),'verticalalignment','top','horizontalalignment','center',...
                'fontsize',fsz);
        else
            text(lp+mean(pos(seli)),-.5*(mpval/7),'X','verticalalignment','top','horizontalalignment','center',...
                'fontsize',fsz);
        end    
    end
    if ~isempty(max(pos(seli)))
        lp = lp+max(pos(seli))+5e7;
    end
    hold on
end

ss = find(~isnan(chr(rep_sel)));

plot(lps(chr(rep_sel(ss)))+pos(rep_sel(ss)),-log10(p(rep_sel(ss))),'ro','markerfacecolor','r');
set(gca,'Xtick',[],'fontsize',fsz);
xlim([0 lp]);
ylabel('-log_1_0 p-value','fontsize',fsz);
