function faA = allele_swap(aA)

warning off all

str=cd;
if str(1)=='/'
    root_dir = '/home/zoltan/SMB_zoltan'; % For Unix
else
    root_dir = 'V:/zoltan/SMB_zoltan'; % For Windows (Shoshana)
end
addpath([root_dir '/MyISA'])

ch0 = 0;
if ~iscell(aA)
    ch0 = 1;
    aA = num2cell(char(aA));
end

aA = upper(aA);
faA = aA;
als = {'A';'C';'G';'T'};
fals = {'T';'G';'C';'A'};
k = match_names(aA,als);
for i=1:4
    ss = find(k(:,i)==1);
    faA(ss) = repcell(fals(i),length(ss),1);
end

if ch0==1
    faA = cell2mat(faA);
end
