function top_idx = hit2loci_cM35(p,chr,pos,trh)

sel = find(sum(isnan([p chr pos]),2)==0);
p = p(sel);
chr = chr(sel);
pos = pos(sel);

if nargin<4
    trh = .2;
end

uchr = unique(chr);
k = match_names(chr,uchr);

top_idx = [];
for i=1:length(uchr)
    ii = uchr(i);
    ss = find(k(:,i)==1);
    load(['./recomb_hotspots/genetic_map_chr',num2str(ii),'_b35.mat'],'pos0','cm0');
    pos1 = pos(ss);
    pp = p(ss);
    
    [aa bb] = fmn(pos1,pos0);
    cm1 = repmat(NaN,length(ss),1);
    cm1(aa) = cm0(bb);
    
    sz1 = find(isnan(cm1));
    
    for j=1:length(sz1)
        a1 = find(pos0<pos1(sz1(j)),1,'last');
        if isempty(a1)
            [tmp a1] = min(pos0);
        end
        a2 = find(pos0>pos1(sz1(j)),1,'first');
        if isempty(a2)
            [tmp a2] = max(pos0);
        end
        if a1==a2
            cm1(sz1(j)) = cm0(a1);
        else
            cm1(sz1(j)) = cm0(a1)+(cm0(a2)-cm0(a1))*(pos1(sz1(j))-pos0(a1))/(pos0(a2)-pos0(a1));
        end
    end
    
    sele_in = 1:length(ss);
    sele_out = [];

    while ~isempty(sele_in)
        [mv mp] = min(pp(sele_in));
        mp = sele_in(mp(1));
        
        sele_out = [sele_out;mp];
        sele_in = sele_in(abs(cm1(sele_in)-cm1(mp))>trh);

    end

    top_idx = [top_idx;ss(sele_out)];
end

top_idx = sel(top_idx);
