#ifndef QUICKTEST_STATS_H
#define QUICKTEST_STATS_H

#include <cstdlib>
#include <iostream>
#include <fstream>
#include <vector>
#include <set>
#include <iterator>
#include <algorithm>
using namespace std; 

#define MATHLIB_STANDALONE
#include <Rmath.h>

extern "C" {
  void dgemv_(char* trans, int* m, int* n, double* alpha, double* a, int* lda, double* x, int* incx, double* beta, double* y, int* incy);
  void dposv_(char* uplo, int* n, int* nrhs, double* a, int* lda, double* b, int* ldb, int* info);
  void dsymv_(char* uplo, int* n, double* alpha, double* a, int* lda, double* b, int* incx, double* beta, double* y, int* incy);
}

#include "quicktest.h"

int precompute_score_mix (vector<double>* l1, vector<double>* l2, 
			  vector<double> y0, int n,
			  vector<double> pi, vector<double> mu, 
			  vector<double> sigma, int bigK);

int preprocess_phenotype (io_spec* io, double* yRaw, int n, 
			  double* vars, double* vars2, double* varty, int nCov, int nVar,
			  vector<double>* yResid, vector<double>* yNorm, vector<int>* yRank, 
			  double* sumyyOrig, double* sumyyResid, double* sumyyNorm);

int fit_mixture (vector<double> y, int n, double sumyy, int bigK, bool muZero,
		 vector<double>* piBest, vector<double>* muBest, vector<double>* sigmaBest, 
		 io_spec* io, bool verbose);

int refit_mixture (vector<double> y, int n, double sumyy, int bigK, bool muZero,
		 vector<double>* pi, vector<double>* mu, vector<double>* sigma,
		 bool verbose);

int method_mix_null (vector<double> y, int n, 
		     int bigK, vector<double> piInit, vector<double> mu, vector<double> sigma,
		     int* nIts, double* alphaMLE, double* lldiff,
		     bool verbose);

double compute_alphaHat (vector<double> p0, vector<double> p1, vector<double> p2,
			 double AB, double BB, int n);


int method_newton_mix (vector<double> y, vector<double> pAA, vector<double> pAB, vector<double> pBB, 
		       int n, int bigK, vector<double> pi, vector<double> mu, vector<double> sigma,
		       double alphaNull, 
		       int* nIts, double* betaMLE, double* seApprox, double* pLRT);




int precompute_mean (vector<double> pAB, vector<double> pBB, int n,
		     double meanAB, double meanBB, vector<double>* g, double* sumgg);


int method_call (vector<double> y, vector<int> callG,
		 int n, double priorDF, double ppbeta, double callThresh,
		 int* nCalled, double* beta, double* se, double* pval);

int method_em (vector<double> y, vector<double> pAA, vector<double> pAB, vector<double> pBB, 
	       int n, double sumyy, 
	       int* nIts, double* betaMLE, double* seApprox, double* pLRT);

int method_em_mix (vector<double> y, vector<double> pAA, vector<double> pAB, vector<double> pBB, 
		int n, int bigK, vector<double> pi, vector<double> mu, vector<double> sigma,
		double alphaNull, 
		int* nIts, double* betaMLE, double* lldiff, double* pLRT);

int method_mean (vector<double> y, vector<double> g, int n,
		 double sumgg, double sumyy, double priorDF, double ppbeta, 
		 double* beta, double* se, double* pval);

int method_mean_mix (vector<double> y, vector<double> g, int n, 
		     int bigK, vector<double> pi, vector<double> mu, vector<double> sigma,
		     double alphaNull,
		     int* nIts, double* betaMLE, double* se, double* pLRT);

int method_score (double v, double d, vector<double> pAB, vector<double> pBB, vector<double> y, 
		  double n, double sumyy,
		  double* beta, double* se, double* pval);

int method_score_mix (vector<double> pAB, vector<double> pBB, int n, 
		      vector<double> l1, vector<double> l2, double* beta, double* se, double* pval);

int method_sim (vector<double> y, vector<double> pAA, vector<double> pAAAB, int n,
		double sumyy, double priorDF, double ppbeta, int nsims,
		int* nUsed, double* beta, double* se, double* pval, double* vWeight);

int method_mcmc (vector<double> y, vector<double> pAA, vector<double> pAB, vector<double> pBB, int n,
		 double sumyy, double priorDF, double ppbeta, int nsims, int burnin,
		 int* nUsed, double* ebeta, double* sdbeta, double* pval);

int method_Pettitt (vector<int> yRank, vector<double> g, int n,
		    double* c, double* a,
		    double* beta, double* se, double* pval);


int do_fit (vector<double> y, int n, 
	    vector<double>* pi, vector<double>* mu, vector<double>* sigma, int bigK,
	    bool muZero, bool* thisDegen, double* muBad, bool* thisConv, int* thisIt, int maxit);



int synthetic (vector<double>* y, vector<double> yold, 
	       vector<double>* g, vector<double> pAA, vector<double> pAAAB, int n,
	       vector<int> iPerm, double beta, double* sumyy, double* sumgg);

int method_interaction (vector<double> y, vector<double> g, 
			double* vars, double* vars2, double* varty, 
			int nn, int nCov, double sumyy, 
			double* betaInt, double* seInt, double* pvalInt);

int method_robust (vector<double> y, vector<double> g, 
			double* vars, double* vars2, double* varty, 
			int nn, int nCov, double sumyy, 
			double* betaInt, double* seInt, double* pvalInt,
            double* betasnp, double* sesnp, double* pvalsnp, double* covsnpinteraction);

int method_logistic (vector<int> y, vector<double> g, int n,
		     double* x, int nCov, vector<double>* qnull, bool null,
		     double* beta, double* se, double* pval);

int normal_residuals (double* yOut, double* yIn, int n, 
 		      double* vars, double* vars2, double* varty, int nUse, int nVar, double* ssr);

void print_summary (double* x, int n);
void print_summary (vector<double> x, int n);

#endif /* QUICKTEST_STATS_H */

