#define MATHLIB_STANDALONE
#include <Rmath.h>
using namespace std;


// let Z = (Z_(1), Z_(2), ... , Z_(n))' be a vector of normal order statistics
// computes a = E(Z) and A = Var(Z) = E(Z'Z)-a'a
// based on Fortran code from AS 128, AS 177, AS R 72



int precompute_Pettitt (double* A, double* a, int n);

double cov (double dxr, double d2xr, double d3xr, double d4xr, double d5xr,
	    double pr, double qr, 
	    double dxs, double d2xs, double d3xs, double d4xs, double d5xs, 
	    double ps,
	    double rn2, double rn22, double rn23);
double var (double dxr, double d2xr, double d3xr, double d4xr, double d5xr, 
	    double pr,double qr, double rn2, double rn22, double rn23);
void der (double x, double& dx, double& d2x, double& d3x, double& d4x, double& d5x);
void rwnorm (double* v, int n, int id);


int precompute_Pettitt (double* A, double* a, int n) {

  if (n <= 1) {
    return (1);
  }
  int nhalf1 = (n+1)/2;

  double work[4][721];
  for (int i = 0; i < 721; ++i) {
    double xx = -9. + (double)i * .025;
    work[0][i] = xx;
    work[1][i] = -0.918938533 - xx * xx * .5;
    work[2][i] = pnorm(xx, 0., 1., 0, 1);
    work[3][i] = pnorm(xx, 0., 1., 1, 1);
  }

  double summ2 = 0.;
  double ex1, ex2;
  double cc = log((double)n);
  for (int i = 1; i <= nhalf1; ++i) {
    double scor = 0.;
    for (int j = 0; j < 721; ++j) {
      scor += exp(work[1][j] + (double)(i-1) * work[2][j] + (double)(n-i) * work[3][j] + cc) * work[0][j];
    }
    a[i] = scor * .025;
    a[n+1-i] = -a[i];
    if (i == 1) {
      ex1 = -a[i];
    } else if (i == 2) {
      ex2 = -a[i];
    }
    summ2 += 2.*a[i]*a[i];
    cc += log((double)(n-i)) - log((double)i);
  }
  
  const double mpt15 = -.15;
  const double pt09 = 0.091105452691946;

  const double b0 = -0.934e-4;
  const double b1 = -0.5950321; 
  const double b2 = 0.0165504;
  const double b3 = 0.0056975;
  const double b4 = -0.8531e-3;

  const double c0 = 0.7956e-11;
  const double c1 = -0.595628869836878;
  const double c2 = 0.08967827948053;
  const double c3 = -0.007850066416039;
  const double c4 = -0.296537314353e-3;
  const double c5 = 0.215480033104e-3;
  const double c6 = -0.33811291323e-4;
  const double c7 = 0.2738431187e-5;
  const double c8 = -0.106432868e-6;
  const double c9 = 0.1100251e-8;

  const double a0 = 0.04619831847696;
  const double a1 = -0.147930264017706;
  const double a2 = -0.451288155800301;
  const double a3 = 0.010055707621709;
  const double a4 = 0.007412441980877;
  const double a5 = -0.001143407259055;
  const double a6 = 0.54428754576e-4;

  const double d0 = 0.093256818332708;
  const double d1 = 1.336952989217635;
  const double d2 = -1.783195691545387;
  const double d3 = 0.488682076188729;
  const double d4 = -0.078737246197474;
  const double d5 = 0.00662561987806;
  const double d6 = -0.226486218258e-3;

  double x;
  double c11 = 0.;

  x = (double)n;
  if (n > 370) {
    x = (pow(x,mpt15) - 1.) / mpt15;
    c11 = exp(b0 + x*(b1 + x*(b2 + x*(b3 + x*b4))));
  } else if (n <= 100) {
    x = (pow(x,pt09) - 1.) / pt09;
    c11 = exp(c0 + x*(c1 + x*(c2 + x*(c3 + x*(c4 + x*(c5 + x*(c6 + x*(c7 + x*(c8 + x*c9)))))))));
  } else if (n <= 200) {
    x = log(a0 + x);
    c11 = exp(a1 + x*(a2 + x*(a3 + x*(a4 + x*(a5 + x*a6)))));
  } else {
    x = log(d0 + x);
    c11 = exp(d1 + x*(d2 + x*(d3 + x*(d4 + x*(d5 + x*d6)))));
  }


  double cnst,dxr,d2xr,d3xr,d4xr,d5xr,dxs,d2xs,d3xs,d4xs,d5xs,pr,ps,qr,sum,xr,xs;
  int njm1, im1;

  double rn = (double)n;
  double rn1 = rn+1.;
  double rn2 = rn+2.;
  double rn22 = rn2*rn2;
  double rn23 = rn22*rn2;
  
  int ni = n;
  for (int i = 1; i <= nhalf1; ++i) {
    pr = (double)i / rn1;
    qr = 1.-pr;
    xr = qnorm(pr, 0., 1., 1, 0); // lower.tail = 1, log.p = 0
    der(xr,dxr,d2xr,d3xr,d4xr,d5xr);
    for (int j = i; j <= ni; ++j) {
      if (i==j) {
	A[i*n+j] = var(dxr,d2xr,d3xr,d4xr,d5xr,pr,qr,rn2,rn22,rn23);
      } else {
	ps = (double)j/rn1;
	xs = qnorm(ps, 0., 1., 1, 0); // lower.tail = 1, log.p = 0
	der(xs,dxs,d2xs,d3xs,d4xs,d5xs);
	A[i*n+j] = cov(dxr,d2xr,d3xr,d4xr,d5xr,pr,qr,dxs,d2xs,d3xs,d4xs,d5xs,ps,rn2,rn22,rn23);
	A[j*n+i] = A[j,i];
      }
    }
    ni=ni-1;
  }
  
  int nj = n;
  for (int i = 2; i <= n; ++i) {
    njm1 = nj - 1;
    im1 = i - 1;
    for (int j = nj; j <= n; ++j) {
      A[i*n+j] = A[im1*n+njm1];
      im1 = im1 - 1;
    }
    nj = nj - 1;
  }
  
  A[1*n+1] = c11;
  A[n*n+n] = c11;
  A[1*n+2] = c11+ex1*(ex1-ex2)-1.;
  A[2*n+1] = A[1*n+2];
  A[n*n+n-1] = A[1*n+2];
  A[(n-1)*n+n] = A[1*n+2];
  
  if (n == 2) {
    return(0);
  }
 
  sum = 0.;
  for (int j = 3; j <=n; ++j) {
    sum += A[1*n+j];
  }
  cnst = (1.-A[1*n+1]-A[1*n+2])/sum;
  nj = n-2;
  
  for (int j = 3; j <=n; ++j) {
    A[1*n+j] = A[1*n+j]*cnst;
    A[j*n+1] = A[1*n+j];
    A[n*n+nj] = A[1*n+j];
    A[nj*n+n] = A[1*n+j];
    nj=nj-1;
  }
  rwnorm(A,n,0);

  sum = 0.;
  for (int k = 1; k <= n; ++k) {
    if (k != 2 && k != n-1) {
      sum = sum + A[k*n+k];
    }
  }
  A[2*n+2] = 0.5*(double(n)-summ2-sum);
  A[(n-1)*n+(n-1)] = A[2*n+2];
  rwnorm(A,n,1);

  return (0);
}


void rwnorm (double* A, int n, int id) {

  double cnst,sum,term;

  int nhalf1 = (n+1)/2;
  int ni = n-1;

  for (int i = 2; i <= nhalf1; ++i) {
    sum = 0.;
    for (int j = i; j <= ni; ++j) {
      sum += A[i*n+j];
    }
    if (id != 0) {
      sum -= A[i*n+i];
    }
    if (fabs(sum) >= 1e-12) {
      int k = i-1;
      if (id != 0) {
	k = i;
      }
      term = 0.;
      for (int j = 1; j <= k; ++j) {
	term += A[i*n+j];
      }
      int l = ni+1; 
      for (int j = l; j <= n; ++j) {
	term += A[i*n+j];
      }
      cnst = (1.-term)/sum;
      int m = i;
      if (id != 0) {
	m = i+1;
      }
      int nj = n-m+1;
      for (int j = m; j <= ni; ++j) {
	A[i*n+j]=A[i*n+j]*cnst;
	A[j*n+i]=A[i*n+j];
	A[ni*n+nj]=A[i*n+j];
	A[nj*n+ni]=A[i*n+j];
	nj = nj-1;
      }
      ni = ni-1;
    }
  }
}












void der (double x, double& dx, double& d2x, double& d3x, double& d4x, double& d5x) {

  const double rad2pi = 2.506628274631;
  const double twopi = M_2PI;

  double x2 = x*x;
  dx = rad2pi*exp(x2/2.);
  d2x = twopi*x*exp(x2);
  d3x = twopi*rad2pi*(2.*x2+1.)*exp(1.5*x2);
  double term = twopi*twopi*exp(2.*x2);
  d4x = term*x*(6.*x2+7.);
  d5x = term*dx*(x2*(24.*x2+46.)+7.);
  
}

double var (double dxr, double d2xr, double d3xr, double d4xr, double d5xr, 
	    double pr,double qr, double rn2, double rn22, double rn23) {

  double dxr2 = dxr*dxr;
  double prqr = pr*qr;
  double res = prqr*dxr2/rn2;
  double qrmpr = qr-pr;
  double d2xr2 = d2xr*d2xr;
  res += prqr/rn22*(2.*qrmpr*dxr*d2xr+prqr*(dxr*d3xr+0.5*d2xr2));
  res += prqr/rn23*(-2.*qrmpr*dxr*d2xr+
		    (qrmpr*qrmpr-prqr)*(2.*dxr*d3xr+1.5*d2xr2)
		    +prqr*qrmpr*(1.6666666667*dxr*d4xr+3.*d2xr*d3xr)
		    +0.25*prqr*prqr*(dxr*d5xr+2.*d2xr*d4xr+
				     1.6666666667*d3xr*d3xr));
  return (res);
}

double cov(double dxr, double d2xr, double d3xr, double d4xr, double d5xr,
	   double pr, double qr, 
	   double dxs, double d2xs, double d3xs, double d4xs, double d5xs, 
	   double ps,
	   double rn2, double rn22, double rn23) {

  double qs = 1.-ps;
  double prqs = pr*qs;
  double res = prqs*dxr*dxs/rn2;
  double qrmpr = qr-pr;
  double qsmps = qs-ps;
  double prqr = pr*qr;
  double psqs = ps*qs;
  res += prqs/rn22*(qrmpr*d2xr*dxs+
		    qsmps*dxr*d2xs+0.5*prqr*d3xr*dxs+
		    0.5*psqs*dxr*d3xs+0.5*prqs*d2xr*d2xs);
  double pr2 = pr*pr;
  double qr2 = qr*qr;
  double ps2 = ps*ps;
  double qs2 = qs*qs;
  double psqr = ps*qr;
  double term1 = -d2xr*dxs*qrmpr-qsmps*dxr*d2xs+(qrmpr*qrmpr-prqr)*d3xr*dxs;
  double term2 = (qsmps*qsmps-psqs)*dxr*d3xs+(1.5*qrmpr*qsmps+0.5*psqr-2.*prqs)*d2xr*d2xs;
  double term3 = 0.833333333333*(prqr*qrmpr*d4xr*dxs+psqs*qsmps*dxr*d4xs)+(prqs*qrmpr+0.5*prqr*qsmps)*d3xr*d2xs;
  double term4 = (prqs*qsmps+0.5*psqs*qrmpr)*d2xr*d3xs+0.125*(pr2*qr2*d5xr*dxs+ps2*qs2*dxr*d5xs);
  double  term5 = 0.25*(pr2*qr*qs*d4xr*d2xs+pr*ps*qs2*d2xr*d4xs)+0.0833333333333*(2.*pr2*qs2+3.*pr*qr*ps*qs)*d3xr*d3xs;
  res += prqs/rn23*(term1+term2+term3+term4+term5);
  return (res);
}
