clear all
clc
load nci60_data_fragment

%% Data normalization
G = normalize(G,1);
D = normalize(D,1);

%% Generate shuffled data (for robustness control)

[n1 n2] = size(G);
[sv sp] = sort(rand(numel(G),1));
G0 = reshape(G(sp),n1,n2);
G0 = normalize(G0,1);

[n1 n2] = size(D);
[sv sp] = sort(rand(numel(D),1));
D0 = reshape(D(sp),n1,n2);
D0 = normalize(D0,1);

%% Setting thresholds, number of seeds, signs, etc.
tests = 10;
trh0s = 1:1:3;
trh1s = 1:1:3;
trh2s = 1:1:3;
signs = [0 0 0];

%% initializing output vectors
cs = [];
gs = [];
ds = [];
tr = [];
rb = [];
rb0 = [];
%% looping over different thresholds

for i=1:length(trh1s)
    for j=1:length(trh2s)
        for k=1:length(trh0s)
            trh = [trh0s(k);trh1s(i);trh0s(k);trh2s(j)];
            
            %%%% Real data
            global data1 data1T data2 data2T
            data1 = normalize(G,2);
            data1T = normalize(G,1)';
            data2 = normalize(D,2);
            data2T = normalize(D,1)';
            [a, b, c, ~, ~, d] = ping_pong_v7(tests,trh,signs,1); % the ping-pong algorithm

            %%%% Shuffled data
            global data1 data1T data2 data2T
            data1 = normalize(G0,2);
            data1T = normalize(G0,1)';
            data2 = normalize(D0,2);
            data2T = normalize(D0,1)';
            [~, ~, ~, ~, ~, d0] = ping_pong_v7(tests,trh,signs,1); % the ping-pong algorithm

            sel = find(d>max(d0));
            
            cs = [cs a(:,sel)];
            gs = [gs b(:,sel)];
            ds = [ds c(:,sel)];
            tr = [tr repmat([trh0s(k);trh1s(i);trh2s(j)],1,length(sel))];
            rb0 = [rb0 repmat(mean(d0),1,length(sel))];
            rb = [rb d(:,sel)];
            
        end
        
        %%%%% keeping only one representative of modules with similar gene scores
        if size(gs,2)>500
            C = corrcoef(gs);
            C = (abs(C)>=.9);
            C = tril(C,0);
            selb = find(sum(C,1)==1);
            cs = cs(:,selb);
            gs = gs(:,selb);
            ds = ds(:,selb);   
            tr = tr(:,selb);
            rb = rb(selb);
            rb0 = rb0(selb);
        end
    end
end

C = corrcoef(gs);
C = (abs(C)>=.9);
C = tril(C,0);
selb = find(sum(C,1)==1);

cs = cs(:,selb); % Sample score
gs = gs(:,selb); % Gene score
ds = ds(:,selb); % Drug score
tr = tr(:,selb); % threshold-combination
rb = rb(selb); % Robustness score
rb0 = rb0(selb); % Mean robustness (at the same threshold) for shuffled data



