%% downloading necessary GO files

% download GO tree
create_GOtree;

% download & read in GO definitions of 9 organisms
load go_annotation_files_to_download.mat

for j=1:length(go_files)
    j
    GO_annot(go_files{j});
end

% download & read in KEGG definitions of H.sapiens

KEGG_annot('hsa');

%% create test data for ISA
clear all
clc

load test_data_labels.mat

global norm_data1 norm_data2

D = rand(59,500);
norm_data1 = normalize(D,1);
norm_data2 = normalize(D,2);

data = {norm_data1,norm_data2};
clear norm_data1 norm_data2

%%
[cs gs tr p_bp p_mf p_cc p_kegg lab_go lab_kegg] = ...
    newISA(data,gene_info,cond_info,20,1:.5:3,1:.5:3,...
    1,1,0,'gene_association.goa_human','hsa');

%%
p_go = p_bp+p_cc+p_mf;
mod_lab = cell(size(cs,2),1);
for i=1:size(cs,2)
    [mv mp] = max(p_go(i,:));
    if mv>1.3
        mod_lab{i} = lab_go{mp};
    else
        mod_lab{i} = num2str(i);
    end
end
ViewModuleTree(cs,gs,tr,mod_lab,2,size(gs,2));
