function ViewModuleTree(cs,gs,tr,mod_lab,dir,lim,root_idx)

trhs1 = unique(tr(1,:)','rows')';
trhs2 = unique(tr(2,:)','rows')';

if nargin<5
    dir = 0;
end

if nargin<6
    lim = 50;
end

if nargin<4
    for i=1:size(gs,2)
        mod_lab{i} = num2str(i);
    end
end

[p1 p2] = ModuleTree(cs,gs,tr,trhs1,trhs2);

switch dir
    case {1}
        p = p1;
        V = p;
        V0 = V;
        while sum(V(:))>0
            V = double((V*p)~=0);
            V0 = double((V0+V)~=0);
        end
    case {2}
        p = p2;
        V = p;
        V0 = V;
        while sum(V(:))>0
            V = double((V*p)~=0);
            V0 = double((V0+V)~=0);
        end
    otherwise    
        p = double((p1+p2)~=0);
        V = p;
        V0 = V;
        while sum(V(:))>0
            V = double((V*p)~=0);
            V0 = double((V0+V)~=0);
        end
end

[sv sp] = sort(-sum(V0,1));
if nargin==7
    idx = root_idx;
else
    idx = sp(1);
end
els = [idx;unique([find(V0(:,idx)~=0);find(V0(idx,:)~=0)])];
els = els(1:min(lim,length(els)));
M = p(els,els);
Mt = mod_lab(els);
build_GO_tree(M,Mt);
