function [parent1 parent2] = ModuleTree(cs,gs,tr,trhs1,trhs2)

if nargin<5
    trhs2 = trhs1;
end

if min(sign(cs(:)))*max(sign(cs(:)))==-1
    cs_sign = 0;
else
    cs_sign = 1;
end

if min(sign(gs(:)))*max(sign(gs(:)))==-1
    gs_sign = 0;
else
    gs_sign = 1;
end

parent1 = sparse(size(cs,2),size(cs,2));
parent2 = sparse(size(cs,2),size(cs,2));

for i=length(trhs1):-1:1
    fprintf('.');
    for j=length(trhs2):-1:1
        sel = find(tr(1,:)==trhs1(i) & tr(2,:)==trhs2(j));
        fprintf('-.');
        if i>1 
            sel1 = find(tr(1,:)==trhs1(i-1) & tr(2,:)==trhs2(j));
            [a1 b1] = ISA_base(cs(:,sel),trhs1(i-1),trhs2(j),cs_sign,gs_sign);
            if size(b1,2)>0
                C1 = corrz(gs(:,sel1),b1);
                if ~isempty(C1)
                    [mv mp] = max(C1,[],1);
                    for k=1:length(sel)
                        parent1(sel(k),sel1(mp(k)))=1;
                    end
                end
            end
        end
    end
    fprintf('\n|');
    for j=length(trhs2):-1:1
        sel = find(tr(1,:)==trhs1(i) & tr(2,:)==trhs2(j));
        fprintf(' |');
        if j>1
            sel2 = find(tr(1,:)==trhs1(i) & tr(2,:)==trhs2(j-1));
            [a2 b2] = ISA_base(cs(:,sel),trhs1(i),trhs2(j-1),cs_sign,gs_sign);
            if size(b2,2)>0
                C2 = corrz(gs(:,sel2),b2);
                if ~isempty(C2)
                    [mv mp] = max(C2,[],1);
                    for k=1:length(sel)
                        parent2(sel(k),sel2(mp(k)))=1;
                    end
                end
            end
        end
    end
    fprintf('\n');
end
fprintf('.')
for j=1:length(trhs2)
    fprintf('-.')
end
fprintf('\n');
