function [fin_row_weights,fin_col_weights,fin_rec,lam] =...
    ISA_v3a_silent(tests,trh1,trh2,gene_sparsity,cs_sign,gs_sign)
global norm_data1 norm_data2
%%%%% Globals:
% These global variables should be created outside this function e.g.:
% global norm_data1 norm_data2
% norm_data1 = normalize(M,1);
% norm_data2 = normalize(M,2);
%%%%% INPUTS: 
% tests : number of initial seeds (or the seeds themselves)
% trh1 : condition (rows) threshold
% trh2 : gene (columns) threshold
% gene sparsity (gene/seed): gs = 0 means random number
% cs_sign : condition sign (0 = +/-, 1 = +, -1 = -)
% gs_sign : gene sign (0 = +/-, 1 = +, -1 = -)
%%%%% OUTPUTS:
% fin_col_weights : converged/oscillating condition modules
% fin_row_weights : converged/oscillating gene modules
% fin_rec : number of recurrences
% fin_cyc : cycle length of a module (1 = fixed point)

if nargin<3
    error('Not enough arguments!')
end

if nargin<4
    gene_sparsity = 0;
end;

if nargin<5
    cs_sign = 0;
    gs_sign = 1;
end

if nargin<6
    gs_sign = 1;
end

ctrh = .9; % correlation limit for convergence

warning off all

% get dimensions
[rows, cols] = size(norm_data1);

% Define starting Seeds

if numel(tests)==1
    if cs_sign==1
        if gene_sparsity==0
            row_weights = rand(rows,tests);
        else
            row_weights = zeros(rows,tests);
            for i=1:gene_sparsity
                r = ceil(rows*rand(tests,1));
                r = rows*(0:tests-1)'+r;
                row_weights(r) = 1;
            end
        end
    end
    if cs_sign==-1
        if gene_sparsity==0
            row_weights = -rand(rows,tests);
        else
            row_weights = zeros(rows,tests);
            for i=1:gene_sparsity
                r = ceil(rows*rand(tests,1));
                r = rows*(0:tests-1)'+r;
                row_weights(r) = -1;
            end
        end
    end
    if cs_sign==0
        if gene_sparsity==0
            row_weights = 2*rand(rows,tests)-1;
        else
            row_weights = zeros(rows,tests);
            for i=1:gene_sparsity
                r = ceil(rows*rand(tests,1));
                r = rows*(0:tests-1)'+r;
                row_weights(r) = 2*rand(1)-1;
            end
        end
    end
else
    row_weights = tests;
end

iterations = 0;
max_iterations = 50;
rec = ones(1,size(row_weights,2)); % Initalize recurrences

if gs_sign==0
    old_col_weights = signature6a(norm_data2', row_weights, trh2);
end
if gs_sign==1
    old_col_weights = signature6b(norm_data2', row_weights, trh2);
end
if gs_sign==-1
    old_col_weights = signature6c(norm_data2', row_weights, trh2);
end

fin_col_weights = [];
fin_row_weights = [];
fin_rec = [];

while(~isempty(old_col_weights) && (iterations < max_iterations))

    iterations = iterations + 1;
    if cs_sign==0
        row_weights = signature6a(norm_data1, old_col_weights, trh1);
    end
    if cs_sign==1
        row_weights = signature6b(norm_data1, old_col_weights, trh1);
    end
    if cs_sign==-1
        row_weights = signature6c(norm_data1, old_col_weights, trh1);
    end
    
    if gs_sign==0
        col_weights = signature6a(norm_data2', row_weights, trh2);
    end
    if gs_sign==1
        col_weights = signature6b(norm_data2', row_weights, trh2);
    end
    if gs_sign==-1
        col_weights = signature6c(norm_data2', row_weights, trh2);
    end
    % Check convergence & Similarity
    delta = diagcorrz(old_col_weights,col_weights)>ctrh;
    cnv = find(delta);
    ncnv = find(~delta);
    old_col_weights = col_weights;
    old_row_weights = row_weights;
    %%%% Filter & Throw out converged ones %%%%
    if ~isempty(cnv)
        gs = row_weights(:,cnv);
        cs = col_weights(:,cnv);
        rs = rec(cnv);
        
        %%%% Add converging genes %%%%
        fin_col_weights = [fin_col_weights cs];
        fin_row_weights = [fin_row_weights gs];
        fin_rec = [fin_rec rs];
    end
    
    old_col_weights = old_col_weights(:,ncnv);
    old_row_weights = old_row_weights(:,ncnv);
    rec = rec(ncnv);
    
    sel = find(any(old_col_weights~=0));
    old_col_weights = old_col_weights(:,sel);
    old_row_weights = old_row_weights(:,sel);
    rec = rec(sel);
    
    if cols<rows
        C = corrcoef([fin_col_weights old_col_weights]);
    else
        C = corrcoef([fin_row_weights old_row_weights]);
    end
    
    C = (abs(C)>ctrh);
    lim = size(fin_col_weights,2);
    if size(old_col_weights,2) > 0
        C = tril(C,0);
        sel = find(sum(C,2)==1);
        sel_a = sel(sel>lim);
        sel_a = sel_a-lim;
        sel_b = sel(sel<=lim);
        
        new_rec = [fin_rec rec]*C;
        fin_rec = new_rec(1:lim);
        rec = new_rec(lim+1:end);
        old_col_weights = old_col_weights(:,sel_a);
        rec = rec(sel_a);
        fin_col_weights = fin_col_weights(:,sel_b);
        fin_row_weights = fin_row_weights(:,sel_b);
        fin_rec = fin_rec(sel_b);
    end
end

%%
if nargout>3 && ~isempty(fin_col_weights)
    gs1 = fin_col_weights./repmat(sqrt(sum(fin_col_weights.^2,1)),size(fin_col_weights,1),1);
    cs1 = fin_row_weights./repmat(sqrt(sum(fin_row_weights.^2,1)),size(fin_row_weights,1),1);
    lam1 = sum(gs1.*ISA_multiply(norm_data2',cs1),1);
    lam2 = sum(cs1.*ISA_multiply(norm_data1,gs1),1);
    lam = sqrt(lam1.*lam2);
else
    lam = [];
end
