function [row_weights,col_weights] =...
    ISA_base(row_weights,trh1,trh2,cs_sign,gs_sign)
global norm_data1 norm_data2

if nargin<3
    error('Not enough arguments!')
end

warning off all

if gs_sign==1
    old_col_weights = signature6b(norm_data2', row_weights, trh1);
else
    old_col_weights = signature6b(norm_data2', row_weights, trh1);
end

iterations = 0;
max_iterations = 20;
cnv = 0;
while ~cnv && iterations<max_iterations
    iterations = iterations+1;
    if cs_sign==1
        row_weights = signature6b(norm_data1, old_col_weights, trh2);
    else
        row_weights = signature6a(norm_data1, old_col_weights, trh2);
    end
    if gs_sign==1
        col_weights = signature6b(norm_data2', row_weights, trh1);
    else
        col_weights = signature6a(norm_data2', row_weights, trh1);
    end

    delta = all(sign(old_col_weights)==sign(col_weights),1);
    old_col_weights = col_weights;
    cnv = all(delta);
end

