function [scores] = signature6b(data, w, threshold)
% finds those columns where the subset of 'data' deviates significantly from the average
% INPUT:
% data:      double matrix - contains the data to be analyzed
% weights:   double matrix - each column assigns a set of weights for the rows
% threshold: double scalar - defines the thresholds for sigificance
%
% OUTPUT:
% scores:  double matrix - each row contains the weights assigned for the columns

% get dimensions:
[data_rows, data_cols] = size(data);

% multiply each data element by the relevant score
% scores = (data * w);

scores = ISA_multiply(data,w);

% find significant entries (normalized deviation > 'threshold')

[me sd] = meanstd(scores);
% me = mean(scores);
% weight_squares_sums = eps + sum(w .^ 2);
% sd = sqrt(weight_squares_sums / data_cols);

ups = me + threshold .* sd;  

% sg = (scores > repmat(ups, data_rows, 1)); 

sg = zeros(size(scores,1),size(scores,2));
for j=1:size(scores,2)
    sg(:,j) = scores(:,j)>ups(j);
end

% return the weighted average of the data that is above threshold
% weight_sums = eps + sum(w.^2);
% scores = (scores .* significance) ./ repmat(weight_sums, data_rows, 1);
scores = (scores .* sg);
scores = scores./ repmat(max(abs(scores)), data_rows, 1);
