function [cs gs ds tr rc rob] = ...
    ping_pong_v7(tests,trh,signs,sparsity,imposed)

% these global variables have to be defined outside the function:
% global data1 data1T data2 data2T
% data1 = normalize(normalize(data_matrix1,1),2);
% data1T = normalize(data_matrix1,1)';
% data2 = normalize(normalize(data_matrix2,1),2);
% data2T = normalize(data_matrix2,1)';
%
% the input parameters:
% tests : number of initial seeds (or the seeds themselves)
% trh : thresholds...
% trh(1) : condition threshold (for data_matrix1)
% trh(2) : gene threshold
% trh(3) : condition threshold (for data_matrix2)
% trh(4) : drug threshold
% signs : [a b c] = [cond-, gene-, drug signs] ("0"=+/-, "1"=+, "-1"=-)
% sparsity (condition/seed), sparsity = 0 means random number
% imposed : forced seeds to be convereged
%
% the outputs:
% cs: condition scores
% gs: gene scores
% ds: drug scores
% tr: list of thresholds (3 x #co-modules)
% rc: recurrence of each co-module
% rob: robustness score of the co-module

global data1 data1T data2 data2T

if nargin<2
    signs = [0 0 0];
end

if nargin<3
    trh = [1 1 1 1];
end

if nargin<4
    sparsity = 1;
end

if nargin<5
    imposed3 = [];
end

%%%%%% Constants %%%%%%%
max_iterations = 50;
ctrh1 = .8;
ctrh2 = .99; % correlation limit for convergence
min_genes = 5;
min_rec = 1;
warning off all
%%%% Initialize values %%%%%%%%%%%%%%%%%%%%
[rows1, cols1] = size(data1);
[rows2, cols2] = size(data2);

%%%% Run algorithm %%%%%%%%%%%%%%%%%%%%%%%%%%%
initialize_ping_pong_3;
% PP_speed_median;
PP_speed;
cs = fin_col_weights;
gs = fin_row_weights1;
ds = fin_row_weights2;
tr = fin_trh;
rc = fin_rec;
rob = fin_rob;

%%%% Merging
C = corrcoef(gs);
C = (C>.99);
C = tril(C,0);
sel = find(sum(C,2)==1);
cs = cs(:,sel);
gs = gs(:,sel);
ds = ds(:,sel);
tr = tr(:,sel);
rc = rc(sel);
rob = rob(sel);

