function create_GOtree

% downloads/updates GO hierarchy tree

%%

disp('Read in GO tree text file...');
fid = fopen('./GO_files/gene_ontology_edit.obo','r');
if fid<0
    disp('File not found, downloading...');
    urlwrite('http://www.geneontology.org/ontology/gene_ontology_edit.obo','./GO_files/gene_ontology_edit.obo');
    fid = fopen('./GO_files/gene_ontology_edit.obo','r');
end
c = fread(fid,'*char');
fclose(fid);
c = c';

tt = strfind(c,'[Typedef]');
c = c(1:tt(1)-1);

excl_pos = strfind(c,' ! ');
term_pos = strfind(c,[char(10),'[Term]']);
name_pos = strfind(c,[char(10),'name: ']);
type_pos = strfind(c,[char(10),'namespace: ']);
id_pos = strfind(c,[char(10),'id: GO:']);
isa_pos = strfind(c,[char(10),'is_a: ']);
other_pos = strfind(c,[char(10),'relationship: ']);
term_pos = [term_pos length(c)];

M_bp = sparse(1e5,1e5);
M_cc = M_bp;
M_mf = M_bp;
labs = cell(1e5,1);
type = zeros(1e5,1);
n = length(id_pos);
h = waitbar(0,'Building GO tree');
for i=1:n
    if mod(i,1e3)==0
        waitbar(i/n,h);
    end
    labs{i} = c(name_pos(i)+7:type_pos(i)-1);
    x = str2double(c(id_pos(i)+8:id_pos(i)+14));
    sel1 = isa_pos(isa_pos>term_pos(i) & isa_pos<term_pos(i+1));
    sel2 = other_pos(other_pos>term_pos(i) & other_pos<term_pos(i+1));
    n1 = length(sel1);
    n2 = length(sel2);
    y = zeros(n1+n2,1);
    for j=1:n1
        y(j) = str2double(c(sel1(j)+10:excl_pos(find(sel1(j)<excl_pos,1,'first'))-1));
    end
    for j=1:n2
        tmp = excl_pos(find(sel2(j)<excl_pos,1,'first'))-1;
        y(n1+j) = str2double(c(tmp-6:tmp));
    end
    
    switch c(type_pos(i)+12)
        case 'm'
            M_mf(x,y) = 1;
        case 'b'
            M_bp(x,y) = 1;
        otherwise
            M_cc(x,y) = 1;
    end
end
waitbar(1,h);
close(h);

ss1 = find((sum(M_bp,2)+sum(M_bp,1)')~=0,1,'last');
ss2 = find((sum(M_cc,2)+sum(M_cc,1)')~=0,1,'last');
ss3 = find((sum(M_mf,2)+sum(M_mf,1)')~=0,1,'last');
ss = max([ss1 ss2 ss3]);
GOtree.bp.parents = M_bp(1:ss,1:ss);
GOtree.mf.parents = M_mf(1:ss,1:ss);
GOtree.cc.parents = M_cc(1:ss,1:ss);

GOtree.bp.term = labs;
GOtree.mf.term = labs;
GOtree.cc.term = labs;

save('./GO_files/GOtree.mat','GOtree');

