function [r p] = corrz(A,B)

if size(A,1)~=size(B,1)
    error('Matrices must have the same number of rows!')
end

A = A - repmat(mean(A,1),size(A,1),1);
B = B - repmat(mean(B,1),size(B,1),1);
sx = repmat(sum(A.^2,1)',1,size(B,2));
sy = repmat(sum(B.^2,1),size(A,2),1);

num = A'*B;
denom = (sx.*sy).^.5;

r = num./denom;

if nargout>1
    simnum = 1e3;
    [sv sp] = sort(rand(size(B,1),simnum),1);
    c = reshape(B(sp,:),size(B,1),simnum*size(B,2));
    r0 = corrz0(A,c);
    l_cnt = zeros(size(r));
    h_cnt = zeros(size(r));
    for i=1:simnum
        idx = i+simnum*(0:(size(B,2)-1));
        l_cnt = l_cnt+double(r0(:,idx)>r);
        h_cnt = h_cnt+double(r0(:,idx)<r);
    end
    l_cnt = l_cnt/simnum;
    h_cnt = h_cnt/simnum;
    p = 2*min(l_cnt,h_cnt);
end
    