if isempty(col_weights1)
    fin_col_weights = [];
    fin_row_weights1 = [];
    fin_row_weights2 = [];
    fin_trh = [];
    fin_rec = [];
    return
end

iterations = 0;

if size(trh,2)==1
    trh = repmat(trh,1,size(col_weights1,2));
end

rec = ones(1,size(col_weights1,2)); % Initalize recurrences

if signs(1)==1
    col_weights1 = abs(col_weights1);
end
if signs(1)==-1
    col_weights1 = -abs(col_weights1);
end

if signs(2)==1
    old_row_weights1 = signature6b(data1T, col_weights1, trh(2,:));
end
if signs(2)==-1
    old_row_weights1 = signature6c(data1T, col_weights1, trh(2,:));
end
if signs(2)==0
    old_row_weights1 = signature6a(data1T, col_weights1, trh(2,:));
end

if signs(3)==1
    old_row_weights2 = signature6b(data2T, col_weights1, trh(4,:));
end
if signs(3)==-1
    old_row_weights2 = signature6c(data2T, col_weights1, trh(4,:));
end
if signs(3)==0
    old_row_weights2 = signature6a(data2T, col_weights1, trh(4,:));
end

if signs(1)==1
    col_weights2 = signature6b(data2, old_row_weights2, trh(3,:));
end
if signs(1)==-1
    col_weights2 = signature6c(data2, old_row_weights2, trh(3,:));
end
if signs(1)==0
    col_weights2 = signature6a(data2, old_row_weights2, trh(3,:));
end

if signs(1)==1
    col_weights1 = signature6b(data1, old_row_weights1, trh(1,:));
end
if signs(1)==-1
    col_weights1 = signature6c(data1, old_row_weights1, trh(1,:));
end
if signs(1)==0
    col_weights1 = signature6a(data1, old_row_weights1, trh(1,:));
end

old_col_weights = .5*(col_weights1+col_weights2);

fin_col_weights = [];
fin_row_weights1 = [];
fin_row_weights2 = [];
fin_trh = [];
fin_rec = [];
totseed = size(old_row_weights1,2);

fprintf('Processed seeds:       ');
fprintf('\b\b\b\b\b\b %3.0f %%',0);
while(~isempty(old_col_weights) && (iterations < max_iterations))
    iterations = iterations + 1;
    
    if signs(3)==1
        row_weights2 = signature6b(data2T, old_col_weights, trh(4,:));
    end
    if signs(3)==-1
        row_weights2 = signature6c(data2T, old_col_weights, trh(4,:));
    end
    if signs(3)==0
        row_weights2 = signature6a(data2T, old_col_weights, trh(4,:));
    end
    
    if signs(2)==1
        row_weights1 = signature6b(data1T, old_col_weights, trh(2,:));
    end
    if signs(2)==-1
        row_weights1 = signature6c(data1T, old_col_weights, trh(2,:));
    end
    if signs(2)==0
        row_weights1 = signature6a(data1T, old_col_weights, trh(2,:));
    end
    
    if signs(1)==1
        col_weights2 = signature6b(data2, row_weights2, trh(3,:));
    end
    if signs(1)==-1
        col_weights2 = signature6c(data2, row_weights2, trh(3,:));
    end
    if signs(1)==0
        col_weights2 = signature6a(data2, row_weights2, trh(3,:));
    end
    
    if signs(1)==1
        col_weights1 = signature6b(data1, row_weights1, trh(1,:));
    end
    if signs(1)==-1
        col_weights1 = signature6c(data1, row_weights1, trh(1,:));
    end
    if signs(1)==0
        col_weights1 = signature6a(data1, row_weights1, trh(1,:));
    end
    
    col_weights = .5*(col_weights1+col_weights2);
    % Check convergence & Similarity

    d0 = diagcorrz(col_weights,old_col_weights);
    dd = diagcorrz(col_weights1,col_weights2);
    c1 = dd>ctrh1;
    c2 = diagcorrz(row_weights1,old_row_weights1)>ctrh2;
    c3 = diagcorrz(row_weights2,old_row_weights2)>ctrh2;
    
    c = c1.*c2.*c3;
    cnv = find(c);

    c0 = d0-dd > ctrh2-ctrh1; % (1-dd)>10*(1-d0);
    
    old_row_weights1 = row_weights1;
    old_row_weights2 = row_weights2;
    old_col_weights = col_weights;

    %%%% Filter & Throw out converged ones %%%%
    if ~isempty(cnv)
        %%%% Add converging genes %%%%
        fin_col_weights = [fin_col_weights col_weights(:,cnv)];
        fin_row_weights1 = [fin_row_weights1 row_weights1(:,cnv)];
        fin_row_weights2 = [fin_row_weights2 row_weights2(:,cnv)];
        fin_trh = [fin_trh trh(:,cnv)];
        fin_rec = [fin_rec rec(cnv)];
    end
    
    ncnv = find(~c & any(old_col_weights~=0) & ~c0);
    
    old_row_weights1 = old_row_weights1(:,ncnv);
    old_row_weights2 = old_row_weights2(:,ncnv);
    old_col_weights = old_col_weights(:,ncnv);
    trh = trh(:,ncnv);
    rec = rec(ncnv);
   
    C = corrcoef([fin_col_weights old_col_weights]);
    C = (abs(C)>ctrh2);
    lim = size(fin_col_weights,2);
    if size(old_col_weights,2) > 0
        C = tril(C,0);
        sel = find(sum(C,2)==1);
        sel_a = sel(sel>lim);
        sel_a = sel_a-lim;
        sel_b = sel(sel<=lim);
        
        new_rec = [fin_rec rec]*C;
        fin_rec = new_rec(1:lim);
        rec = new_rec(lim+1:end);
        old_col_weights = old_col_weights(:,sel_a);
        old_row_weights1 = old_row_weights1(:,sel_a);
        old_row_weights2 = old_row_weights2(:,sel_a);
        trh = trh(:,sel_a);
        rec = rec(sel_a);

        fin_col_weights = fin_col_weights(:,sel_b);
        fin_row_weights1 = fin_row_weights1(:,sel_b);
        fin_row_weights2 = fin_row_weights2(:,sel_b);
        fin_trh = fin_trh(:,sel_b);
        fin_rec = fin_rec(sel_b);
    end
    fprintf(['\b\b\b\b\b\b %3.0f %%'],round(100*(1-size(col_weights1,2)/totseed)));
end
fprintf(['\b\b\b\b\b\b %3.0f %%\n'],round(100));

temp = 1:size(fin_row_weights2,1);
so = (temp*fin_row_weights2)./sum(fin_row_weights2,1);
[sv sp] = sort(so);
fin_col_weights = fin_col_weights(:,sp);
fin_row_weights1 = fin_row_weights1(:,sp);
fin_row_weights2 = fin_row_weights2(:,sp);
fin_rec = fin_rec(sp);

%%%% get robustness score
if ~isempty(fin_rec)
    cs1 = fin_col_weights./repmat(sqrt(sum(fin_col_weights.^2,1)),size(fin_col_weights,1),1);
    gs1 = fin_row_weights1./repmat(sqrt(sum(fin_row_weights1.^2,1)),size(fin_row_weights1,1),1);
    ds1 = fin_row_weights2./repmat(sqrt(sum(fin_row_weights2.^2,1)),size(fin_row_weights2,1),1);
    lam1 = sum(gs1.*ISA_multiply(data1T,cs1),1);
    lam2 = sum(ds1.*ISA_multiply(data2T,cs1),1);
    lam3 = sum(cs1.*ISA_multiply(data1,gs1),1);
    lam4 = sum(cs1.*ISA_multiply(data2,ds1),1);
    fin_rob = sqrt(lam1.*lam2.*lam3.*lam4);
else
    fin_rob = [];
end

