function [fin_col_weights fin_row_weights1 fin_row_weights2] = ...
    PP1_sweep(row_weights1,trh)

global data1 data1T data2 data2T

iterations = 0;
max_iterations = 15;
ctrh = .99;

col_weights = signature6a(data1, row_weights1, trh(1));
old_row_weights2 = signature6b(data2T, col_weights, trh(4));
old_row_weights1 = row_weights1;

fin_col_weights = [];
fin_row_weights1 = [];
fin_row_weights2 = [];
totseed = size(old_row_weights1,2);

while(~isempty(old_row_weights2) && (iterations < max_iterations))
    iterations = iterations + 1;
    
    row_weights2 = signature6b(data2T, col_weights, trh(4));
    row_weights1 = signature6b(data1T, col_weights, trh(2));
    col_weights2 = signature6a(data2, row_weights2, trh(3));
    col_weights1 = signature6a(data1, row_weights1, trh(1));
    col_weights = .5*(col_weights1+col_weights2);
    % Check convergence & Similarity
    
    V1 = sign(col_weights1);
    W1 = sign(col_weights2);
    c1 = double(sum(V1==W1,1)==size(V1,1));
    
    V1 = sign(old_row_weights1);
    W1 = sign(row_weights1);
    c2 = double(sum(V1==W1,1)==size(V1,1));
    
    V1 = sign(old_row_weights2);
    W1 = sign(row_weights2);
    c3 = double(sum(V1==W1,1)==size(V1,1));
    c = c1.*c2.*c3;
    cnv = find(c);
    
    old_row_weights1 = row_weights1;
    old_row_weights2 = row_weights2;

    %%%% Filter & Throw out converged ones %%%%
    if ~isempty(cnv)
        %%%% Add converging genes %%%%
        fin_col_weights = [fin_col_weights col_weights1(:,cnv)];
        fin_row_weights1 = [fin_row_weights1 row_weights1(:,cnv)];
        fin_row_weights2 = [fin_row_weights2 row_weights2(:,cnv)];
    end
    
    ncnv = find(~c & any(row_weights2~=0));
    
    old_row_weights1 = old_row_weights1(:,ncnv);
    old_row_weights2 = old_row_weights2(:,ncnv);
    col_weights = col_weights(:,ncnv);
   
    C = corrcoef([fin_col_weights col_weights]);
    C = (C>ctrh);
    lim = size(fin_col_weights,2);
    if size(col_weights1,2) > 0
        C = tril(C,0);
        sel = find(sum(C,2)==1);
        sel_a = sel(sel>lim);
        sel_a = sel_a-lim;
        sel_b = sel(sel<=lim);
        
        col_weights = col_weights(:,sel_a);
        old_row_weights1 = old_row_weights1(:,sel_a);
        old_row_weights2 = old_row_weights2(:,sel_a);

        fin_col_weights = fin_col_weights(:,sel_b);
        fin_row_weights1 = fin_row_weights1(:,sel_b);
        fin_row_weights2 = fin_row_weights2(:,sel_b);
    end
end

