function [cs gs tr p_bp p_mf p_cc p_kegg lab_go lab_kegg] = ...
    newISA(data,gene_info,cond_info,tests,tr1,tr2,...
    gene_sparsity,gs_sign,cs_sign,annot_file_go,annot_file_kegg)
% Version : 1.01 
% Author : Zoltan Kutalik
% Institute : University of Lausanne, Switzerland

%% INPUTS
% data : (cell) if 1 element then normalization is done by the program
%               if 2 elements (norm_data1, norm_data2)
%               then normalization was done by the user
%               rows = conditions / cols = genes
% gene_info : contains the Gene Symbols
% cond_info : arbitrary condition information
% tests : number of random seeds fed into the algorithm
% tr1 : vector containing the cond thresholds to sweep
% tr2 : vector containing the gene thresholds to sweep
% gene_sparsity : how sparse the seeds should be 
% gs_sign : sign of gene scores (1=+, 0=+/-)
% cs_sign : sign of cond scores (1=+, 0=+/-)
% annot_file : annotation filename (as it can be found on the www.geneontology.org website

%% OUTPUTS
% cs : condition scores
% gs : gene scores
% tr : thresholds where the given module was found
% p_bp : #modules*#GO BP terms matrix, -log10 enrichment p-values
% p_mf, p_cc : same for MF and CC
% lab : GO term labels

clc
%% Missing inputs

if nargin==0
    error('No data matrix is given!')
end

global norm_data1 norm_data2

if nargin<10
    annot_file_go = 'gene_association.goa_human';
end

if nargin<11
    annot_file_kegg = 'hsa';
end

if nargin<9
    cs_sign = 0;
end

if nargin<8
    gs_sign = 1;
end    

if nargin<7
    gene_sparsity=1;
end

if nargin==5
    tr2 = tr1;
end

if nargin<5
    tr1 = 1:.5:3;
    tr2 = tr1;
end

if nargin<4
    tests = 100;
end

if length(data)==1
    G = data{1};
%     norm_data1 = normalize(G,2);
%     norm_data2 = normalize(norm_data1,1);
    norm_data1 = normalize(normalize(G,1),2);
    norm_data2 = normalize(normalize(G,2),1);
end

if length(data)==2
    norm_data1 = data{1};
    norm_data2 = data{2};
end

if nargin<3
    cond_info = cell(size(G,1),1);
    for i=1:size(G,1)
        cond_info{i} = num2str(i);
    end
end

if nargin<2
    gene_info = cell(size(G,2),1);
    for i=1:size(G,2)
        gene_info{i} = num2str(i);
    end
end

%% Finding modules
disp('Scanning thresholds...');
cs = [];
gs = [];
tr = [];
[rows cols] = size(norm_data1);
h = waitbar(0,'Scanning thresholds...');
for i=1:length(tr1)
    for j=1:length(tr2)
        waitbar(((i-1)*length(tr2)+j)/(length(tr1)*length(tr2)),h);
        [a,b] = ISA_v3a_silent(tests,tr1(i),tr2(j),gene_sparsity,cs_sign,gs_sign);
        if ~isempty(cs) && ~isempty(a)
            if rows<cols
                C = abs(corrz(cs,a));
            else
                C = abs(corrz(gs,b));
            end
            sel = find(max(C,[],1)<.99);
            a = a(:,sel);
            b = b(:,sel);
        end
        cs = [cs a];
        gs = [gs b];
        tr = [tr repmat([tr1(i);tr2(j)],1,size(a,2))];
    end
end
close(h);
drawnow

%% Sweeping
disp('Sweeping Up...')   
[cs gs tr] = SweepUp(cs,gs,tr,tr1,tr2);
disp('Sweeping Down...')   
[cs gs tr] = SweepDown(cs,gs,tr,tr1,tr2);


%% GO annotation

if nargout>3 && nargin>1
    [p_bp p_cc p_mf lab_go] = GO_annot(annot_file_go,gene_info,gs);
    [p_kegg lab_kegg] = KEGG_annot(annot_file_kegg,gene_info,gs);
end

%% View 1: Module tree
% 
% user_entry = input('Would you like to build module tree?', 's');    
% 
% if upper(user_entry)=='Y'
%     mod_lab = cell(size(cs,2),1);
%     if ~isempty(p_bp)
%         user_entry = input('BP/MF/CC?', 's');
%         switch upper(user_entry)
%             case {'BP'}
%                 for i=1:size(p_bp,1)
%                     seli = find(p_bp(i,:)>1.3);
%                     tmp = lab_bp(seli)';
%                     speci = sum(p_bp(:,seli)>1.3,1);
%                     [sv sp] = min(speci);
%                     mod_lab{i} = tmp(sp);
%                     if isempty(mod_lab{i})
%                         mod_lab{i} = num2str(i);
%                     end
%                 end
%             case {'MF'}
%                 for i=1:size(p_mf,1)
%                     seli = find(p_mf(i,:)>1.3);
%                     tmp = lab_mf(seli)';
%                     speci = sum(p_mf(:,seli)>1.3,1);
%                     [sv sp] = min(speci);
%                     mod_lab{i} = tmp(sp);
%                     if isempty(mod_lab{i})
%                         mod_lab{i} = num2str(i);
%                     end                    
%                 end    
%             case {'CC'}
%                 for i=1:size(p_cc,1)
%                     seli = find(p_cc(i,:)>1.3);
%                     tmp = lab_cc(seli)';
%                     speci = sum(p_cc(:,seli)>1.3,1);
%                     [sv sp] = min(speci);
%                     mod_lab{i} = tmp(sp);
%                     if isempty(mod_lab{i})
%                         mod_lab{i} = num2str(i);
%                     end                    
%                 end    
%         end
%     else
%         for i=1:size(cs,2)
%             mod_lab{i} = num2str(i);
%         end
%     end
%     ViewModuleTree(cs,gs,tr,mod_lab,2,50);
% end    
%     
% 

