function build_GO_tree(M,Mt)

subplot('Position',[0.05 0.05 .9 .8]);
if nargin<2
    for i=1:size(M,1)
        Mt{i} = num2str(i);
    end
end

roots = find(sum(M,2)==0);

for i=1:length(roots)
    y(roots(i)) = i/(length(roots)+1);
    x(roots(i)) = 0;
end

level = -1;
while ~isempty(roots)
    leaf = [];
    for i=1:length(roots)
        new_leaf = find(M(:,roots(i))~=0);
        leaf = [leaf;new_leaf];
    end
    % leaf = union(leaf,[]);
    for i=1:length(leaf)
        y(leaf(i)) = i/(length(leaf)+1);
        x(leaf(i)) = level;
    end
    for i=1:length(roots)
        new_leaf = find(M(:,roots(i))~=0);
        if ~isempty(new_leaf)
            for j=1:length(new_leaf)
                plot(-[level+1 level],...
                    [y(roots(i)) y(new_leaf(j))],'-');
                hold on
            end
        end
    end
    
    roots = leaf;
    level = level-1;
end

for i=1:size(M,1)
%    if isempty(str2num(Mt{i}))
        h = text(-x(i),y(i),Mt{i},'Color','b','EdgeColor','k','BackgroundColor','w','rotation',30);
%    end
end
set(gca,'Color',[.8 .8 .8],'XColor',[.8 .8 .8],'YColor',[.8 .8 .8],'XTick',[],'YTick',[])
set(gcf,'Name','Module Tree');
xlim([min(-x) max(-x)+1]) 


    