function [cs gs ds tr] = SweepUpPP(cs,gs,ds,tr,trhs1,trhs2,trhs3,...
    scenario)

% scenario 1: cs: +/-, gs: +/-, ds: +/-
% scenario 2: cs: +/-, gs: +  , ds: +

global data1 data1T data2 data2T

if nargin==4
    trhs1 = unique(tr(1,:)','rows')';
    trhs2 = unique(tr(2,:)','rows')';
    trhs3 = unique(tr(3,:)','rows')';
end    
if nargin==5
    trhs3 = trhs1;
    trhs2 = trhs1;
end
if nargin==6
    trhs3 = trhs2;
end

h = waitbar(0);
set(h,'Name','Sweeping up...');
for i=1:length(trhs1)
    for j=1:length(trhs2)
        for k=1:length(trhs3)
            waitbar(((i-1)*length(trhs2)*length(trhs3)+...
                (j-1)*length(trhs3)+k)/...
                (length(trhs1)*length(trhs2)*length(trhs3)),h,...
                [num2str(((i-1)*length(trhs2)*length(trhs3)+...
                (j-1)*length(trhs3)+k)),' / ',...
                num2str(length(trhs1)*length(trhs2)*length(trhs3))]);
            sel = find(tr(1,:)==trhs1(i) & tr(2,:)==trhs2(j) & ...
                tr(3,:)==trhs3(i));
            if i<length(trhs1) 
                sel1 = find(tr(1,:)==trhs1(i+1) & tr(2,:)==trhs2(j) & ...
                    tr(3,:)==trhs3(k));
                eval(['[a1 b1 c1] = PP',num2str(scenario),...
                    '_sweep(gs(:,sel),[trhs1(i+1),trhs2(j),trhs1(i+1),trhs3(k)]);']);

                if size(b1,2)>0
                    C1 = corrz(gs(:,sel1),b1);
                    if ~isempty(C1)
                        seli = find(max(C1,1)<.9);
                        cs = [cs a1(:,seli)];
                        gs = [gs b1(:,seli)];
                        ds = [ds c1(:,seli)];
                        tr = [tr repmat([trhs1(i+1);trhs2(j);trhs3(k)],1,length(seli))];
                    else
                        cs = [cs a1];
                        gs = [gs b1];
                        ds = [ds c1];
                        tr = [tr repmat([trhs1(i+1);trhs2(j);trhs3(k)],1,size(a1,2))];
                    end                    
                end
            end
            if j<length(trhs2) 
                sel1 = find(tr(1,:)==trhs1(i) & tr(2,:)==trhs2(j+1) & ...
                    tr(3,:)==trhs3(k));
                eval(['[a1 b1 c1] = PP',num2str(scenario),...
                    '_sweep(gs(:,sel),[trhs1(i),trhs2(j+1),trhs1(i),trhs3(k)]);']);

                if size(b1,2)>0
                    C1 = corrz(gs(:,sel1),b1);
                    if ~isempty(C1)
                        seli = find(max(C1,1)<.9);
                        cs = [cs a1(:,seli)];
                        gs = [gs b1(:,seli)];
                        ds = [ds c1(:,seli)];
                        tr = [tr repmat([trhs1(i);trhs2(j+1);trhs3(k)],1,length(seli))];
                    else
                        cs = [cs a1];
                        gs = [gs b1];
                        ds = [ds c1];
                        tr = [tr repmat([trhs1(i);trhs2(j+1);trhs3(k)],1,size(a1,2))];
                    end                    
                end
            end
            if k<length(trhs3) 
                sel1 = find(tr(1,:)==trhs1(i) & tr(2,:)==trhs2(j) & ...
                    tr(3,:)==trhs3(k+1));
                eval(['[a1 b1 c1] = PP',num2str(scenario),...
                    '_sweep(gs(:,sel),[trhs1(i),trhs2(j),trhs1(i),trhs3(k+1)]);']);
                if size(b1,2)>0
                    C1 = corrz(gs(:,sel1),b1);
                    if ~isempty(C1)
                        seli = find(max(C1,1)<.9);
                        cs = [cs a1(:,seli)];
                        gs = [gs b1(:,seli)];
                        ds = [ds c1(:,seli)];
                        tr = [tr repmat([trhs1(i);trhs2(j);trhs3(k+1)],1,length(seli))];
                    else
                        cs = [cs a1];
                        gs = [gs b1];
                        ds = [ds c1];
                        tr = [tr repmat([trhs1(i);trhs2(j);trhs3(k+1)],1,size(a1,2))];
                    end                    
                end
            end
        end
    end
end
close(h)