function [fin_col_weights fin_row_weights1 fin_row_weights2] = ...
    PP1_sweep(row_weights1,trh)

global data1 data1T data2 data2T

iterations = 0;
max_iterations = 15;
ctrh = .99;

col_weights1 = signature6a(data1, row_weights1, trh(1));
old_row_weights1 = signature6a(data1T, col_weights1, trh(2));
old_row_weights2 = signature6a(data2T, col_weights1, trh(4));
col_weights2 = signature6a(data2, old_row_weights2, trh(3));
col_weights1 = signature6a(data1, old_row_weights1, trh(1));
old_col_weights = .5*(col_weights1+col_weights2);

fin_col_weights = [];
fin_row_weights1 = [];
fin_row_weights2 = [];

while(~isempty(old_col_weights) && (iterations < max_iterations))
    iterations = iterations + 1;
    
    row_weights2 = signature6a(data2T, old_col_weights, trh(4));
    row_weights1 = signature6a(data1T, old_col_weights, trh(2));
    col_weights2 = signature6a(data2, row_weights2, trh(3));
    col_weights1 = signature6a(data1, row_weights1, trh(1));
    col_weights = .5*(col_weights1+col_weights2);
    % Check convergence & Similarity

    d0 = diagcorrz(col_weights,old_col_weights);
    dd = diagcorrz(col_weights1,col_weights2);
    c1 = dd>.95;
    c2 = diagcorrz(row_weights1,old_row_weights1)>.95;
    c3 = diagcorrz(row_weights2,old_row_weights2)>.95;
    
    c = c1.*c2.*c3;
    cnv = find(c);

    c0 = (1-dd)>10*(1-d0);
    
    old_row_weights1 = row_weights1;
    old_row_weights2 = row_weights2;
    old_col_weights = col_weights;

    %%%% Filter & Throw out converged ones %%%%
    if ~isempty(cnv)
        %%%% Add converging genes %%%%
        fin_col_weights = [fin_col_weights col_weights(:,cnv)];
        fin_row_weights1 = [fin_row_weights1 row_weights1(:,cnv)];
        fin_row_weights2 = [fin_row_weights2 row_weights2(:,cnv)];
    end
    
    ncnv = find(~c & any(old_col_weights~=0) & ~c0);
    
    old_row_weights1 = old_row_weights1(:,ncnv);
    old_row_weights2 = old_row_weights2(:,ncnv);
    old_col_weights = old_col_weights(:,ncnv);
   
    C = corrcoef([fin_col_weights old_col_weights]);
    C = (abs(C)>ctrh);
    lim = size(fin_col_weights,2);
    if size(old_col_weights,2) > 0
        C = tril(C,0);
        sel = find(sum(C,2)==1);
        sel_a = sel(sel>lim);
        sel_a = sel_a-lim;
        sel_b = sel(sel<=lim);
        
        old_col_weights = old_col_weights(:,sel_a);
        old_row_weights1 = old_row_weights1(:,sel_a);
        old_row_weights2 = old_row_weights2(:,sel_a);

        fin_col_weights = fin_col_weights(:,sel_b);
        fin_row_weights1 = fin_row_weights1(:,sel_b);
        fin_row_weights2 = fin_row_weights2(:,sel_b);
    end
end

