function [CDIcut] = CDIindex(X,Y,Z,length,winddirection,lambda)

Filter = fspecial('motion', length, lambda);
Zf = imfilter(Z,Filter);

P = tand(lambda)*cosd(winddirection).*X + tand(lambda)*sind(winddirection).*Y;

Zfp = P+Zf;

Zfpfilled = imfill(Zfp);

A1 = wflowacc(X,Y,Zfpfilled);
A2 = wflowacc(X,Y,P);

CDI = A1./A2;

[rows, cols] = size(CDI);
CDIcut = CDI(2:rows-1,2:cols-1);
