%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Exercice 3.3 condition / boucles
%       
% This M-file plots the land-surface-elevation profile of a river
% terrace and soil thickness. The profile coordinates are
% specified using for loops, which can be edited to
% create different profiles.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% x-coord. axis of a profile crossing the terrace surface

x = [0 10 20 30 40 50 60 70 80 90 100];

% z-coord. ordinate : the local elevation zeta so that z = f(x)

z = [25 25 25 25 25 15 5 5 5 5 5];

% transpose the row matrix x into a column matrix xx
% idem for z
xx = x';
zz = z';

% put the two matrix xx and zz together

xzdata = [xx zz];

% separate the matrix xzdata into two matrix xdata and zdata
% NB: when working with loop, preallocate memory for speed by declaring 
%     the variables first

xdata = zeros(11,1);
zdata = zeros(11,1);

for i = 1:11
    xdata(i) = xzdata(i,1);
    zdata(i) = xzdata(i,2);
end

% let's plot the elevation of the land surface along the coordinate line x

figure
%plot(xdata,zdata,'-r','LineWidth',2)
plot(xzdata(:,1),xzdata(:,2),'-r','LineWidth',2)
axis([min(x) max(x) 0 30]);

% add the profile of the soil thickness

xmin = 0;
xmax = 100;

%x-coord. axis is 100m long for exemple, so that you create a soil
%thickness data one every meter
imax = 101;

%create the step increment of the x-coord axis
dx = xmax/(imax - 1);

%enter the soil thickness (normal to the ground)
soilthick = 2;

%create the x-coord
for i = 1:imax
X(i) = (i - 1)*dx;
end

%compute the elevation
for i = 1:41
Z(i) = 25;
end
for i = 42:61
Z(i) = Z(i-1) - 1;
end
for i = 62:imax
Z(i) = 5;
end

%compute the soil thickness
for i = 1:imax
S(i) = Z(i) - soilthick;
end

%let's plot the elevation of the land surface along the coordinate line x
%with the soil thickness
figure
plot(X,Z,X,S,'LineWidth',1.5)
axis([xmin xmax 0 30])

%the soil thickness of the bench is proportional to the slope
%use the function cos of the slope

%compute the slope of the profile
slp = zeros(imax,1);
for i = 1:imax-1
    slp(i+1) =  atan((Z(i+1)-Z(i))/dx);
    %slp_deg(i) = slp(i)*180/pi;
end

%compute the new soil thickness
for i = 1:imax
Snew(i) = Z(i) - soilthick * cos(slp(i));
end

%let's replot the new soil thickness
figure
plot(X,Z,X,Snew,'LineWidth',1.5)
axis([xmin xmax 0 30])