function [Data_seg, Seg_mask] = Data_segmentation(Data, partition);
%Data segmentation routine: allows to group pixels with similar
%charachteristics in one decay curve.
% Data: Data set to be segmentated
% partition = 1 segmentation by intensity
% partition = 2 segmentation by lifetime
%Data_seg: Data set with reduced number of pixels
%Seg_mask: map of image segmentation

Nb_pix = size(Data,1)-1;
im_size = round(sqrt(Nb_pix));
T_length = size(Data,2);
if partition == 1
    Int_col = sum(Data(2:Nb_pix+1,:),2);
    Int_im = col2im(Int_col,[1 1],[im_size im_size]);
    Int_im = Int_im';
    Seg_mask = Segmentation_tot(Int_im);
else
    [I_max, T_max] = max(Data(2:Nb_pix+1,:), [],2);
    T_max = round(mean(T_max));
    Dt = floor((T_length-T_max)/2);
    D0 = sum(Data(2:Nb_pix+1,T_max:T_max+Dt-1),2);
    D1 = sum(Data(2:Nb_pix+1,T_max+Dt:T_max+2*Dt),2);
    warning off MATLAB:divideByZero
    LT_col = -Dt./log(D1.^2./D0.^2);
    warning on
    Int_col = sum(Data(2:Nb_pix+1,:),2);
    Int_low = find(Int_col < max(Int_col)/10);
    LT_col(Int_low) = 0;
    bad_LT = find(LT_col< 0);
    LT_col(bad_LT) = 0;
    bad_LT = find(LT_col>50);
    LT_col(bad_LT) = 0;
    LT_im = col2im(LT_col,[1 1],[im_size im_size]);
    LT_im = LT_im';
    Seg_mask = Segmentation_tot(LT_im);
end
Nb_seg = size(Seg_mask,3);
Data_seg = zeros(Nb_seg+1, T_length);
Data_seg(1,:) = Data(1,:);
for i = 1:Nb_seg
    Seg_col = im2col(Seg_mask(:,:,i)',[1 1]);
    Non_Z = find(Seg_col);
    Data_seg(i+1,:) = sum(Data(Non_Z+1,:),1)./length(Non_Z);       %
end



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                       %
%____________________ SUB-ROUTINES _____________________%
%                                                       %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%_____________Full Segmentation of image_________________________

function Seg_mask = Segmentation_tot(Int_im);
%segments a whole image in many different areas based on the difference in
%intensity. The area has to be selected by the user. Many consecutive
%segmentation can be realized.

Nb_pixel = size(Int_im,1);

Seg_mask = zeros(Nb_pixel, Nb_pixel,1);
OK = 1;
while OK ~= 0
    Nb_seg = size(Seg_mask,3);
    
    if Nb_seg == 1
        [Seg_mask, Seg_int] = Segment_image(Int_im);
    else
        clear Nb_seg_tot
        OK = 0;
        for i = 1:Nb_seg
            figure(1)
            imagesc(Seg_int(:,:,i))
            colormap(hot)
            button = questdlg('Segment again?', 'Further Segmentation','Yes','No', 'No');
            OK_str = char(button);
            
            switch lower(OK_str)
                case 'yes'
                    OK = OK + 1;
                    [Seg_mask_F, Seg_int_F] = Segment_image(Seg_int(:,:,i));
                    Nb_seg_F = size(Seg_mask_F,3)-1;
                    Seg_mask_4D(1:Nb_pixel,1:Nb_pixel,1:Nb_seg_F,i) = Seg_mask_F(:,:,2:Nb_seg_F+1);
                    Seg_int_4D(1:Nb_pixel,1:Nb_pixel,1:Nb_seg_F,i) = Seg_int_F(:,:,2:Nb_seg_F+1);
                    Nb_seg_tot(i) = Nb_seg_F;
                case 'no'
                    OK = OK;
                    Seg_mask_4D(1:Nb_pixel,1:Nb_pixel,1,i) = Seg_mask(:,:,i);
                    Seg_int_4D(1:Nb_pixel,1:Nb_pixel,1,i) = Seg_int(:,:,i);
                    Nb_seg_tot(i) = 1;
            end
        end
        Seg_mask = zeros(Nb_pixel,Nb_pixel, sum(Nb_seg_tot));
        Seg_int = zeros(Nb_pixel,Nb_pixel, sum(Nb_seg_tot));
        ind_3D = 1;
        for j = 1:Nb_seg
            Seg_mask(1:Nb_pixel,1:Nb_pixel,ind_3D:ind_3D + Nb_seg_tot(j)-1) = Seg_mask_4D(1:Nb_pixel,1:Nb_pixel,1:Nb_seg_tot(j),j);
            Seg_int(1:Nb_pixel,1:Nb_pixel,ind_3D:ind_3D + Nb_seg_tot(j)-1) = Seg_int_4D(1:Nb_pixel,1:Nb_pixel,1:Nb_seg_tot(j),j);
            ind_3D = ind_3D + Nb_seg_tot(j);
        end
    end
end

Nb_seg = size(Seg_mask,3);
Tot_im = zeros(Nb_pixel,Nb_pixel);
for k = 1:Nb_seg
    Tot_im = Tot_im + k*Seg_mask(:,:,k);
end

clear  Int_im Nb_pixel Nb_seg Nb_seg_F Nb_seg_tot OK OK_str Seg_int_4D Seg_int_F Seg_mask_4D Seg_mask_F
clear  button i j ind_3D Tot_im k  



%__________Segmentation of image_______________


function [Seg_mask, Seg_int] = Segment_image(Int_im)
%segments a whole image in many different areas based on the difference in
%intensity. The area has to be selected by the user.

im_size = size(Int_im,1);
figure(1)
imagesc(Int_im)
colormap(hot)
i = 1;
j = 0;
fprintf('Select region of same intensity on the figure using the polygone tool\n\nDON''T FORGET TO SELECT THE BACKGROUND\n\nHIT RETURN WHEN DONE\n\n')
while j == 0
    BW_mask(:,:,i) = roipoly;
    [y, x] = find(BW_mask(:,:,i));
    if isempty(x)
        j = 1;
        i= i-1;
    else
        j = 0;
        Reg_tot = 0;
        for k = 1: length(x)
            Reg_tot = Reg_tot + Int_im(y(k),x(k));
        end
        Reg_ave(i) = Reg_tot/length(x);
        i= i+1;
    end
    clear x y
end
Reg_ave = sort(Reg_ave);
distance = zeros(im_size,im_size,i);
for m = 1:i
   distance(:,:,m) = ((Int_im-Reg_ave(m)).^2 ).^0.5;
end

[value, label] = min(distance,[],3); 

Seg_mask = zeros(im_size,im_size,i);
for m = 1:i
    Seg = label;
    Seg(label ~= m) = 0;
    Seg_mask(:,:,m) = Seg/m;
    Seg_int(:,:,m) = Seg_mask(:,:,m).*Int_im;
end
