function Var = PositionAnalysis(Var)
BaseDir = cd;
addpath(fullfile(BaseDir, 'CommonProcess'))


try
    Var.Analysis.Worker = get(getCurrentWorker, 'Name');

    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %Runs through all frames To segment all IllumSeg images
    Var.Analysis.FrameIter = 0;
    Var.Analysis.FrameModulo =1;
    for Frame = 1:Var.Analysis.FrameModulo: Var.Analysis.NumFrame
        Var.Analysis.CurrentFrame = Frame;
        Var.Analysis.FrameIter = Var.Analysis.FrameIter +1;
        if Var.Analysis.NumFrame == 1
            Var.Analysis.TrueNbFrame = 1;
            Var.Analysis.FrameAnalyzed = 'Single';
        else
            Var.Analysis.TrueNbFrame = ceil(Var.Analysis.NumFrame/Var.Analysis.FrameModulo);
            if (Var.Analysis.TrueNbFrame-1)*Var.Analysis.FrameModulo+1 == Frame
                Var.Analysis.FrameAnalyzed = 'Last';
            elseif Frame == 1
                Var.Analysis.FrameAnalyzed = 'First';
            else
                Var.Analysis.FrameAnalyzed = 'Middle';
            end
        end

        %% load all Images
        for L = 1:length(Var.Analysis.LoadIllum)
            Var = LoadImage(Var, L);
            drawnow
        end
        if Frame == 1
            fprintf('Frame: %3d', Frame)
        else
            fprintf('\b\b\b%3d', Frame)
        end
        assignin('base','Var_1',Var);

        %% Segmentation Part
        if strcmp(Var.Experiment.Segmentation, 'Nucl_Cell')
            %Segment Nucleus in images
            Var = SegmentYeastFluo(Var, 1);
 
            %Track Nuclei between present image and the previous one
            Var = TrackObjects(Var, 1);

            %Get cell area around segmented Nuclei
            Var = CellsAroundNuclHough(Var, 1);
        elseif strcmp(Var.Experiment.Segmentation, 'BrightField')

            %Segment DIC images
            Var = SegmentYeastPhase(Var, 1);

            %Track Group of cells between present image and the previous one
            Var = TrackObjects(Var, 1);

                 %Split group of cells in individual cells
                Var = SplitGroupHough(Var, 1);

            %Track Single cells between present image and the previous one
            Var = TrackObjects(Var, 2);
              
        elseif strcmp(Var.Experiment.Segmentation, 'FluoMedia')
            %Segment Nucleus in images
            %assignin('base','Var_2',Var);
            Var = SegmentYeastFluoMedia(Var, 1);
            
           
            %Track Nuclei between present image and the previous one
            Var = TrackObjects(Var, 1);
            
              %% Segmentation Part
        elseif strcmp(Var.Experiment.Segmentation, 'FluoCell')
            %Segment Nucleus in images
           %assignin('base','Var_BS',Var);
            Var = SegmentYeastFluo(Var, 1);

            %Track Nuclei between present image and the previous one
            Var = TrackObjects(Var, 1);
            
        end
       

        %% Sub-Objects definition
 
        if isfield(Var.Analysis, 'SecPrimObj')
            for L = 1:length(Var.Analysis.SecPrimObj)
                Var = SecondaryObject(Var, L);
            end
        end

        if isfield(Var.Analysis, 'ExpObjSmall')
            for L = 1:length(Var.Analysis.ExpObjSmall)
                Var = ExpandObject(Var, L);
            end
        end
        % assignin('base','Var_BSO',Var);
        
   
       

        %% Img measurement part
        %Correct flatness of Fluorescence image
        if isfield(Var.Analysis, 'CorrFlatIn')
            for L = 1:length(Var.Analysis.SubtractIn)
            %Not fully tested
                Var = CorrectFlatness(Var, L);
            end
        end
        

        %Subtract background from Intensity Image
        if isfield(Var.Analysis, 'SubtractIn')
            for L = 1:length(Var.Analysis.SubtractIn)
                Var = SubtractBackground(Var, L);
            end
        end

        %Measure Objects
        if isfield(Var.Analysis, 'MeasureObject')
            for L = 1:length(Var.Analysis.MeasureObject)
                Var = MeasureObject(Var, L);
            end
        end

         %Calculate new object from measurements
        if isfield(Var.Analysis, 'CalcObjOUT')
            for L = 1:length(Var.Analysis.CalcObjOUT)
                Var = CalculatedObject(Var, L);
            end
        end
               
        
        %Create RGB image
        if isfield(Var.Analysis, 'RGBOut')
            for L = 1:length(Var.Analysis.RGBOut)
                Var = Img2RGB(Var, L);
            end
        end
        

        %Create thumbnails
        if isfield(Var.Analysis, 'ThumbImg')
            for L = 1:length(Var.Analysis.ThumbImg)
                Var = CutThumbnails(Var, L);
            end
        end
      
       % Make movie
       if ~strcmp(Var.Analysis.FrameAnalyzed, 'Single')
           if isfield(Var.Analysis, 'MovieImg')
               for L = 1:length(Var.Analysis.MovieImg)
                   Var = Img2MovieRGB(Var, L);
               end
           end
       end



    end
    fprintf('Segmentation Done\n\n')

    %display Measurements
    if ~strcmp(Var.Analysis.FrameAnalyzed, 'Single')
    if isfield(Var.Analysis, 'DispMeasObject')
        for L = 1:length(Var.Analysis.DispMeasObject)
          Var = DisplayMeasurements(Var, L);
        end
    end
    end

    
    %Remove Img field from Data
    Var = rmfield(Var, 'Img');
    %Save measurements to disk.
    FileName = [Var.Analysis.OutPath,'_Data.mat'];
    save(FileName, 'Var');

    
 catch LastErr
     %Close open movies
     if isfield(Var.Analysis, 'MovieObj')
         NbMov = length(Var.Analysis.MovieObj);
         for Mov = 1:NbMov
             if strcmp(get(Var.Analysis.MovieObj{Mov}, 'CurrentState'), 'Open')
                 Var.Analysis.MovieObj{Mov} = close(Var.Analysis.MovieObj{Mov});
             end
         end
     end
     %Get error specs
     Var.error = LastErr;
     assignin('base','Var_Error',Var);
     if isfield(Var.Analysis, 'CurrentFileName')
        fprintf(['\nERROR IN ', Var.Analysis.CurrentFileName, ' ANALYSIS for Position ', num2str(Var.Analysis.CurrentPos),'\n'])
     else
         fprintf('\nERROR in ImgLoad: Check the image filepath\n')
     end
 
     %LastErrPosition = LastErr.stack(1,1)
     ErrorString = [];
     for E = 1:length(LastErr.stack)
         ErrorString = [ErrorString, '\nIn function ', LastErr.stack(E,1).name, ' at line ', num2str(LastErr.stack(E,1).line)];
     end
     fprintf(ErrorString)
     fprintf('\n')
     LastErrMessage = LastErr.message;
     fprintf(LastErrMessage)
     fprintf('\n')
     fprintf('\n')
     Var.error = LastErr;
     FileName = [Var.Analysis.OutPath,'_Data.mat'];
     save(FileName, 'Var');
 end