function varargout = Img2MeasGUI(varargin)
% IMG2MEASGUI M-file for Img2MeasGUI.fig
%      IMG2MEASGUI, by itself, creates a new IMG2MEASGUI or raises the existing
%      singleton*.
%
%      H = IMG2MEASGUI returns the handle to a new IMG2MEASGUI or the handle to
%      the existing singleton*.
%
%      IMG2MEASGUI('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in IMG2MEASGUI.M with the given input arguments.
%
%      IMG2MEASGUI('Property','Value',...) creates a new IMG2MEASGUI or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before Img2MeasGUI_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to Img2MeasGUI_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%

%%
%Img2MeasGUI V1.1 Modified 18.02.2010
%- Changed display of measurements to have cell Number on image and a legend
%displaying that number

%- Added red X Button to remove traces saved with GetTrace

%- Save the cell Number to a vectr in workspace when press on GetTrace

%Img2MeasGUI V1.2 Modified 23.02.2010
%- Add button to save image to PNG

%Img2MeasGUI V1.2b Modified 23.3.2012
%- Modified Get Trace image to take account of the change in the VAR
%structure made in ver 5



%%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help Img2MeasGUI

% Last Modified by GUIDE v2.5 23-Feb-2011 15:19:05

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
    'gui_Singleton',  gui_Singleton, ...
    'gui_OpeningFcn', @Img2MeasGUI_OpeningFcn, ...
    'gui_OutputFcn',  @Img2MeasGUI_OutputFcn, ...
    'gui_LayoutFcn',  [] , ...
    'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before Img2MeasGUI is made visible.
function Img2MeasGUI_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to Img2MeasGUI (see VARARGIN)

% Choose default command line output for Img2MeasGUI
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes Img2MeasGUI wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = Img2MeasGUI_OutputFcn(hObject, eventdata, handles)
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;



% --- Executes on button press in SelectVar.
function SelectVar_Callback(hObject, eventdata, handles)
% hObject    handle to SelectVar (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


%Load var file
if isfield(handles, 'Display') && isfield(handles.Display, 'VarPath')
    [VarFile,VarPath] = uigetfile('*.mat','Select the Data file', handles.Display.VarPath);
    handles.Display.VarPath = VarPath;
else
    [VarFile,VarPath] = uigetfile('*.mat','Select the Data file');
    handles.Display.VarPath = VarPath;
end
load(fullfile(VarPath, VarFile))

%Transfer fileds to handles
VarFields = fieldnames(Var);
for f = 1:length(VarFields)
    handles.(VarFields{f}) = Var.(VarFields{f});
end

Description = [{handles.Experiment.Filename}, {[ ' Cond: ',...
    handles.Analysis.CurrentCondition, ' Pos: ', num2str(handles.Analysis.CurrentPos)]}];
guidata(hObject, handles);

assignin('base','handles',handles);
%Set description
set(handles.VarDescription, 'String', Description)


%Set Popups
%Combine Img and Object lists
IOList = [handles.Analysis.LoadIllum, handles.Analysis.MeasureObject];
set(handles.RedPopUp, 'String', ['red',IOList], 'Value',  1)
set(handles.GreenPopUp, 'String',['green',IOList], 'Value',  1)
set(handles.BluePopUp, 'String', ['blue',IOList], 'Value',  1)

%Set Object pop-ups
ObjList = fieldnames(handles.Measurements);
set(handles.ObjectSelect, 'String', ObjList, 'Value',  1)
set(handles.SecObj, 'String', ObjList, 'Value',  1)
set(handles.IntSelect, 'String', {'Intensity'}, 'Value',  1)
set(handles.MeasSelect, 'String', {'Feature'}, 'Value',  1)

%Set Frame to one
set(handles.FrameNum, 'String', '1')

handles.Display.red = 0;
handles.Display.green = 0;
handles.Display.blue = 0;
handles.Display.FrameNum = 1;
handles.Display.ObjRatio = 0.5;
handles.Display.MeasCalc =  'FirstMeas';
handles.Display.Traces = [];

%handles.Display.MacPath = '/Volumes/share-gr-peter-1-$/Serge/100528/0528_Ste5tG_SA_D';
%handles.Analysis.ImgSize = [1024,1344];
if max(strcmp('Cell',ObjList)) == 1
    handles.Analysis.MajorObjectName = 'Cell';
elseif max(strcmp('SegCell',ObjList)) == 1
    handles.Analysis.MajorObjectName = 'SegCell'; 
elseif max(strcmp('CombCellObj',ObjList)) == 1
    handles.Analysis.MajorObjectName = 'CombCellObj';
elseif max(strcmp('SplitCell',ObjList)) == 1
    handles.Analysis.MajorObjectName = 'SplitCell';
else
    prompt = {'Enter object for cell selection:'};
    dlg_title = 'MajorObject';
    num_lines = 1;
    def = {'Cell'};
    answer = inputdlg(prompt,dlg_title,num_lines,def);
    handles.Analysis.MajorObjectName = answer{1};
end

    


if isfield(handles.Analysis, 'TimeStamp')
    handles.Display.Time =(handles.Analysis.TimeStamp - handles.Analysis.TimeStamp(handles.Experiment.TimeZero))./1000;
end
handles.Display.Reload = 1;
handles = DiplayImage(handles);

% Update handles structure
guidata(hObject, handles);


% --- Executes on selection change in RedPopUp.
function RedPopUp_Callback(hObject, eventdata, handles)
% hObject    handle to RedPopUp (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

contents = cellstr(get(hObject,'String')); % returns IllumPopUp contents as cell array

%NumIllum = find(strcmp(handles.Analysis.LoadIllum, contents{get(hObject,'Value')}));
NumIllum = find(strcmp(handles.Experiment.Filter, contents{get(hObject,'Value')}));
handles.Display.red = NumIllum;
if ~isempty(NumIllum)
    handles.Display.red = NumIllum;
else
    NumObj = find(strcmp(handles.Analysis.MeasureObject, contents{get(hObject,'Value')}));
    if ~isempty(NumObj)
        handles.Display.red = -1*NumObj(1);
    else
        handles.Display.red = 0;
    end
end
handles.Display.Reload = 1;
handles = DiplayImage(handles);

% Update handles structure
guidata(hObject, handles);



% --- Executes on selection change in GreenPopUp.
function GreenPopUp_Callback(hObject, eventdata, handles)
% hObject    handle to GreenPopUp (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

contents = cellstr(get(hObject,'String')); % returns IllumPopUp contents as cell array

NumIllum = find(strcmp(handles.Experiment.Filter, contents{get(hObject,'Value')}));
handles.Display.green = NumIllum;
if ~isempty(NumIllum)
    handles.Display.green = NumIllum;
else
    NumObj = find(strcmp(handles.Analysis.MeasureObject, contents{get(hObject,'Value')}));
    if ~isempty(NumObj)
        handles.Display.green = -1*NumObj(1);
    else
        handles.Display.green = 0;
    end
end
handles.Display.Reload = 1;
handles = DiplayImage(handles);

% Update handles structure
guidata(hObject, handles);

% --- Executes on selection change in BluePopUp.
function BluePopUp_Callback(hObject, eventdata, handles)
% hObject    handle to BluePopUp (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

contents = cellstr(get(hObject,'String')); % returns IllumPopUp contents as cell array

NumIllum = find(strcmp(handles.Experiment.Filter, contents{get(hObject,'Value')}));
handles.Display.blue = NumIllum;
if ~isempty(NumIllum)
    handles.Display.blue = NumIllum;
else
    NumObj = find(strcmp(handles.Analysis.MeasureObject, contents{get(hObject,'Value')}));
    if ~isempty(NumObj)
        handles.Display.blue = -1*NumObj(1);
    else
        handles.Display.blue = 0;
    end
end
handles.Display.Reload = 1;
handles = DiplayImage(handles);
% Update handles structure
guidata(hObject, handles);


% --- Executes on selection change in ObjectSelect.
function ObjectSelect_Callback(hObject, eventdata, handles)
% hObject    handle to ObjectSelect (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

contents = cellstr(get(hObject,'String')); %returns ObjectSelect contents as cell array
handles.Display.Object = contents{get(hObject,'Value')}; %returns selected item from ObjectSelect

%Set Object pop-ups
IntList = fieldnames(handles.Measurements.(handles.Display.Object));
V = 0;
for i = 1:length(IntList)
    if ~isempty(strfind(IntList{i}, 'Img'));
        V = V+1;
        ValidInt{V} = IntList{i};
    end
end
set(handles.IntSelect, 'String', ValidInt, 'Value',1)

handles.Display.Reload = 0;
handles = DiplayImage(handles);
% Update handles structure
guidata(hObject, handles);


% --- Executes on selection change in SecObj.
function SecObj_Callback(hObject, eventdata, handles)
% hObject    handle to SecObj (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

contents = cellstr(get(hObject,'String')); %returns ObjectSelect contents as cell array
handles.Display.SecObject = contents{get(hObject,'Value')}; %returns selected item from ObjectSelect

%Set Object pop-ups
IntList = fieldnames(handles.Measurements.(handles.Display.SecObject));
V = 0;
for i = 1:length(IntList)
    if ~isempty(strfind(IntList{i}, 'Img'));
        V = V+1;
        ValidInt{V} = IntList{i};
    end
end
set(handles.SecInt, 'String', ValidInt, 'Value',1)

handles.Display.Reload = 0;
handles = DiplayImage(handles);
% Update handles structure
guidata(hObject, handles);



% --- Executes on selection change in IntSelect.
function IntSelect_Callback(hObject, eventdata, handles)
% hObject    handle to IntSelect (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

contents = cellstr(get(hObject,'String')); %returns ObjectSelect contents as cell array
handles.Display.Intensity = contents{get(hObject,'Value')}; %returns selected item from ObjectSelect

%Set Object pop-ups
MeasList = fieldnames(handles.Measurements.(handles.Display.Object).(handles.Display.Intensity));
set(handles.MeasSelect, 'String', MeasList, 'Value',1)
handles.Display.Reload = 0;
handles = DiplayImage(handles);
% Update handles structure
guidata(hObject, handles);


% --- Executes on selection change in SecInt.
function SecInt_Callback(hObject, eventdata, handles)
% hObject    handle to SecInt (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

contents = cellstr(get(hObject,'String')); %returns ObjectSelect contents as cell array
handles.Display.SecIntensity = contents{get(hObject,'Value')}; %returns selected item from ObjectSelect

%Set Object pop-ups
MeasList = fieldnames(handles.Measurements.(handles.Display.SecObject).(handles.Display.SecIntensity));
set(handles.SecMeas, 'String', MeasList, 'Value',1)
handles.Display.Reload = 0;
handles = DiplayImage(handles);
% Update handles structure
guidata(hObject, handles);



% --- Executes on selection change in MeasSelect.
function MeasSelect_Callback(hObject, eventdata, handles)
% hObject    handle to MeasSelect (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

contents = cellstr(get(hObject,'String')); %returns ObjectSelect contents as cell array
handles.Display.Measurements = contents{get(hObject,'Value')}; %returns selected item from ObjectSelect

handles.Display.Reload = 0;
handles = DiplayImage(handles);
% Update handles structure
guidata(hObject, handles);


% --- Executes on selection change in SecMeas.
function SecMeas_Callback(hObject, eventdata, handles)
% hObject    handle to SecMeas (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

contents = cellstr(get(hObject,'String')); %returns ObjectSelect contents as cell array
handles.Display.SecMeasurements = contents{get(hObject,'Value')}; %returns selected item from ObjectSelect

handles.Display.Reload = 0;
handles = DiplayImage(handles);
% Update handles structure
guidata(hObject, handles);



% --- Executes on selection change in Calculate.
function Calculate_Callback(hObject, eventdata, handles)
% hObject    handle to Calculate (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

contents = cellstr(get(hObject,'String')); %returns ObjectSelect contents as cell array
handles.Display.MeasCalc = contents{get(hObject,'Value')}; %returns selected item from ObjectSelect


handles.Display.Reload = 0;
handles = DiplayImage(handles);
guidata(hObject, handles);

%% Frame Functions
%%%
%%%%%

function FrameNum_Callback(hObject, eventdata, handles)
% hObject    handle to FrameNum (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

handles.Display.FrameNum = str2double(get(hObject,'String')); % returns contents of FrameNum as a double

if handles.Display.FrameNum > handles.Analysis.NumFrame;
    handles.Display.FrameNum  = handles.Analysis.NumFrame;
elseif handles.Display.FrameNum == 0;
    handles.Display.FrameNum  = 1;
end
set(hObject, 'String', num2str(handles.Display.FrameNum))

handles.Display.Reload = 1;
handles = DiplayImage(handles);


% Update handles structure
guidata(hObject, handles);

% --- Executes on button press in MinusFrame.
function MinusFrame_Callback(hObject, eventdata, handles)
% hObject    handle to MinusFrame (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

handles.Display.FrameNum = str2double(get(handles.FrameNum,'String'));
handles.Display.FrameNum = handles.Display.FrameNum-1;
if handles.Display.FrameNum == 0;
    handles.Display.FrameNum  = 1;
end
set(handles.FrameNum,'String',num2str(handles.Display.FrameNum));

handles.Display.Reload = 1;
handles = DiplayImage(handles);
% Update handles structure
guidata(hObject, handles);

% --- Executes on button press in PlusFrame.
function PlusFrame_Callback(hObject, eventdata, handles)
% hObject    handle to PlusFrame (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

handles.Display.FrameNum = str2double(get(handles.FrameNum,'String'));
handles.Display.FrameNum = handles.Display.FrameNum+1;
set(handles.FrameNum,'String',num2str(handles.Display.FrameNum));

if handles.Display.FrameNum > handles.Analysis.NumFrame;
    handles.Display.FrameNum  = handles.Analysis.NumFrame;
end
handles.Display.Reload = 1;
handles = DiplayImage(handles);

%assignin('base', 'handles_FP', handles)
% Update handles structure
guidata(hObject, handles);


%% Nicer Dislpay functions
% --- Executes on button press in ZoomIn.
function ZoomIn_Callback(hObject, eventdata, handles)
% hObject    handle to ZoomIn (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

if (get(hObject,'Value') == 1)
    zoom(handles.Image,'on')
else
    zoom(handles.Image, 1)
    zoom(handles.Image,'off')
    %zoom(handles.Image,'reset')
end


% --- Executes on button press in GetTrace.
function GetTrace_Callback(hObject, eventdata, handles)
% hObject    handle to GetTrace (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
assignin('base', 'handles', handles)
assignin('base', 'Time', handles.Display.Time')
TraceName = [ regexprep(handles.Analysis.CurrentCondition, ' ', '_'), '_Pos', num2str(handles.Analysis.CurrentPos)];

AxChildren = get(handles.Image, 'Children');
handles_UDImg = get(AxChildren(end), 'UserData');
handles.Display.Traces = [handles.Display.Traces,handles_UDImg.Display.MeasLine];
assignin('base', TraceName, handles.Display.Traces)

if isfield(handles.Display, 'SelectedCells')
    handles.Display.SelectedCells = [handles.Display.SelectedCells, handles_UDImg.Display.CellNum];
else
    handles.Display.SelectedCells = handles_UDImg.Display.CellNum;
end
CellsName = [ regexprep(handles.Analysis.CurrentCondition, ' ', '_'), '_Pos', num2str(handles.Analysis.CurrentPos), '_Cells'];
assignin('base', CellsName, handles.Display.SelectedCells)


guidata(hObject, handles);


% --- Executes on button press in DelTraces.
function DelTraces_Callback(hObject, eventdata, handles)
% hObject    handle to DelTraces (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
handles.Display.Traces = [];
handles.Display.SelectedCells = [];
guidata(hObject, handles);


% --- Executes on button press in SaveImg.
function SaveImg_Callback(hObject, eventdata, handles)
% hObject    handle to SaveImg (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
FigName = [ regexprep(handles.Analysis.CurrentCondition, ' ', '_'), '_Pos', num2str(handles.Analysis.CurrentPos),'.png'];

%print(['-f',num2str(handles.Image)], FigName)
hgsave(handles.Image,FigName)
%saveas(handles.Image,FigName)

f = getframe(handles.Image); %Capture screen shot
[im,map] = frame2im(f);
imwrite(im,FigName);

%% %%%%
%% Executing function
%%%%
%%%%

function handles = DiplayImage(handles)

%Test if reload necessary
if ~isfield(handles.Display,'RGB') || (handles.Display.Reload == 1)
    %Set Red image
    if (handles.Display.red > 0)
        if ismac
            if strcmpi(handles.Analysis.System, 'PC') || strcmpi(handles.Analysis.System, 'PC_para')
                FilePath = handles.Analysis.FilePath{handles.Display.red,handles.Display.FrameNum};
                BS = strfind(FilePath, '\');
                ImgFile = FilePath(BS(end)+1:end);
                FolderName = FilePath(BS(end-1)+1:BS(end)-1);
                FileMac = fullfile(handles.Analysis.MacPath, FolderName,ImgFile);
            elseif strcmpi(handles.Analysis.System, 'mac') || strcmpi(handles.Analysis.System, 'mac_para')
                FileMac = handles.Analysis.FilePath{handles.Display.red,handles.Display.FrameNum};
            end
        elseif  ispc && (strcmpi(handles.Analysis.System, 'PC') || strcmpi(handles.Analysis.System, 'PC_para'))
            FileMac = handles.Analysis.FilePath{handles.Display.red,handles.Display.FrameNum};
        end
        I = imread(FileMac);
        I = imadjust(I, stretchlim(I, [0.01, 0.999]));
        Red = I;
    elseif (handles.Display.red < 0)
        I = zeros(handles.Analysis.ImgSize);
        FrameNum = handles.Display.FrameNum;
        ObjDisplay = handles.Analysis.MeasureObject{abs(handles.Display.red)};
        for O = 1:size(handles.Measurements.(ObjDisplay).PixelList,2)
            I(handles.Measurements.(ObjDisplay).PixelList{FrameNum,O}) = (2^16-1)*handles.Display.ObjRatio;
        end
        %I = bwperim(I).*(2^16-1);
        Red = uint16(I);
    else
        Red = uint16(zeros(handles.Analysis.ImgSize));
    end
    
    
    %Set Green image
    if (handles.Display.green > 0)
        if ismac
            if strcmpi(handles.Analysis.System, 'PC') || strcmpi(handles.Analysis.System, 'PC_para')
                FilePath = handles.Analysis.FilePath{handles.Display.green,handles.Display.FrameNum};
                BS = strfind(FilePath, '\');
                ImgFile = FilePath(BS(end)+1:end);
                FolderName = FilePath(BS(end-1)+1:BS(end)-1);
                FileMac = fullfile(handles.Analysis.MacPath, FolderName,ImgFile);
            elseif strcmpi(handles.Analysis.System, 'mac') || strcmpi(handles.Analysis.System, 'mac_para')
                FileMac = handles.Analysis.FilePath{handles.Display.green,handles.Display.FrameNum};
            end
        elseif  ispc && (strcmpi(handles.Analysis.System, 'PC') || strcmpi(handles.Analysis.System, 'PC_para'))
            FileMac = handles.Analysis.FilePath{handles.Display.green,handles.Display.FrameNum};
        end
        I = imread(FileMac);
        I = imadjust(I, stretchlim(I, [0.01, 0.999]));
        Green = I;
    elseif (handles.Display.green < 0)
        I = zeros(handles.Analysis.ImgSize);
        FrameNum = handles.Display.FrameNum;
        ObjDisplay = handles.Analysis.MeasureObject{abs(handles.Display.green)};
        for O = 1:size(handles.Measurements.(ObjDisplay).PixelList,2)
            I(handles.Measurements.(ObjDisplay).PixelList{FrameNum,O}) = (2^16-1)*handles.Display.ObjRatio;
        end
        Green = uint16(I);
    else
        Green = uint16(zeros(handles.Analysis.ImgSize));
    end
    
    %Set Blue image
    if (handles.Display.blue > 0)
        if ismac
        if strcmpi(handles.Analysis.System, 'PC') || strcmpi(handles.Analysis.System, 'PC_para')
            FilePath = handles.Analysis.FilePath{handles.Display.blue,handles.Display.FrameNum};
            BS = strfind(FilePath, '\');
            ImgFile = FilePath(BS(end)+1:end);
            FolderName = FilePath(BS(end-1)+1:BS(end)-1);
            FileMac = fullfile(handles.Analysis.MacPath, FolderName,ImgFile);
        elseif strcmpi(handles.Analysis.System, 'mac') || strcmpi(handles.Analysis.System, 'mac_para')
            FileMac = handles.Analysis.FilePath{handles.Display.blue,handles.Display.FrameNum};
        end
        elseif ispc && (strcmpi(handles.Analysis.System, 'PC') || strcmpi(handles.Analysis.System, 'PC_para'))
            FileMac = handles.Analysis.FilePath{handles.Display.blue,handles.Display.FrameNum};
        end
        I = imread(FileMac);
        I = imadjust(I, stretchlim(I, [0.01, 0.999]));
        Blue = I;
    elseif (handles.Display.blue < 0)
        I = zeros(handles.Analysis.ImgSize);
        FrameNum = handles.Display.FrameNum;
        ObjDisplay = handles.Analysis.MeasureObject{abs(handles.Display.blue)};
        for O = 1:size(handles.Measurements.(ObjDisplay).PixelList,2)
            I(handles.Measurements.(ObjDisplay).PixelList{FrameNum,O}) = (2^16-1)*handles.Display.ObjRatio;
        end
        Blue = uint16(I);
    else
        Blue = uint16(zeros(handles.Analysis.ImgSize));
    end
    
    RGB(:,:,1) = Red;
    RGB(:,:,2) = Green;
    RGB(:,:,3) = Blue;
    handles.Display.RGB = RGB;
end

axes(handles.Image)
image(handles.Display.RGB, 'ButtondownFcn', {@GetCoord }, 'UserData', handles)
set(gca,'XTick',[],'YTick',[])





function GetCoord(src,eventdata)

%Get Axes info
AxProp = get(src, 'Parent');
MousePosition = get(AxProp, 'CurrentPoint');
handles = get(src,'UserData');

%Find mouse position indice
MPind = sub2ind(handles.Analysis.ImgSize,round(MousePosition(1,2)),round(MousePosition(1,1)));


MajorObj = handles.Analysis.MajorObjectName;
FrameNum = handles.Display.FrameNum;
PixFound = [];
O = 0;
% Loop through all object to find which pixel indice belongs to the object
% using the major object as reference


while isempty(PixFound) && O < size(handles.Measurements.(MajorObj).PixelList,2)
    O = O+1;
    PixFound = find(handles.Measurements.(MajorObj).PixelList{FrameNum,O} == MPind);
end

%Check if measurement is a vector
if size(handles.Measurements.(handles.Display.Object).(handles.Display.Intensity).(handles.Display.Measurements){O},2) == 1
    %Set measurement to MeasLine from the selected object
if ~isempty(PixFound)
    handles.Display.CellNum = O;
    if ~isfield(handles.Display, 'MeasCalc')
        MeasLine = handles.Measurements.(handles.Display.Object).(handles.Display.Intensity).(handles.Display.Measurements){O};
        MeasLine(MeasLine == 0) = NaN;
    elseif strcmp(handles.Display.MeasCalc, 'FirstMeas')
        MeasLine = handles.Measurements.(handles.Display.Object).(handles.Display.Intensity).(handles.Display.Measurements){O};
        MeasLine(MeasLine == 0) = NaN;
    elseif strcmp(handles.Display.MeasCalc, 'Difference')
        MeasCell = handles.Measurements.(handles.Display.Object).(handles.Display.Intensity).(handles.Display.Measurements);
        SecMeasCell = handles.Measurements.(handles.Display.SecObject).(handles.Display.SecIntensity).(handles.Display.SecMeasurements);
        MeasLine = MeasCell{O} - SecMeasCell{O};
        MeasLine(MeasLine == 0) = NaN;
        
    elseif strcmp(handles.Display.MeasCalc, 'Ratio')
        MeasCell = handles.Measurements.(handles.Display.Object).(handles.Display.Intensity).(handles.Display.Measurements);
        SecMeasCell = handles.Measurements.(handles.Display.SecObject).(handles.Display.SecIntensity).(handles.Display.SecMeasurements);
        LabelCell = handles.Measurements.(handles.Display.Object).(handles.Display.Intensity).CheckLabel;
        MeasLine = MeasCell{O}./SecMeasCell{O};
        MeasLine(MeasLine == 0) = NaN;
        
    end
    %Check if MeasLine and Time axis are of same length
    %if not Add NaNs
    if length(MeasLine) < length(handles.Display.Time)
        MeasLine(length(MeasLine)+1:length(handles.Display.Time)) = NaN;
    end
    handles.Display.MeasLine = MeasLine;
    %Display Cell Number
    axes(handles.Image)
    hold all
    %plot(MousePosition(1,1),MousePosition(1,2),'o')
    text(MousePosition(1,1),MousePosition(1,2), num2str(O), 'Color', 'w')
    hold off
    
else
    MeasLine = zeros(size(handles.Display.Time));
    MeasLine(:) = NaN;
    handles.Display.CellNum = NaN;
end
%assignin('base', 'handles_AM', handles)

 
%MeasLine = smooth(MeasLine,3)';
handles.Display.MeasLine =  MeasLine;



figure(1)
legend('off')
hold all
L = plot(handles.Display.Time,MeasLine);
set(L, 'DisplayName', num2str(handles.Display.CellNum))
title(handles.Display.MeasCalc)
legend('toggle')

else
    Meas2D = handles.Measurements.(handles.Display.Object).(handles.Display.Intensity).(handles.Display.Measurements){O};
    Meas2D(Meas2D == 0) = NaN;
    if size(Meas2D,1) < length(handles.Display.Time)
        Meas2D(size(Meas2D,1)+1:length(handles.Display.Time),:) = NaN;
    end
    handles.Display.Meas2D = Meas2D;
    figure

L = imagesc(handles.Analysis.AngleAxis,handles.Display.Time,Meas2D);
colormap(gray)
%set(L, 'DisplayName', num2str(handles.Display.CellNum))
title(handles.Display.MeasCalc)
end


set(src,'UserData',handles);

%guidata(hObject, handles);


%% Other Stuff
%%%
%%%%
%%%%%










function RedPopUp_CreateFcn(hObject, eventdata, handles)
% hObject    handle to RedPopUp (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



% --- Executes during object creation, after setting all properties.
function GreenPopUp_CreateFcn(hObject, eventdata, handles)
% hObject    handle to GreenPopUp (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end




% --- Executes during object creation, after setting all properties.
function BluePopUp_CreateFcn(hObject, eventdata, handles)
% hObject    handle to BluePopUp (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end






% --- Executes during object creation, after setting all properties.
function FrameNum_CreateFcn(hObject, eventdata, handles)
% hObject    handle to FrameNum (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end




% --- Executes during object creation, after setting all properties.
function ObjectSelect_CreateFcn(hObject, eventdata, handles)
% hObject    handle to ObjectSelect (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



% --- Executes during object creation, after setting all properties.
function IntSelect_CreateFcn(hObject, eventdata, handles)
% hObject    handle to IntSelect (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end





% --- Executes during object creation, after setting all properties.
function MeasSelect_CreateFcn(hObject, eventdata, handles)
% hObject    handle to MeasSelect (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



% --- Executes during object creation, after setting all properties.
function SecObj_CreateFcn(hObject, eventdata, handles)
% hObject    handle to SecObj (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



% --- Executes during object creation, after setting all properties.
function SecInt_CreateFcn(hObject, eventdata, handles)
% hObject    handle to SecInt (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



% --- Executes during object creation, after setting all properties.
function SecMeas_CreateFcn(hObject, eventdata, handles)
% hObject    handle to SecMeas (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end




% --- Executes during object creation, after setting all properties.
function Calculate_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Calculate (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



