function varargout = Export2Meas(varargin)
% EXPORT2MEAS M-file for Export2Meas.fig
%      EXPORT2MEAS, by itself, creates a new EXPORT2MEAS or raises the existing
%      singleton*.
%
%      H = EXPORT2MEAS returns the handle to a new EXPORT2MEAS or the handle to
%      the existing singleton*.
%
%      EXPORT2MEAS('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in EXPORT2MEAS.M with the given input arguments.
%
%      EXPORT2MEAS('Property','Value',...) creates a new EXPORT2MEAS or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before Export2Meas_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to Export2Meas_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help Export2Meas

% Last Modified by GUIDE v2.5 24-Oct-2011 21:50:22

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
    'gui_Singleton',  gui_Singleton, ...
    'gui_OpeningFcn', @Export2Meas_OpeningFcn, ...
    'gui_OutputFcn',  @Export2Meas_OutputFcn, ...
    'gui_LayoutFcn',  [] , ...
    'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before Export2Meas is made visible.
function Export2Meas_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to Export2Meas (see VARARGIN)

% Choose default command line output for Export2Meas
handles.output = hObject;



% Update handles structure
guidata(hObject, handles);

% UIWAIT makes Export2Meas wait for user response (see UIRESUME)
% uiwait(handles.Exp2MeasGUI);


% --- Outputs from this function are returned to the command line.
function varargout = Export2Meas_OutputFcn(hObject, eventdata, handles)
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes on button press in AddExp. Load the expoort files
function AddExp_Callback(hObject, eventdata, handles)
[ExpFiles,ExpPath] = uigetfile('*.mat','Select the Export file(s)','MultiSelect','on');

if ExpPath~= 0
handles.Display.ExpPath = ExpPath;
%Define some variables
handles.Display.TraceMeas = {'None';'Mean'; 'Median';'MaxDiff';'FinalDiff'; 'Basal'; 'VolumeChange';'MaxTime' };
%Convert all entries to cell type
if ~iscell(ExpFiles)
    ListFiles{1} = ExpFiles;
else
    ListFiles = ExpFiles;
end

for F = 1:length(ListFiles)
    %load export file
    load(fullfile(ExpPath, ListFiles{F}))
    %Test if export exists in field
    if ~isfield(handles, 'Export')
        %If not add it
        handles.Export = Export;
    else
        %If Export is already in handles, add each conditions to the
        %handles
        Conditions = fieldnames(Export);
        for C = 1:length(Conditions)
            handles.Export.(Conditions{C}) = Export.(Conditions{C});
        end
    end
    if exist('Display','var')
        handles.Display = Display;
    end
    if exist('Limit','var')
        handles.Limit = Limit;
    end
end


%Modify condition list to Display all conditions
CondList = fieldnames(handles.Export);
set(handles.CondList, 'String', CondList)
%Set first condition as the active one by default
set(handles.CondList, 'Value', 1)
handles.Display.SelectedCond{1} = CondList{1};

if ~exist('Display','var')
    %Set the illumination pop-up
    AllFieldNames = fieldnames(handles.Export.(CondList{1}));
    %Exclude the Time end experiment entries from the list
    IllumInd = find(cellfun(@isempty, strfind(AllFieldNames, 'Time')).*cellfun(@isempty, strfind(AllFieldNames, 'Experiment')));
    
    
    set(handles.M1_Illum,'String', AllFieldNames(IllumInd) )
    set(handles.M2_Illum,'String', AllFieldNames(IllumInd))
    handles.Display.AllIllum = AllFieldNames(IllumInd);
    %assignin('base','handles_AddExp',handles);
    
    %Initalize trace measurement pop-up
    set(handles.M1_TraceMeas,'String',handles.Display.TraceMeas)
    set(handles.M1_TraceMeas,'Value', 1)
    handles.Display.M1_TraceMeas = 'None';
    set(handles.M2_TraceMeas,'String',handles.Display.TraceMeas)
    set(handles.M2_TraceMeas,'Value', 1)
    handles.Display.M2_TraceMeas = 'None';
else
    set(handles.M1_Illum,'String', handles.Display.AllIllum)
    IllumInd = find(~cellfun(@isempty, strfind(handles.Display.AllIllum, handles.Display.M1_Illum)));
    set(handles.M1_Illum,'Value', IllumInd)
    
    set(handles.M1_Object,'String',handles.Display.M1_Object)
    set(handles.M1_Meas,'String',handles.Display.M1_Meas)
    
    set(handles.M1_TraceMeas,'String',handles.Display.TraceMeas)
    TraceInd = find(~cellfun(@isempty, strfind(handles.Display.TraceMeas, handles.Display.M1_TraceMeas)));
    set(handles.M1_TraceMeas,'Value', TraceInd)
    
    set(handles.M2_Illum,'String', handles.Display.AllIllum)
    set(handles.M2_TraceMeas,'String',handles.Display.TraceMeas)
    if isfield(handles.Display, 'M2_Meas')
        set(handles.M2_Illum,'String', handles.Display.AllIllum)
        IllumInd = find(~cellfun(@isempty, strfind(handles.Display.AllIllum, handles.Display.M2_Illum)));
        set(handles.M2_Illum,'Value', IllumInd)
        
        set(handles.M2_Object,'String',handles.Display.M2_Object)
        set(handles.M2_Meas,'String',handles.Display.M2_Meas)
        
        set(handles.M2_TraceMeas,'String',handles.Display.TraceMeas)
        TraceInd = find(~cellfun(@isempty, strfind(handles.Display.TraceMeas, handles.Display.M2_TraceMeas)));
        set(handles.M2_TraceMeas,'Value', TraceInd)
    end
end

if exist('Limit','var')
    set(handles.ActiveLimit,'Value', 1);
end
set(handles.LoadSettings, 'Enable', 'on')
end


% Update handles structure
guidata(hObject, handles);

% --- Executes on button press in ClearExp.
function ClearExp_Callback(hObject, eventdata, handles)
% hObject    handle to ClearExp (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
try
    handles = rmfield(handles,  {'Export', 'Display','Limit'});
catch
end
set(handles.CondList, 'String', {'Conditions'})
set(handles.CondList, 'Value', 1)
set(handles.LoadSettings, 'Enable', 'inactive')
set(handles.ActiveLimit,'Value', 0);
% Update handles structure
guidata(hObject, handles);

% --- Executes on selection change in CondList.
function CondList_Callback(hObject, eventdata, handles)
% hObject    handle to CondList (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

%Get selected list
CondList = cellstr(get(hObject,'String'));
% Original? SelectedCondNum = contents{get(hObject,'Value')};
SelectedCondNum = get(hObject,'Value');

handles.Display.SelectedCond = CondList(SelectedCondNum);

%Set the illumination pop-up
set(handles.M1_Illum,'String', handles.Display.AllIllum)
set(handles.M2_Illum,'String', handles.Display.AllIllum)
%assignin('base','handles_CondList',handles);
% Update handles structure
guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function CondList_CreateFcn(hObject, eventdata, handles)
% hObject    handle to CondList (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: listbox controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in M1_Illum.
function M1_Illum_Callback(hObject, eventdata, handles)
% hObject    handle to M1_Illum (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

IllumList = cellstr(get(hObject,'String'));
SelectedIllumNum = get(hObject,'Value');

handles.Display.M1_Illum = IllumList{SelectedIllumNum};

%Set the Object pop-up
set(handles.M1_Object,'String', fieldnames(handles.Export.(handles.Display.SelectedCond{1}).(handles.Display.M1_Illum)))
assignin('base','handles_Illum',handles);
% Update handles structure
guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function M1_Illum_CreateFcn(hObject, eventdata, handles)
% hObject    handle to M1_Illum (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in M1_Object.
function M1_Object_Callback(hObject, eventdata, handles)
% hObject    handle to M1_Object (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

%Get selected object
ObjList = cellstr(get(hObject,'String'));
SelectedObjNum = get(hObject,'Value');
handles.Display.M1_Object = ObjList{SelectedObjNum};

%Set the Measurement pop-up
set(handles.M1_Meas,'String', fieldnames(handles.Export.(handles.Display.SelectedCond{1}).(handles.Display.M1_Illum).(handles.Display.M1_Object)))

% Update handles structure
guidata(hObject, handles);



% --- Executes during object creation, after setting all properties.
function M1_Object_CreateFcn(hObject, eventdata, handles)
% hObject    handle to M1_Object (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in M1_Meas.
function M1_Meas_Callback(hObject, eventdata, handles)
% hObject    handle to M1_Meas (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

%Get selected Measurement
MeasList = cellstr(get(hObject,'String'));
SelectedMeasNum = get(hObject,'Value');

handles.Display.M1_Meas = MeasList{SelectedMeasNum};


% Update handles structure
guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function M1_Meas_CreateFcn(hObject, eventdata, handles)
% hObject    handle? to M1_Meas (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% --- Executes on button press in M1_TraceMeas.
function M1_TraceMeas_Callback(hObject, eventdata, handles)
% hObject    handle to M1_TraceMeas (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

%Get selected Measurement
MeasTrace = cellstr(get(hObject,'String'));
SelectedTraceMeasNum = get(hObject,'Value');

handles.Display.M1_TraceMeas = MeasTrace{SelectedTraceMeasNum};


%{'None','Mean', 'Median','MaxDiff','FinalDiff', 'Basal', 'VolumeChange','MaxTime' };
switch(handles.Display.M1_TraceMeas)
    case 'Mean'
        MeasTraceStr = 'M = mean(Trace)';
    case 'Median'
        MeasTraceStr = 'M = median(Trace)';
    case 'MaxDiff'
        MeasTraceStr = 'M = max(Trace) - mean(Trace(1:T0))';
    case 'FinalDiff'
        MeasTraceStr = 'M = mean(Trace(end-3:end)) - mean(Trace(1:T0))';
    case 'Basal'
        MeasTraceStr = 'M = mean(Trace(1:T0))';
end
set(handles.M1_TraceTxt,'String', MeasTraceStr)

% Update handles structure
guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function M1_TraceMeas_CreateFcn(hObject, eventdata, handles)
% hObject    handle to M1_TraceMeas (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



%% MEAS 2


% --- Executes on selection change in M2_Illum.
function M2_Illum_Callback(hObject, eventdata, handles)
% hObject    handle to M2_Illum (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
IllumList = cellstr(get(hObject,'String'));
SelectedIllumNum = get(hObject,'Value');

handles.Display.M2_Illum = IllumList{SelectedIllumNum};

%Set the Object pop-up
set(handles.M2_Object,'String', fieldnames(handles.Export.(handles.Display.SelectedCond{1}).(handles.Display.M2_Illum)))
assignin('base','handles_Illum',handles);
% Update handles structure
guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function M2_Illum_CreateFcn(hObject, eventdata, handles)
% hObject    handle to M2_Illum (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in M2_Object.
function M2_Object_Callback(hObject, eventdata, handles)
% hObject    handle to M2_Object (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

%Get selected object
ObjList = cellstr(get(hObject,'String'));
SelectedObjNum = get(hObject,'Value');
handles.Display.M2_Object = ObjList{SelectedObjNum};

%Set the Measurement pop-up
set(handles.M2_Meas,'String', fieldnames(handles.Export.(handles.Display.SelectedCond{1}).(handles.Display.M2_Illum).(handles.Display.M2_Object)))

% Update handles structure
guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function M2_Object_CreateFcn(hObject, eventdata, handles)
% hObject    handle to M2_Object (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in M2_Meas.
function M2_Meas_Callback(hObject, eventdata, handles)
% hObject    handle to M2_Meas (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

%Get selected Measurement
MeasList = cellstr(get(hObject,'String'));
SelectedMeasNum = get(hObject,'Value');

handles.Display.M2_Meas = MeasList{SelectedMeasNum};
guidata(hObject, handles);


% Update handles structure


% --- Executes during object creation, after setting all properties.
function M2_Meas_CreateFcn(hObject, eventdata, handles)
% hObject    handle to M2_Meas (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end





% --- Executes on selection change in M2_TraceMeas.
function M2_TraceMeas_Callback(hObject, eventdata, handles)
% hObject    handle to M2_TraceMeas (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

%Get selected Measurement
MeasTrace = cellstr(get(hObject,'String'));
SelectedTraceMeasNum = get(hObject,'Value');

handles.Display.M2_TraceMeas = MeasTrace{SelectedTraceMeasNum};


%{'None','Mean', 'Median','MaxDiff','FinalDiff', 'Basal', 'VolumeChange','MaxTime' };
switch(handles.Display.M2_TraceMeas)
    case 'Mean'
        MeasTraceStr = 'M = mean(Trace)';
    case 'Median'
        MeasTraceStr = 'M = median(Trace)';
    case 'MaxDiff'
        MeasTraceStr = 'M = max(Trace) - mean(Trace(1:T0))';
    case 'FinalDiff'
        MeasTraceStr = 'M = mean(Trace(end-3:end)) - mean(Trace(1:T0))';
    case 'Basal'
        MeasTraceStr = 'M = mean(Trace(1:T0))';
end
set(handles.M2_TraceTxt,'String', MeasTraceStr)

% Update handles structure
guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function M2_TraceMeas_CreateFcn(hObject, eventdata, handles)
% hObject    handle to M2_TraceMeas (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

%%

% --- Executes on button press in SetLimits.
function SetLimits_Callback(hObject, eventdata, handles)
% hObject    handle to SetLimits (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

%Load LimitPrefs GUI
LimitPrefs


%% Display DATA


% --- Executes on button press in DisplayGraph.
function DisplayGraph_Callback(hObject, eventdata, handles)
% hObject    handle to DisplayGraph (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
%close figures
try
    close(findobj('Tag', 'FigDisplay'))
catch
end

assignin('base','handles_DispG',handles);

%Generate modified string from conditions
for E = 1:length(handles.Display.SelectedCond)
    handles.Display.CondStr{E} = regexprep(handles.Display.SelectedCond{E}, '_', ' ');
    handles.Display.CondStr{E} = regexprep(handles.Display.CondStr{E}, 'p', '.');
end

for E = 1:length(handles.Display.SelectedCond)
    %Display mean of Meas 1
    if isfield(handles.Display, 'M1_Meas')
        CellTraces = handles.Export.(handles.Display.SelectedCond{E}).(handles.Display.M1_Illum).(handles.Display.M1_Object).(handles.Display.M1_Meas).Cells;
        CheckLabel = handles.Export.(handles.Display.SelectedCond{E}).(handles.Display.M1_Illum).(handles.Display.M1_Object).CheckLabel.Cells;
        Time = handles.Export.(handles.Display.SelectedCond{E}).Time;
        T0Ind = handles.Export.(handles.Display.SelectedCond{E}).Experiment.TimeZero;
        if T0Ind <3
            T0Imd = 3;
        end
        NbCell = size(CellTraces,2);
        iter = 0;
        clear GoodTrace
        GoodTrace(1,1:length(Time)) = 0;
        for NumCell = 1:NbCell
            if isfield(handles, 'Limit') && isfield(handles.Limit, 'KeptCells')
                OKCell = ~isempty(find(handles.Limit.KeptCells{E} == NumCell));
            else
                %CHeck if there is no 0 in CHecklabel
                OKCell = min(CheckLabel(:,NumCell)) > 0;
            end
            if OKCell
                iter = iter+1;
                CellNum{E}(iter) = NumCell + E/100;
                Trace = CellTraces(:,NumCell);
                GoodTrace(iter,:) = Trace';
                if ~strcmp(handles.Display.M1_TraceMeas, 'None')
                    Value{1,E}(iter) = MeasureTrace(Time, Trace, handles.Display.M1_TraceMeas, T0Ind);
                end
            end
        end
        %Average all single traces
        if iter > 0
            MeanTrace{1,E} = mean(GoodTrace,1);
            StdTrace{1,E} = std(GoodTrace,0,1);
            SEMTrace{1,E} = std(GoodTrace,0,1)./sqrt(iter);
        else
            MeanTrace{1,E} = zeros(size(Time));
        end
        %Display mean traces
        figure(1);
        set(1, 'Tag', 'FigDisplay')
        hold all
        errorbar(Time./60, MeanTrace{1,E}, SEMTrace{1,E})
        hold off
        CondLegend{E} = [handles.Display.CondStr{E}, ' (', num2str(iter), ')'];
        
        if E==length(handles.Display.SelectedCond)
            xlabel('Time [min]', 'FontSize', 14)
            ylabel([handles.Display.M1_Illum, ' ', handles.Display.M1_Object, ' ', handles.Display.M1_Meas,], 'FontSize', 12)
            set(gca, 'FontSize', 12, 'LineWidth', 1, 'box', 'on')
            legend(CondLegend)
        end
        if ~strcmp(handles.Display.M1_TraceMeas, 'None')
            %Display scatter plot of single trace measurement
            Xval = E + randn(1,iter)./20;
            figure(11)
            set(11, 'Tag', 'FigDisplay')
            hold all
            LineHandle = plot(Xval, Value{1,E}, 'o');
            hold off
            set(LineHandle, 'ButtondownFcn', {@GetCoord }, 'UserData', CellNum{E})
            
            
            CondLegend{E} = [handles.Display.CondStr{E}, ' (', num2str(iter), ')'];
            
            if E==length(handles.Display.SelectedCond)
                
                ylabel([handles.Display.M1_Illum, ' ', handles.Display.M1_Object, ' ', handles.Display.M1_Meas,], 'FontSize', 12)
                set(gca, 'FontSize', 12, 'LineWidth', 1, 'box', 'on')
                set(gca, 'XTick',[1:E],  'XTickLabel', handles.Display.CondStr)
                legend(CondLegend)
                
            end
        end
        
    end
    
    %Display mean of Meas2
    if isfield(handles.Display, 'M2_Meas')
        CellTraces = handles.Export.(handles.Display.SelectedCond{E}).(handles.Display.M2_Illum).(handles.Display.M2_Object).(handles.Display.M2_Meas).Cells;
        CheckLabel = handles.Export.(handles.Display.SelectedCond{E}).(handles.Display.M2_Illum).(handles.Display.M2_Object).CheckLabel.Cells;
        Time = handles.Export.(handles.Display.SelectedCond{E}).Time;
        T0Ind = handles.Export.(handles.Display.SelectedCond{E}).Experiment.TimeZero;
        NbCell = size(CellTraces,2);
        iter = 0;
        GoodTrace(1,1:length(Time)) = 0;
        for NumCell = 1:NbCell
            if isfield(handles, 'Limit') && isfield(handles.Limit, 'KeptCells')
                OKCell = ~isempty(find(handles.Limit.KeptCells{E} == NumCell));
            else
                %CHeck if there is no 0 in CHecklabel
                OKCell = min(CheckLabel(:,NumCell)) > 0;
            end
            if OKCell
                iter = iter+1;
                CellNum{E}(iter) = NumCell + E/100;
                Trace = CellTraces(:,NumCell);
                GoodTrace(iter,:) = Trace';
                if ~strcmp(handles.Display.M1_TraceMeas, 'None')
                    Value{2,E}(iter) = MeasureTrace(Time, Trace, handles.Display.M2_TraceMeas, T0Ind);
                end
            end
        end
        %Average all single traces
        if iter > 0
            MeanTrace{2,E} = mean(GoodTrace,1);
            StdTrace{2,E} = std(GoodTrace,0,1);
            SEMTrace{2,E} = std(GoodTrace,0,1)./sqrt(iter);
        else
            MeanTrace{2,E} = zeros(size(Time));
            SEMTrace{2,E} = zeros(size(Time));
        end
        %Display mean traces
        figure(2)
        set(2, 'Tag', 'FigDisplay')
        hold all
        errorbar(Time./60, MeanTrace{2,E}, SEMTrace{2,E})
        hold off
        CondLegend{E} = [handles.Display.CondStr{E}, ' (', num2str(iter), ')'];
        
        if E==length(handles.Display.SelectedCond)
            xlabel('Time [min]', 'FontSize', 14)
            ylabel([handles.Display.M2_Illum, ' ', handles.Display.M2_Object, ' ', handles.Display.M2_Meas,], 'FontSize', 12)
            set(gca, 'FontSize', 12, 'LineWidth', 1, 'box', 'on')
            legend(CondLegend)
        end
        
        if ~strcmp(handles.Display.M1_TraceMeas, 'None')
            %Display scatter plot of single trace measurement
            Xval = E + randn(1,iter)./20;
            figure(12)
            set(12, 'Tag', 'FigDisplay')
            hold all
            LineHandle = plot(Xval, Value{2,E}, 'o');
            hold off
            set(LineHandle, 'ButtondownFcn', {@GetCoord }, 'UserData', CellNum{E})
            
            CondLegend{E} = [handles.Display.CondStr{E}, ' (', num2str(iter), ')'];
            
            if E==length(handles.Display.SelectedCond)
                
                ylabel([handles.Display.M2_Illum, ' ', handles.Display.M2_Object, ' ', handles.Display.M2_Meas,], 'FontSize', 12)
                set(gca, 'FontSize', 12, 'LineWidth', 1, 'box', 'on')
                set(gca, 'XTick',[1:E],  'XTickLabel', handles.Display.CondStr)
                legend(CondLegend)
                
            end
            
            %Display correlation scatter plot between meas 1 and 2
            
            figure(13)
            set(13, 'Tag', 'FigDisplay')
            hold all
            LineHandle = plot(Value{1,E}, Value{2,E}, 'o');
            hold off
            set(LineHandle, 'ButtondownFcn', {@GetCoord }, 'UserData', CellNum{E})
            
            CondLegend{E} = [handles.Display.CondStr{E}, ' (', num2str(iter), ')'];
            
            if E==length(handles.Display.SelectedCond)
                xlabel([handles.Display.M1_Illum, ' ', handles.Display.M1_Object, ' ', handles.Display.M1_Meas,], 'FontSize', 12)
                ylabel([handles.Display.M2_Illum, ' ', handles.Display.M2_Object, ' ', handles.Display.M2_Meas,], 'FontSize', 12)
                set(gca, 'FontSize', 12, 'LineWidth', 1, 'box', 'on')
                
                legend(CondLegend)
                
            end
        end
    end
    
end


%% Perfom Measurement on single cell trace

function Value = MeasureTrace(Time, Trace, TraceMeas, T0Ind)
%{'None','Mean', 'Median','MaxDiff','FinalDiff', 'Basal', 'VolumeChange','MaxTime' };
switch(TraceMeas)
    case 'Mean'
        Value = mean(Trace);
    case 'Median'
        Value = median(Trace);
    case 'MaxDiff'
        Value = max(Trace) - mean(Trace(1:T0Ind));
    case 'FinalDiff'
        Value = mean(Trace(end-3:end)) - mean(Trace(1:T0Ind));
    case 'Basal'
        Value =  mean(Trace(1:T0Ind));
end


%%
%% Get position in scatter plot

function GetCoord(src,eventdata)

%fprintf('function active')
XData = get(src,'XData');
YData = get(src,'YData');
CellList = get(src, 'UserData');


AxesHandles = get(src, 'Parent');
MousePosition = get(AxesHandles, 'CurrentPoint');
FigHandles = get(AxesHandles, 'Parent');

%find closest data point to mouse position
NormXdata = (XData-min(XData))./(max(XData)-min(XData));
NormYdata = (YData-min(YData))./(max(YData)-min(YData));
NomrXPos = (MousePosition(1,1)-min(XData))./(max(XData)-min(XData));
NormYPos = (MousePosition(1,2)-min(YData))./(max(YData)-min(YData));

%Get index of that point
NormXdist = abs(NormXdata-NomrXPos);
NormYdist = abs(NormYdata-NormYPos);
[MinDist, MinIndex] = min(NormXdist + NormYdist);

%Extract cell index number from CellList stored in plot userData
CellNum = floor(CellList(MinIndex));
ExpNum = round(rem(CellList(MinIndex),1)*100);


%Display trace from selected point
Color = DisplaySelectedTrace(FigHandles, CellNum, ExpNum);

%Display circle on graph
figure(FigHandles)
hold all
plot(XData(MinIndex), YData(MinIndex), 'o', 'Markersize', 16, 'LineWidth', 1.5,'MarkerEdgeColor', Color)
hold off





function Color = DisplaySelectedTrace(FigHandles, CellNum, ExpNum)

%Get handles structure from gui
GUI_handle = findobj('Name','Export2Meas');
handles = guidata(GUI_handle);
%Get time axis
Time = handles.Export.(handles.Display.SelectedCond{ExpNum}).Time;
%Plop first measurement
if FigHandles == 11 || FigHandles == 13
    %Get single cell trace
    M1_Trace = handles.Export.(handles.Display.SelectedCond{ExpNum}).(handles.Display.M1_Illum).(handles.Display.M1_Object).(handles.Display.M1_Meas).Cells(:,CellNum);
    figure(101)
    set(101, 'Tag', 'FigDisplay')
    hold all
    LineHandle = plot(Time./60, M1_Trace);
    ylabel([handles.Display.M1_Illum, ' ', handles.Display.M1_Object, ' ', handles.Display.M1_Meas,], 'FontSize', 12)
    xlabel('Time [min]', 'FontSize', 14)
    set(gca, 'FontSize', 12, 'LineWidth', 1, 'box', 'on')
    hold off
    Color = get(LineHandle, 'Color');
    
end
%Plop second measurement
if FigHandles == 12 || FigHandles == 13
    %Get single cell trace
    M2_Trace = handles.Export.(handles.Display.SelectedCond{ExpNum}).(handles.Display.M2_Illum).(handles.Display.M2_Object).(handles.Display.M2_Meas).Cells(:,CellNum);
    figure(102)
    set(102, 'Tag', 'FigDisplay')
    hold all
    LineHandle = plot(Time./60, M2_Trace);
    ylabel([handles.Display.M2_Illum, ' ', handles.Display.M2_Object, ' ', handles.Display.M2_Meas,], 'FontSize', 12)
    xlabel('Time [min]', 'FontSize', 14)
    set(gca, 'FontSize', 12, 'LineWidth', 1, 'box', 'on')
    hold off
    Color = get(LineHandle, 'Color');
end



function M1_TraceTxt_Callback(hObject, eventdata, handles)
% hObject    handle to M1_TraceTxt (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of M1_TraceTxt as text
%        str2double(get(hObject,'String')) returns contents of M1_TraceTxt as a double


% --- Executes during object creation, after setting all properties.
function M1_TraceTxt_CreateFcn(hObject, eventdata, handles)
% hObject    handle to M1_TraceTxt (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function M2_TraceTxt_Callback(hObject, eventdata, handles)
% hObject    handle to M2_TraceTxt (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of M2_TraceTxt as text
%        str2double(get(hObject,'String')) returns contents of M2_TraceTxt as a double


% --- Executes during object creation, after setting all properties.
function M2_TraceTxt_CreateFcn(hObject, eventdata, handles)
% hObject    handle to M2_TraceTxt (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end






% --- Executes on button press in ActiveLimit.
function ActiveLimit_Callback(hObject, eventdata, handles)
% hObject    handle to ActiveLimit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of ActiveLimit


% --- Executes on button press in SaveAll.
function SaveAll_Callback(hObject, eventdata, handles)
% hObject    handle to SaveAll (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

[FileName,PathName] = uiputfile('*.mat','Save File as...' ,'Export_ALL.mat');
if isfield(handles, 'Limit')
    save(fullfile(PathName, FileName), '-struct', 'handles', 'Export','Display','Limit')
else
    save(fullfile(PathName, FileName), '-struct', 'handles', 'Export','Display')
end

%%%%%%%%%%%%%%%%%  


% --- Executes on button press in LoadSettings.
function LoadSettings_Callback(hObject, eventdata, handles)
% hObject    handle to LoadSettings (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


[ExpFiles,ExpPath] = uigetfile('*.mat','Select a previously saved Export file','MultiSelect','off');

if ExpFiles~= 0
%load export file
load(fullfile(ExpPath, ExpFiles))

if exist('Display','var')
    Display.SelectedCond =  handles.Display.SelectedCond;

    handles.Display = Display;
    set(handles.M1_Illum,'String', handles.Display.AllIllum)
    IllumInd = find(~cellfun(@isempty, strfind(handles.Display.AllIllum, handles.Display.M1_Illum)));
    set(handles.M1_Illum,'Value', IllumInd)
    
    set(handles.M1_Object,'String',handles.Display.M1_Object)
    set(handles.M1_Meas,'String',handles.Display.M1_Meas)
    
    set(handles.M1_TraceMeas,'String',handles.Display.TraceMeas)
    TraceInd = find(~cellfun(@isempty, strfind(handles.Display.TraceMeas, handles.Display.M1_TraceMeas)));
    set(handles.M1_TraceMeas,'Value', TraceInd)
    
    set(handles.M2_Illum,'String', handles.Display.AllIllum)
    set(handles.M2_TraceMeas,'String',handles.Display.TraceMeas)
    if isfield(handles.Display, 'M2_Meas')
        set(handles.M2_Illum,'String', handles.Display.AllIllum)
        IllumInd = find(~cellfun(@isempty, strfind(handles.Display.AllIllum, handles.Display.M2_Illum)));
        set(handles.M2_Illum,'Value', IllumInd)
        
        set(handles.M2_Object,'String',handles.Display.M2_Object)
        set(handles.M2_Meas,'String',handles.Display.M2_Meas)
        
        set(handles.M2_TraceMeas,'String',handles.Display.TraceMeas)
        TraceInd = find(~cellfun(@isempty, strfind(handles.Display.TraceMeas, handles.Display.M2_TraceMeas)));
        set(handles.M2_TraceMeas,'Value', TraceInd)
    end
end
if exist('Limit','var')
    handles.Limit = Limit;
    handles.Limit = rmfield(handles.Limit, 'ValidCells');
    handles.Limit = rmfield(handles.Limit, 'FilteredCells');
    handles.Limit = rmfield(handles.Limit, 'KeptCells');
end

end


% Update handles structure
guidata(hObject, handles);
