function Var = Img2RGB(Var, CallNum)

if nargin == 1
    CallNum = 1;
end

ThreshLevel = 0.002;

if isfield(Var.Analysis, 'RGBinRed') && ~isempty(Var.Analysis.RGBinRed{CallNum})
    Red = double(Var.Img.(Var.Analysis.RGBinRed{CallNum}));
        SortInt = sort(Red(:));
    LowInt = SortInt(round(ThreshLevel*length(SortInt)));
    HiInt = SortInt(round((1-ThreshLevel)*length(SortInt)));
    Red = (Red - LowInt)./(HiInt-LowInt);
    Red(Red >1) = 1;
    Red(Red <0) = 0;
    %Red = (Red - min(Red(:)))./(max(Red(:))-min(Red(:)));
    SizeImg = size(Red);
else
    Red = 0;
end

if isfield(Var.Analysis, 'RGBinGreen') &&~isempty(Var.Analysis.RGBinGreen{CallNum})
    Green = double(Var.Img.(Var.Analysis.RGBinGreen{CallNum}));
    SortInt = sort(Green(:));
    LowInt = SortInt(round(ThreshLevel*length(SortInt)));
    HiInt = SortInt(round((1-ThreshLevel)*length(SortInt)));
    Green = (Green - LowInt)./(HiInt-LowInt);
    Green(Green >1) = 1;
    Green(Green <0) = 0;
    %Green = (Green - min(Green(:)))./(max(Green(:))-min(Green(:)));
    SizeImg = size(Green);
else
    Green = 0;
end

if isfield(Var.Analysis, 'RGBinBlue') &&~isempty(Var.Analysis.RGBinBlue{CallNum})
    Blue = double(Var.Img.(Var.Analysis.RGBinBlue{CallNum}));
        SortInt = sort(Blue(:));
    LowInt = SortInt(round(ThreshLevel*length(SortInt)));
    HiInt = SortInt(round((1-ThreshLevel)*length(SortInt)));
    Blue = (Blue - LowInt)./(HiInt-LowInt);
    Blue(Blue >1) = 1;
    Blue(Blue <0) = 0;
%     Blue = (Blue - min(Blue(:)))./(max(Blue(:))-min(Blue(:)));
    SizeImg = size(Blue);
else
    Blue = 0;
end

RGBImg = zeros(SizeImg(1), SizeImg(2), 3);

RGBImg(:,:,1) = Red;
RGBImg(:,:,2) = Green;
RGBImg(:,:,3) = Blue;

%Check if objects have to be displayed on image
if isfield(Var.Analysis, 'RGBObjectDisplay') ...
        && length(Var.Analysis.RGBObjectDisplay) >= CallNum ...
        && ~isempty(Var.Analysis.RGBObjectDisplay{CallNum})
    %Get object name and properties
    ObjectName = Var.Analysis.RGBObjectDisplay{CallNum};
    Measurements = Var.Measurements.(ObjectName);
    NbObjects = size(Measurements.PixelList,2);
    
    ObjImg = Var.Img.(ObjectName);
    ObjectsProps = regionprops(ObjImg, 'PixelIdxList');
    NumObjects = size(ObjectsProps,1);
    ObjBW = zeros(size(ObjImg));
    ObjBW(ObjImg >0) = 1;
    SatImg = ones(size(ObjImg));
    SE = strel('disk',2);
    ValueImg = ObjBW-imerode(ObjBW,SE);
    HueImg = zeros(size(ObjImg));
    NumColors = 10;
    for O = 1:NumObjects
        HueImg(ObjImg == O) = rem(Measurements.Label{Var.Analysis.FrameIter}(O), NumColors)/NumColors;
    end
    HSVImg(:,:,1) = HueImg;
    HSVImg(:,:,2) =SatImg;
    HSVImg(:,:,3) =ValueImg;
    RGBLabel = hsv2rgb(HSVImg);

    %combine intensity and object images
     NotPerim =  imcomplement(ValueImg);
    NotPerim = NotPerim(:,:,[1,1,1]);
     RGBImg = RGBImg.*NotPerim + RGBLabel;
end


%% Display Image from combined objects
if strcmp(Var.Figure.Display, 'on')
    FigNum = find((strcmp(Var.Figure.List, 'RGBmix')));
    figure(FigNum(CallNum))
    
    image(RGBImg)
    
    set(gca,'ytick',[], 'xtick', []);
    set(gca,'Position',[0 0 1 1 ])
    drawnow
end

Var.Img.(Var.Analysis.RGBOut{CallNum}) = RGBImg;

%% Save Image to file
if strcmp(Var.Analysis.RGBSave{CallNum} , 'Yes')
    if strcmp(Var.Analysis.FrameAnalyzed,'First')
        mkdir([Var.Analysis.OutPath,'_', Var.Analysis.RGBOut{CallNum}]);
    end
    
    FileName = [Var.Analysis.OutPath,'_', Var.Analysis.RGBOut{CallNum}, filesep, 'fr', num2str(Var.Analysis.CurrentFrame,'%03d.png')];
    imwrite(RGBImg,FileName,'png')
%         FileName = [Var.ImgParameters.OutFile{Var.Analysis.CurrentPos,1},'_', Var.Analysis.RGBOUT{CallNum},'_',ObjectName ,'.png'];
%     print(FigNum(CallNum),'-dpng',FileName)
    
end
