function ParallelImgAnalysis(VarCell)

BaseDir = cd;
addpath(fullfile(BaseDir, 'CommonProcess'))
if ~isempty(findstr(VarCell{1}{1}.Analysis.System, 'para'))
    matlabpool local 8
end
NumPositions = length(VarCell);

% %Run Analysis in parallel on each position
parfor I = 1:NumPositions
    PositionAnalysis(VarCell{I}{1});
end
if ~isempty(findstr(VarCell{1}{1}.Analysis.System, 'para'))
	matlabpool close
end

try

%% Export all data in export file
E = 0;
for j = 1:length(VarCell)
    DataFile = [VarCell{j}{1}.Analysis.OutPath,'_Data.mat'];
    load(DataFile);
    if ~isfield(Var, 'error')
        if isfield(Var.Analysis, 'ExportObject')
            for L = 1:length(Var.Analysis.ExportObject)
                Var = GroupForExport(Var, L);
                if isfield(Var.Analysis, 'ExportFileCtreated') && ~isempty(Var.Analysis.ExportFileCtreated)
                   % save export file path
                    E = E+1;
                   ExportFiles{E} = Var.Analysis.ExportFileCtreated;
                end
            end
        end
    end
end

%% export to excell
if isfield(Var.Analysis, 'ExportExcell') && strcmpi(Var.Analysis.ExportExcell, 'YES')
	for e = 1:length(ExportFiles)
    	Export2Excel(ExportFiles{e});
	end
end
catch LastErr
    Var.error = LastErr;
    assignin('base','Var_Error',Var);
    %Save Var file
    FileName = [Var.Analysis.OutPath,'_Data.mat'];
    save(FileName, 'Var');
end

    

rmpath(fullfile(BaseDir, 'CommonProcess'))