function Var = GroupForExport(Var, CallNum)

if nargin == 1
    CallNum = 1;
end
% get Obj and Img parameters
ObjectName = Var.Analysis.ExportObject{CallNum};
ImageName = Var.Analysis.ExportIntensity{CallNum};

%Compare Imagename and thumb image name in VAr

if isfield(Var.Analysis, 'ThumbImg') && sum(strcmp(ImageName, Var.Analysis.ThumbImg)) > 0
    %If they are the same:OK
    ThumbImageName = ImageName;
else
    %If they are not it is because the thumb image comes from the raw img
    %and the measurement from the Corrected one
    % Get the thumb image name by removing the Corr in front of the image
    % name
     ThumbImageName = ImageName(5:end);
end


%Get the measurements
Measurements = Var.Measurements.(ObjectName).(ImageName);
%get measurements list
MeasList = Var.Analysis.ExportMeasurements(CallNum,:);
OnlyStr = iscellstr(MeasList);
while OnlyStr == 0
    MeasList = MeasList(1:end-1);
    OnlyStr = iscellstr(MeasList);
end
%Check if same object /Image is exported multiple times
AllObject = Var.Analysis.ExportObject(:);
AllImage = Var.Analysis.ExportIntensity(:);
SameMeas = intersect(find(strcmp(AllObject, ObjectName)),find(strcmp(AllImage, ImageName)));
%check if it is the first instance of the  Object/Image set
if SameMeas(1) == CallNum
    %Check if Check label is among measurements
    CheckLabInd = find(strcmp(MeasList, 'CheckLabel'));
    if isempty(CheckLabInd)
        MeasList{length(MeasList)+1} = 'CheckLabel';
        AddedCheckLabel = 0;
    else
        AddedCheckLabel = 1;
    end
else
    %Check if Check label is among measurements
    CheckLabInd = find(strcmp(MeasList, 'CheckLabel'));
    if isempty(CheckLabInd)
       MeasList{length(MeasList)+1} = 'CheckLabel';
        AddedCheckLabel = 2;
    else
        AddedCheckLabel = -1;
    end
end


%Calculate nb of frame, Objects and measurements
NbObjects = length(Measurements.(MeasList{1}));
NbFrame = 0;
for O = 1:NbObjects
    NbFrame = max(NbFrame, length(Measurements.(MeasList{1}){O}));
end
NbMeasurements = length(MeasList);
%Creat 3D matrix with all the measurements
MeasurementsMatrix = zeros(NbObjects, NbFrame,NbMeasurements);


%Fill meas and Thumb matrices
for M = 1:NbMeasurements
    for O = 1:NbObjects
        for F = 1:length(Measurements.(MeasList{M}){O})
            MeasurementsMatrix(O,F,M) = Measurements.(MeasList{M}){O}(F);
        end
    end
end

%assignin('base',['MM_',num2str(CallNum)],MeasurementsMatrix);
if isfield(Var.Analysis, 'ExportType') && (strcmp(Var.Analysis.ExportType, 'Tracked') || isnumeric(Var.Analysis.ExportType))
    CheckLabInd = find(strcmp(MeasList, 'CheckLabel'));
    %check which label have no zero (missing tracks)
%     MM_CL = squeeze(MeasurementsMatrix(:,:,CheckLabInd));
%     assignin('base','MM_CL',MM_CL);
    if isnumeric(Var.Analysis.ExportType) && (Var.Analysis.ExportType<NbFrame)
        EndTrack = Var.Analysis.ExportType;
    else
        EndTrack = NbFrame;
    end
    ValidData = find(min(squeeze(MeasurementsMatrix(:,1:EndTrack,CheckLabInd)),[],2)>0);
    NumValid = length(ValidData);
    if NumValid == 0
        %No valid data Stop execution of m file
        return
    else
        MeasurementsMatrix = MeasurementsMatrix(ValidData,:,:);
    end
    
    ExpType = 1;
else
    ExpType = 0;
end

% Var.Analysis.ExportThumb{CallNum} = 'No';

%Check if one need to export the thumbnails
if strcmp(Var.Analysis.ExportThumb{CallNum}, 'Yes')
    %Get thumbnails size
    ThumbSize = 0;
    iter = 1;
    while min(ThumbSize) == 0
        ThumbSize = size(Var.Thumb.(ThumbImageName){1}{iter});
        iter = iter+1;
    end
    if ExpType == 0
        ThumbMatrix = uint8(zeros(NbObjects, NbFrame, ThumbSize(1), ThumbSize(2)));
        ThumbObjMatrix = uint8(zeros(NbObjects, NbFrame, ThumbSize(1), ThumbSize(2)));
    else
        ThumbMatrix = uint8(zeros(NumValid, NbFrame, ThumbSize(1), ThumbSize(2)));
        ThumbObjMatrix = uint8(zeros(NumValid, NbFrame, ThumbSize(1), ThumbSize(2)));
    end
    ExpThumb = 1;
else
    ExpThumb = 0;
end

%Fill meas and Thumb matrices
if  ExpThumb == 1 && ExpType == 0
    for O = 1:NbObjects
        for F = 1:length(Measurements.(MeasList{M}){O})
            if  ~isempty(Var.Thumb.(ThumbImageName){F}{O})
                ThumbMatrix(O,F,:,:) = Var.Thumb.(ThumbImageName){F}{O};
                ThumbObjMatrix(O,F,:,:) = Var.Thumb.([ThumbImageName, 'Obj']){F}{O};
            end
        end
    end
elseif ExpThumb == 1 && ExpType == 1
    for F = 1:NbFrame
        for O = 1:NumValid
%             F = F;
%             VD = ValidData(O);
%             ST = size(Var.Thumb.(ThumbImageName){F}{ValidData(O)});
            ThumbMatrix(O,F,:,:) = Var.Thumb.(ThumbImageName){F}{ValidData(O)};
            ThumbObjMatrix(O,F,:,:) = Var.Thumb.([ThumbImageName, 'Obj']){F}{ValidData(O)};
        end
    end
end

if AddedCheckLabel == 0
    %Add Stage Position number in Measurements matrix and keep Check Label
    NbMeasurements = NbMeasurements+1;
    MeasList{NbMeasurements} = 'Position';
    MeasurementsMatrix(:,:,NbMeasurements) = Var.Analysis.CurrentPos;
elseif AddedCheckLabel == 1
   %Add Stage Position number in Measurements matrix and keep Check Label
    NbMeasurements = NbMeasurements+1;
    MeasList{NbMeasurements} = 'Position';
    MeasurementsMatrix(:,:,NbMeasurements) = Var.Analysis.CurrentPos;
elseif AddedCheckLabel == 2
    %remove Checklabel and don't add Position
    NbMeasurements = NbMeasurements-1;
    MeasList = MeasList(1:NbMeasurements);

elseif AddedCheckLabel == -1
     %remove Checklabel and don't add Position
    NbMeasurements = NbMeasurements-1;
    MeasList = MeasList(1:NbMeasurements);
end
    

%get time axis from Time stamps
if isfield(Var.Analysis, 'TimeStamp')
    TimeAxis =(Var.Analysis.TimeStamp - Var.Analysis.TimeZero)./1000;
    %Make sure that time increases linearly
    %for Experiments that take place over midnight Add 24 hours shift to
    %time stamp
    for TA = 2: length(TimeAxis)
        if TimeAxis(TA) < TimeAxis(TA-1)
            TimeAxis(TA) = TimeAxis(TA)+24*60*60;
        end
    end
else
     TimeAxis = ([1:NbFrame]-(Var.Experiment.TimeZero)).*Var.Experiment.TimeStep;
end



%% Export File
%generate export file name
if isfield(Var.Analysis, 'ExportFolder')
    [UpDir, FolderName] = fileparts(Var.Analysis.ExportFolder);
    SaveDir = Var.Analysis.ExportFolder;
else
    [SaveDir] = fileparts(Var.Analysis.OutPath);
    [UpDir, FolderName] = fileparts(SaveDir);
end
ExpFileName = ['Export_', FolderName, '.mat'];

% try to load it
try
    load(fullfile(SaveDir, ExpFileName))
    Var.Analysis.ExportFileCtreated = [];
    % assignin('base','ExportIMP',Export);
catch
    fprintf('\nCreate Export File\n')
    Export = [];
    Var.Analysis.ExportFileCtreated = fullfile(SaveDir, ExpFileName);
end

%Get field label

FieldLabel = Var.Analysis.CurrentCondition;
FieldLabel = regexprep(FieldLabel, ' ', '_');
FieldLabel= regexprep(FieldLabel, '\.', 'p');
FieldLabel= regexprep(FieldLabel, '-', '_');

if ~isvarname(FieldLabel)
    FieldLabel = ['c_',FieldLabel];
end
%Check if field label already exists
if isfield(Export, FieldLabel) && isfield(Export.(FieldLabel),ImageName) ...
        && isfield(Export.(FieldLabel).(ImageName),ObjectName)...
        && isfield(Export.(FieldLabel).(ImageName).(ObjectName),(MeasList{1}))
    %Transfer meas to export variable
   % fprintf('exist')
    for M = 1:NbMeasurements
        
        %S_E = size(Export.(FieldLabel).(ImageName).(ObjectName).(MeasList{M}).Cells)
        Export.(FieldLabel).(ImageName).(ObjectName).(MeasList{M}).Cells = ...
            [Export.(FieldLabel).(ImageName).(ObjectName).(MeasList{M}).Cells, squeeze(MeasurementsMatrix(:,:,M))'];
    end
else
    %fprintf('NOT exist')
    %if Fieldlabel does not exist initalize it with those measurements
    for M = 1:NbMeasurements
        Export.(FieldLabel).(ImageName).(ObjectName).(MeasList{M}).Cells =  squeeze(MeasurementsMatrix(:,:,M)');
        %Add time step to export
        Export.(FieldLabel).Time = TimeAxis;
        %Add Experiment conditions to export
        Export.(FieldLabel).Experiment = Var.Experiment;
    end
end

if ExpThumb== 1
    if isfield(Export.(FieldLabel).(ImageName), 'Thumb')
        Export.(FieldLabel).(ImageName).Thumb = [Export.(FieldLabel).(ImageName).Thumb; ThumbMatrix];
        Export.(FieldLabel).([ImageName,'Obj']).Thumb = [Export.(FieldLabel).([ImageName,'Obj']).Thumb; ThumbObjMatrix];
    else
        Export.(FieldLabel).(ImageName).Thumb = ThumbMatrix;
        Export.(FieldLabel).([ImageName,'Obj']).Thumb = ThumbObjMatrix;
    end
end
assignin('base','Export',Export);
%Save export variable
save(fullfile(SaveDir, ExpFileName), 'Export')
    
