function Var = CutThumbnails(Var, CallNum)

if nargin == 1
    CallNum = 1;
end
Debug = 0;

%Get Image
FullImg = double(Var.Img.(Var.Analysis.ThumbImg{CallNum}));

%Get centers from measurements found in the reference object
CenterX = round(Var.Measurements.(Var.Analysis.CenterObj).CenterX{Var.Analysis.CurrentFrame});
CenterY = round(Var.Measurements.(Var.Analysis.CenterObj).CenterY{Var.Analysis.CurrentFrame});
%Get object image from an other object
Label = Var.Measurements.(Var.Analysis.ThumbObj{CallNum}).Label{Var.Analysis.CurrentFrame};


Border = Var.Analysis.ThumbSize{CallNum};
%Loop Through all objects
NumObj = length(CenterX);
for O = 1:NumObj
    CutImg = zeros(2*Border+1);
    CutObjImg = zeros(2*Border+1);
    CutLim = [1,2*Border+1,1,2*Border+1];
    %Y limits
    Low = CenterY(O)-Border;
    if Low < 1
        Low = 1;
        Diff = Border-CenterY(O);
        CutLim(1) = Diff+2;
    end
    High = CenterY(O)+Border;
    if High > size(FullImg,1)
        High = size(FullImg,1);
        Diff = CenterY(O)+Border-size(FullImg,1);
        CutLim(2) = 2*Border+1-Diff;
    end
    %Xlimits
    Left = CenterX(O)-Border;
    if Left < 1
        Left = 1;
        Diff = Border-CenterX(O);
        CutLim(3) = Diff+2;
    end
    Right = CenterX(O)+Border;
    if Right > size(FullImg,2)
        Right = size(FullImg,2);
        Diff = CenterX(O)+Border-size(FullImg,2);
        CutLim(4) = 2*Border+1-Diff;
    end
    CutImg(CutLim(1):CutLim(2),CutLim(3):CutLim(4)) = FullImg(Low:High, Left:Right);
    Var.Thumb.(Var.Analysis.ThumbImg{CallNum}){Var.Analysis.CurrentFrame}{Label(O)} = uint8(CutImg./2^12.*2^8);
    
    ObjImg = zeros(size(FullImg));
    ObjImg(Var.Measurements.(Var.Analysis.ThumbObj{CallNum}).PixelList{Var.Analysis.CurrentFrame,Label(O)}) = 1;
    CutObjImg(CutLim(1):CutLim(2),CutLim(3):CutLim(4)) = ObjImg(Low:High, Left:Right);
    Var.Thumb.([Var.Analysis.ThumbImg{CallNum},'Obj']){Var.Analysis.CurrentFrame}{Label(O)} = uint8(CutObjImg);
    
    
    if Debug == 1
    figure(100)
    imagesc(CutImg); title(num2str(O))

    
    figure(101)
    imagesc(FullImg); title(num2str(O))
    hold on
    plot([Left, Left, Right, Right, Left],[Low, High, High, Low, Low], 'r') 
    plot(CenterX(O), CenterY(O), 'rx')
    drawnow
    pause(2)
    end
end
    
    



