/*
 * Decompiled with CFR 0.152.
 */
package com.filemaker.largeobject;

import com.filemaker.largeobject.LargeObject;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;

public class BlobOutputStream
extends OutputStream {
    private LargeObject lo;
    private byte[] buf;
    private int bsize;
    private int bpos;

    public BlobOutputStream(LargeObject largeObject) {
        this(largeObject, 1024);
    }

    public BlobOutputStream(LargeObject largeObject, int n) {
        this.lo = largeObject;
        this.bsize = n;
        this.buf = new byte[n];
        this.bpos = 0;
    }

    public void write(int n) throws IOException {
        try {
            if (this.bpos >= this.bsize) {
                this.lo.write(this.buf);
                this.bpos = 0;
            }
            this.buf[this.bpos++] = (byte)n;
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.toString());
        }
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        try {
            if (this.bpos > 0) {
                this.flush();
            }
            if (n == 0 && n2 == byArray.length) {
                this.lo.write(byArray);
            } else {
                this.lo.write(byArray, n, n2);
            }
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.toString());
        }
    }

    public void flush() throws IOException {
        try {
            if (this.bpos > 0) {
                this.lo.write(this.buf, 0, this.bpos);
            }
            this.bpos = 0;
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.toString());
        }
    }

    public void close() throws IOException {
        try {
            this.flush();
            this.lo.close();
            this.lo = null;
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.toString());
        }
    }
}

