/*
 * Decompiled with CFR 0.152.
 */
package com.filemaker.jdbc1;

import com.filemaker.jdbc.BaseStatement;
import com.filemaker.jdbc.Driver;
import com.filemaker.jdbc.Encoding;
import com.filemaker.jdbc.Field;
import com.filemaker.jdbc1.CommonJ1Connection;
import com.filemaker.jdbc1.CommonJ1Statement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;

public abstract class CommonJ1DatabaseMetaData {
    private static final String keywords = "";
    protected CommonJ1Connection connection;
    protected Encoding encoding;
    private int NAMEDATALEN = 0;
    private int INDEX_MAX_KEYS = 0;

    protected int getMaxIndexKeys() throws SQLException {
        return this.INDEX_MAX_KEYS;
    }

    protected int getMaxNameLength() throws SQLException {
        return this.NAMEDATALEN - 1;
    }

    public CommonJ1DatabaseMetaData(CommonJ1Connection commonJ1Connection) {
        this.connection = commonJ1Connection;
        try {
            this.encoding = commonJ1Connection.getEncoding();
        }
        catch (SQLException sQLException) {
            this.encoding = Encoding.defaultEncoding();
        }
    }

    public boolean allProceduresAreCallable() throws SQLException {
        return false;
    }

    public boolean allTablesAreSelectable() throws SQLException {
        return true;
    }

    public String getURL() throws SQLException {
        return this.connection.getURL();
    }

    public String getUserName() throws SQLException {
        return this.connection.getUserName();
    }

    public boolean isReadOnly() throws SQLException {
        return this.connection.isReadOnly();
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedLow() throws SQLException {
        return true;
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    public String getDatabaseProductName() throws SQLException {
        return "FileMaker";
    }

    public String getDatabaseProductVersion() throws SQLException {
        return this.connection.getDBVersionNumber();
    }

    public String getDriverName() throws SQLException {
        return "FileMaker JDBC";
    }

    public String getDriverVersion() throws SQLException {
        return Driver.getVersion();
    }

    public int getDriverMajorVersion() {
        return this.connection.this_driver.getMajorVersion();
    }

    public int getDriverMinorVersion() {
        return this.connection.this_driver.getMinorVersion();
    }

    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return true;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    public String getIdentifierQuoteString() throws SQLException {
        return "\"";
    }

    public String getSQLKeywords() throws SQLException {
        return keywords;
    }

    public String getNumericFunctions() throws SQLException {
        return "FLOOR,MOD,POWER,ROUND";
    }

    public String getStringFunctions() throws SQLException {
        return "CHAR,CONCAT,LCASE,LEFT,LENGTH,LTRIM,RIGHT,RTRIM,SPACE,SUBSTRING,UCASE";
    }

    public String getSystemFunctions() throws SQLException {
        return "USERNAME";
    }

    public String getTimeDateFunctions() throws SQLException {
        return "CURDATE,CURRENT_DATE,CURRENT_TIME,CURTIME,DAYOFMONTH,DAYOFWEEK,MONTH,YEAR";
    }

    public String getSearchStringEscape() throws SQLException {
        return "~";
    }

    public String getExtraNameCharacters() throws SQLException {
        return "~@#$%^&*_-+=\\}{;:?/><,.![]";
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return true;
    }

    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        return false;
    }

    public boolean supportsConvert() throws SQLException {
        return false;
    }

    public boolean supportsConvert(int n, int n2) throws SQLException {
        return false;
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return false;
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        return false;
    }

    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        return true;
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return false;
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        return false;
    }

    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        return false;
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        return false;
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return false;
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return false;
    }

    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        return false;
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    public String getSchemaTerm() throws SQLException {
        return keywords;
    }

    public String getProcedureTerm() throws SQLException {
        return keywords;
    }

    public String getCatalogTerm() throws SQLException {
        return keywords;
    }

    public boolean isCatalogAtStart() throws SQLException {
        return false;
    }

    public String getCatalogSeparator() throws SQLException {
        return keywords;
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return false;
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return false;
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        return true;
    }

    public boolean supportsStoredProcedures() throws SQLException {
        return false;
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return true;
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return true;
    }

    public boolean supportsUnion() throws SQLException {
        return true;
    }

    public boolean supportsUnionAll() throws SQLException {
        return true;
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return true;
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return true;
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return true;
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return true;
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0;
    }

    public int getMaxCharLiteralLength() throws SQLException {
        return 0;
    }

    public int getMaxColumnNameLength() throws SQLException {
        return 100;
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInIndex() throws SQLException {
        return 1;
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInSelect() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInTable() throws SQLException {
        return 1024;
    }

    public int getMaxConnections() throws SQLException {
        return 0;
    }

    public int getMaxCursorNameLength() throws SQLException {
        return 18;
    }

    public int getMaxIndexLength() throws SQLException {
        return 0;
    }

    public int getMaxSchemaNameLength() throws SQLException {
        return 0;
    }

    public int getMaxProcedureNameLength() throws SQLException {
        return 0;
    }

    public int getMaxCatalogNameLength() throws SQLException {
        return 0;
    }

    public int getMaxRowSize() throws SQLException {
        return 0;
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return false;
    }

    public int getMaxStatementLength() throws SQLException {
        return 0;
    }

    public int getMaxStatements() throws SQLException {
        return 0;
    }

    public int getMaxTableNameLength() throws SQLException {
        return 100;
    }

    public int getMaxTablesInSelect() throws SQLException {
        return 31;
    }

    public int getMaxUserNameLength() throws SQLException {
        return 0;
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        return 2;
    }

    public boolean supportsTransactions() throws SQLException {
        return true;
    }

    public boolean supportsTransactionIsolationLevel(int n) throws SQLException {
        return n == 8 || n == 2;
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return false;
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return true;
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return false;
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    protected static String escapeQuotes(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        int n2 = 32;
        int n3 = 32;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            stringBuffer.append(c);
            if (c == '\'' && (n2 != 92 || n2 == 92 && n3 == 92)) {
                stringBuffer.append("'");
            }
            n3 = n2;
            n2 = c;
        }
        return stringBuffer.toString();
    }

    public ResultSet getProcedures(String string, String string2, String string3) throws SQLException {
        Field[] fieldArray = new Field[8];
        Vector vector = new Vector();
        fieldArray[0] = new Field(this.connection, "PROCEDURE_CAT", 12, this.getMaxNameLength());
        fieldArray[1] = new Field(this.connection, "PROCEDURE_SCHEM", 12, this.getMaxNameLength());
        fieldArray[2] = new Field(this.connection, "PROCEDURE_NAME", 12, this.getMaxNameLength());
        fieldArray[3] = new Field(this.connection, "RESERVED1", 12, this.getMaxNameLength());
        fieldArray[4] = new Field(this.connection, "RESERVED2", 12, this.getMaxNameLength());
        fieldArray[5] = new Field(this.connection, "RESERVED3", 12, this.getMaxNameLength());
        fieldArray[6] = new Field(this.connection, "REMARKS", 12, this.getMaxNameLength());
        fieldArray[7] = new Field(this.connection, "PROCEDURE_TYPE", 5, 2L);
        return (ResultSet)((Object)((BaseStatement)((Object)this.connection.createStatement())).createResultSet(fieldArray, vector, "OK", 1, 0L, false));
    }

    public ResultSet getProcedureColumns(String string, String string2, String string3, String string4) throws SQLException {
        Field[] fieldArray = new Field[13];
        Vector vector = new Vector();
        fieldArray[0] = new Field(this.connection, "PROCEDURE_CAT", 12, this.getMaxNameLength());
        fieldArray[1] = new Field(this.connection, "PROCEDURE_SCHEM", 12, this.getMaxNameLength());
        fieldArray[2] = new Field(this.connection, "PROCEDURE_NAME", 12, this.getMaxNameLength());
        fieldArray[3] = new Field(this.connection, "COLUMN_NAME", 12, this.getMaxNameLength());
        fieldArray[4] = new Field(this.connection, "COLUMN_TYPE", 5, 2L);
        fieldArray[5] = new Field(this.connection, "DATA_TYPE", 5, 2L);
        fieldArray[6] = new Field(this.connection, "TYPE_NAME", 12, this.getMaxNameLength());
        fieldArray[7] = new Field(this.connection, "PRECISION", 4, 4L);
        fieldArray[8] = new Field(this.connection, "LENGTH", 4, 4L);
        fieldArray[9] = new Field(this.connection, "SCALE", 5, 2L);
        fieldArray[10] = new Field(this.connection, "RADIX", 5, 2L);
        fieldArray[11] = new Field(this.connection, "NULLABLE", 5, 2L);
        fieldArray[12] = new Field(this.connection, "REMARKS", 12, this.getMaxNameLength());
        return (ResultSet)((Object)((BaseStatement)((Object)this.connection.createStatement())).createResultSet(fieldArray, vector, "OK", 1, 0L, false));
    }

    public ResultSet getTables(String string, String string2, String string3, String[] stringArray) throws SQLException {
        String string4 = string3;
        if (string4 == null) {
            string4 = keywords;
        }
        Field[] fieldArray = new Field[5];
        Vector<byte[][]> vector = new Vector<byte[][]>();
        fieldArray[0] = new Field(this.connection, "TABLE_CAT", 12, this.getMaxNameLength());
        fieldArray[1] = new Field(this.connection, "TABLE_SCHEM", 12, this.getMaxNameLength());
        fieldArray[2] = new Field(this.connection, "TABLE_NAME", 12, this.getMaxNameLength());
        fieldArray[3] = new Field(this.connection, "TABLE_TYPE", 12, this.getMaxNameLength());
        fieldArray[4] = new Field(this.connection, "REMARKS", 12, this.getMaxNameLength());
        ResultSet resultSet = ((CommonJ1Statement)((Object)this.connection.createStatement())).getTables(string4);
        while (resultSet.next()) {
            byte[][] byArrayArray = new byte[][]{null, null, resultSet.getBytes(1), this.encoding.encode("TABLE"), null};
            vector.addElement(byArrayArray);
        }
        resultSet.close();
        return (ResultSet)((Object)((BaseStatement)((Object)this.connection.createStatement())).createResultSet(fieldArray, vector, "OK", 1, 0L, false));
    }

    public ResultSet getSchemas() throws SQLException {
        Field[] fieldArray = new Field[1];
        Vector vector = new Vector();
        fieldArray[0] = new Field(this.connection, new String("TABLE_SCHEM"), 12, this.getMaxNameLength());
        return (ResultSet)((Object)((BaseStatement)((Object)this.connection.createStatement())).createResultSet(fieldArray, vector, "OK", 1, 0L, false));
    }

    public ResultSet getCatalogs() throws SQLException {
        Field[] fieldArray = new Field[1];
        Vector vector = new Vector();
        fieldArray[0] = new Field(this.connection, new String("TABLE_CAT"), 12, this.getMaxNameLength());
        return (ResultSet)((Object)((BaseStatement)((Object)this.connection.createStatement())).createResultSet(fieldArray, vector, "OK", 1, 0L, false));
    }

    public ResultSet getTableTypes() throws SQLException {
        Field[] fieldArray = new Field[1];
        Vector<byte[][]> vector = new Vector<byte[][]>();
        fieldArray[0] = new Field(this.connection, new String("TABLE_TYPE"), 12, this.getMaxNameLength());
        byte[][] byArrayArray = new byte[][]{this.encoding.encode("TABLE")};
        vector.addElement(byArrayArray);
        return (ResultSet)((Object)((BaseStatement)((Object)this.connection.createStatement())).createResultSet(fieldArray, vector, "OK", 1, 0L, false));
    }

    public ResultSet getColumns(String string, String string2, String string3, String string4) throws SQLException {
        String string5;
        String string6 = string3;
        if (string6 == null) {
            string6 = keywords;
        }
        if ((string5 = string4) == null) {
            string5 = keywords;
        }
        Vector<byte[][]> vector = new Vector<byte[][]>();
        Field[] fieldArray = new Field[]{new Field(this.connection, "TABLE_CAT", 12, this.getMaxNameLength()), new Field(this.connection, "TABLE_SCHEM", 12, this.getMaxNameLength()), new Field(this.connection, "TABLE_NAME", 12, this.getMaxNameLength()), new Field(this.connection, "COLUMN_NAME", 12, this.getMaxNameLength()), new Field(this.connection, "DATA_TYPE", 5, 2L), new Field(this.connection, "TYPE_NAME", 12, this.getMaxNameLength()), new Field(this.connection, "COLUMN_SIZE", 4, 4L), new Field(this.connection, "BUFFER_LENGTH", 12, this.getMaxNameLength()), new Field(this.connection, "DECIMAL_DIGITS", 4, 4L), new Field(this.connection, "NUM_PREC_RADIX", 4, 4L), new Field(this.connection, "NULLABLE", 4, 4L), new Field(this.connection, "REMARKS", 12, this.getMaxNameLength()), new Field(this.connection, "COLUMN_DEF", 12, this.getMaxNameLength()), new Field(this.connection, "SQL_DATA_TYPE", 4, 4L), new Field(this.connection, "SQL_DATETIME_SUB", 4, 4L), new Field(this.connection, "CHAR_OCTET_LENGTH", 12, this.getMaxNameLength()), new Field(this.connection, "ORDINAL_POSITION", 4, 4L), new Field(this.connection, "IS_NULLABLE", 12, this.getMaxNameLength())};
        ResultSet resultSet = ((CommonJ1Statement)((Object)this.connection.createStatement())).getColumns(string6, string5);
        int n = 1;
        while (resultSet.next()) {
            int n2 = Integer.parseInt(resultSet.getString(3));
            int n3 = this.connection.getSQLType(n2);
            String string7 = this.connection.getFMType(n3);
            byte[][] byArrayArray = new byte[][]{null, null, resultSet.getBytes(1), resultSet.getBytes(2), Integer.toString(n3).getBytes(), resultSet.getBytes(4), resultSet.getBytes(6), resultSet.getBytes(6), resultSet.getBytes(6), this.encoding.encode("10"), resultSet.getBytes(7), null, resultSet.getBytes(8), Integer.toString(n3).getBytes(), null, resultSet.getBytes(6), Integer.toString(n).getBytes(), Integer.parseInt(resultSet.getString(7)) == 1 ? this.encoding.encode("YES") : this.encoding.encode("NO")};
            vector.addElement(byArrayArray);
            ++n;
        }
        resultSet.close();
        return (ResultSet)((Object)((BaseStatement)((Object)this.connection.createStatement())).createResultSet(fieldArray, vector, "OK", 1, 0L, false));
    }

    public ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) throws SQLException {
        Field[] fieldArray = new Field[8];
        Vector<byte[][]> vector = new Vector<byte[][]>();
        if (string3 == null) {
            string3 = "%";
        }
        if (string4 == null) {
            string4 = "%";
        }
        fieldArray[0] = new Field(this.connection, "TABLE_CAT", 12, this.getMaxNameLength());
        fieldArray[1] = new Field(this.connection, "TABLE_SCHEM", 12, this.getMaxNameLength());
        fieldArray[2] = new Field(this.connection, "TABLE_NAME", 12, this.getMaxNameLength());
        fieldArray[3] = new Field(this.connection, "COLUMN_NAME", 12, this.getMaxNameLength());
        fieldArray[4] = new Field(this.connection, "GRANTOR", 12, this.getMaxNameLength());
        fieldArray[5] = new Field(this.connection, "GRANTEE", 12, this.getMaxNameLength());
        fieldArray[6] = new Field(this.connection, "PRIVILEGE", 12, this.getMaxNameLength());
        fieldArray[7] = new Field(this.connection, "IS_GRANTABLE", 12, this.getMaxNameLength());
        ResultSet resultSet = ((CommonJ1Statement)((Object)this.connection.createStatement())).getColumnPrivileges(string3, string4);
        while (resultSet.next()) {
            byte[][] byArrayArray = new byte[][]{null, null, resultSet.getBytes(1), resultSet.getBytes(2), null, resultSet.getBytes(3), resultSet.getBytes(4), resultSet.getBytes(5)};
            vector.addElement(byArrayArray);
        }
        resultSet.close();
        return (ResultSet)((Object)((BaseStatement)((Object)this.connection.createStatement())).createResultSet(fieldArray, vector, "OK", 1, 0L, false));
    }

    public ResultSet getTablePrivileges(String string, String string2, String string3) throws SQLException {
        Field[] fieldArray = new Field[7];
        Vector vector = new Vector();
        fieldArray[0] = new Field(this.connection, "TABLE_CAT", 12, this.getMaxNameLength());
        fieldArray[1] = new Field(this.connection, "TABLE_SCHEM", 12, this.getMaxNameLength());
        fieldArray[2] = new Field(this.connection, "TABLE_NAME", 12, this.getMaxNameLength());
        fieldArray[3] = new Field(this.connection, "GRANTOR", 12, this.getMaxNameLength());
        fieldArray[4] = new Field(this.connection, "GRANTEE", 12, this.getMaxNameLength());
        fieldArray[5] = new Field(this.connection, "PRIVILEGE", 12, this.getMaxNameLength());
        fieldArray[6] = new Field(this.connection, "IS_GRANTABLE", 12, this.getMaxNameLength());
        return (ResultSet)((Object)((BaseStatement)((Object)this.connection.createStatement())).createResultSet(fieldArray, vector, "OK", 1, 0L, false));
    }

    private static void sortStringArray(String[] stringArray) {
        for (int i = 0; i < stringArray.length - 1; ++i) {
            for (int j = i + 1; j < stringArray.length; ++j) {
                if (stringArray[i].compareTo(stringArray[j]) <= 0) continue;
                String string = stringArray[i];
                stringArray[i] = stringArray[j];
                stringArray[j] = string;
            }
        }
    }

    public ResultSet getBestRowIdentifier(String string, String string2, String string3, int n, boolean bl) throws SQLException {
        Field[] fieldArray = new Field[8];
        Vector<byte[][]> vector = new Vector<byte[][]>();
        fieldArray[0] = new Field(this.connection, "SCOPE", 5, 2L);
        fieldArray[1] = new Field(this.connection, "COLUMN_NAME", 12, this.getMaxNameLength());
        fieldArray[2] = new Field(this.connection, "DATA_TYPE", 5, 2L);
        fieldArray[3] = new Field(this.connection, "TYPE_NAME", 12, this.getMaxNameLength());
        fieldArray[4] = new Field(this.connection, "COLUMN_SIZE", 4, 4L);
        fieldArray[5] = new Field(this.connection, "BUFFER_LENGTH", 4, 4L);
        fieldArray[6] = new Field(this.connection, "DECIMAL_DIGITS", 5, 2L);
        fieldArray[7] = new Field(this.connection, "PSEUDO_COLUMN", 5, 2L);
        byte[][] byArrayArray = new byte[][]{Integer.toString(1).getBytes(), this.encoding.encode("ROWID"), Integer.toString(12).getBytes(), this.encoding.encode("ROWID"), Integer.toString(18).getBytes(), Integer.toString(18).getBytes(), Integer.toString(0).getBytes(), Integer.toString(2).getBytes()};
        vector.addElement(byArrayArray);
        return (ResultSet)((Object)((BaseStatement)((Object)this.connection.createStatement())).createResultSet(fieldArray, vector, "OK", 1, 0L, false));
    }

    public ResultSet getVersionColumns(String string, String string2, String string3) throws SQLException {
        Field[] fieldArray = new Field[8];
        Vector<byte[][]> vector = new Vector<byte[][]>();
        fieldArray[0] = new Field(this.connection, "SCOPE", 5, 2L);
        fieldArray[1] = new Field(this.connection, "COLUMN_NAME", 12, this.getMaxNameLength());
        fieldArray[2] = new Field(this.connection, "DATA_TYPE", 5, 2L);
        fieldArray[3] = new Field(this.connection, "TYPE_NAME", 12, this.getMaxNameLength());
        fieldArray[4] = new Field(this.connection, "COLUMN_SIZE", 4, 4L);
        fieldArray[5] = new Field(this.connection, "BUFFER_LENGTH", 4, 4L);
        fieldArray[6] = new Field(this.connection, "DECIMAL_DIGITS", 5, 2L);
        fieldArray[7] = new Field(this.connection, "PSEUDO_COLUMN", 5, 2L);
        byte[][] byArrayArray = new byte[][]{Integer.toString(1).getBytes(), this.encoding.encode("ROWID"), Integer.toString(12).getBytes(), this.encoding.encode("ROWID"), Integer.toString(18).getBytes(), Integer.toString(18).getBytes(), Integer.toString(0).getBytes(), Integer.toString(2).getBytes()};
        vector.addElement(byArrayArray);
        return (ResultSet)((Object)((BaseStatement)((Object)this.connection.createStatement())).createResultSet(fieldArray, vector, "OK", 1, 0L, false));
    }

    public ResultSet getPrimaryKeys(String string, String string2, String string3) throws SQLException {
        Field[] fieldArray = new Field[6];
        Vector<byte[][]> vector = new Vector<byte[][]>();
        fieldArray[0] = new Field(this.connection, "TABLE_CAT", 12, this.getMaxNameLength());
        fieldArray[1] = new Field(this.connection, "TABLE_SCHEM", 12, this.getMaxNameLength());
        fieldArray[2] = new Field(this.connection, "TABLE_NAME", 12, this.getMaxNameLength());
        fieldArray[3] = new Field(this.connection, "COLUMN_NAME", 12, this.getMaxNameLength());
        fieldArray[4] = new Field(this.connection, "KEY_SEQ", 5, 4L);
        fieldArray[5] = new Field(this.connection, "PK_NAME", 12, this.getMaxNameLength());
        ResultSet resultSet = ((CommonJ1Statement)((Object)this.connection.createStatement())).getPrimaryKeys(string3);
        int n = 1;
        while (resultSet.next()) {
            byte[][] byArrayArray = new byte[][]{null, null, resultSet.getBytes(1), resultSet.getBytes(2), Integer.toString(n).getBytes(), null};
            vector.addElement(byArrayArray);
            ++n;
        }
        resultSet.close();
        return (ResultSet)((Object)((BaseStatement)((Object)this.connection.createStatement())).createResultSet(fieldArray, vector, "OK", 1, 0L, false));
    }

    protected ResultSet getImportedExportedKeys(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        Field[] fieldArray = new Field[14];
        Vector vector = new Vector();
        fieldArray[0] = new Field(this.connection, "PKTABLE_CAT", 12, this.getMaxNameLength());
        fieldArray[1] = new Field(this.connection, "PKTABLE_SCHEM", 12, this.getMaxNameLength());
        fieldArray[2] = new Field(this.connection, "PKTABLE_NAME", 12, this.getMaxNameLength());
        fieldArray[3] = new Field(this.connection, "PKCOLUMN_NAME", 12, this.getMaxNameLength());
        fieldArray[4] = new Field(this.connection, "FKTABLE_CAT", 12, this.getMaxNameLength());
        fieldArray[5] = new Field(this.connection, "FKTABLE_SCHEM", 12, this.getMaxNameLength());
        fieldArray[6] = new Field(this.connection, "FKTABLE_NAME", 12, this.getMaxNameLength());
        fieldArray[7] = new Field(this.connection, "FKCOLUMN_NAME", 12, this.getMaxNameLength());
        fieldArray[8] = new Field(this.connection, "KEY_SEQ", 5, 2L);
        fieldArray[9] = new Field(this.connection, "UPDATE_RULE", 5, 2L);
        fieldArray[10] = new Field(this.connection, "DELETE_RULE", 5, 2L);
        fieldArray[11] = new Field(this.connection, "FK_NAME", 12, this.getMaxNameLength());
        fieldArray[12] = new Field(this.connection, "PK_NAME", 12, this.getMaxNameLength());
        fieldArray[13] = new Field(this.connection, "DEFERRABILITY", 5, 2L);
        return (ResultSet)((Object)((BaseStatement)((Object)this.connection.createStatement())).createResultSet(fieldArray, vector, "OK", 1, 0L, false));
    }

    public ResultSet getImportedKeys(String string, String string2, String string3) throws SQLException {
        return this.getImportedExportedKeys(null, null, null, string, string2, string3);
    }

    public ResultSet getExportedKeys(String string, String string2, String string3) throws SQLException {
        return this.getImportedExportedKeys(string, string2, string3, null, null, null);
    }

    public ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        return this.getImportedExportedKeys(string, string2, string3, string4, string5, string6);
    }

    public void appendTypeInfo(Vector vector, String string, int n, int n2, String string2, String string3, String string4, int n3, int n4, int n5, Integer n6, int n7, Integer n8, String string5, Integer n9, Integer n10, int n11, Integer n12, Integer n13) throws SQLException {
        byte[][] byArrayArray = new byte[][]{this.encoding.encode(string), Integer.toString(n).getBytes(), Integer.toString(n2).getBytes(), (byte[])(string2 != null ? this.encoding.encode(string2) : null), (byte[])(string3 != null ? this.encoding.encode(string3) : null), (byte[])(string4 != null ? this.encoding.encode(string4) : null), Integer.toString(n3).getBytes(), Integer.toString(n4).getBytes(), Integer.toString(n5).getBytes(), (byte[])(n6 != null ? n6.toString().getBytes() : null), Integer.toString(n7).getBytes(), (byte[])(n8 != null ? n8.toString().getBytes() : null), (byte[])(string5 != null ? this.encoding.encode(string5) : null), (byte[])(n9 != null ? n9.toString().getBytes() : null), (byte[])(n10 != null ? n10.toString().getBytes() : null), Integer.toString(n11).getBytes(), (byte[])(n12 != null ? n12.toString().getBytes() : null), (byte[])(n13 != null ? n13.toString().getBytes() : null)};
        vector.addElement(byArrayArray);
    }

    public ResultSet getTypeInfo() throws SQLException {
        Field[] fieldArray = new Field[18];
        Vector vector = new Vector();
        fieldArray[0] = new Field(this.connection, "TYPE_NAME", 12, this.getMaxNameLength());
        fieldArray[1] = new Field(this.connection, "DATA_TYPE", 5, 2L);
        fieldArray[2] = new Field(this.connection, "PRECISION", 4, 4L);
        fieldArray[3] = new Field(this.connection, "LITERAL_PREFIX", 12, this.getMaxNameLength());
        fieldArray[4] = new Field(this.connection, "LITERAL_SUFFIX", 12, this.getMaxNameLength());
        fieldArray[5] = new Field(this.connection, "CREATE_PARAMS", 12, this.getMaxNameLength());
        fieldArray[6] = new Field(this.connection, "NULLABLE", 5, 2L);
        fieldArray[7] = new Field(this.connection, "CASE_SENSITIVE", -6, 1L);
        fieldArray[8] = new Field(this.connection, "SEARCHABLE", 5, 2L);
        fieldArray[9] = new Field(this.connection, "UNSIGNED_ATTRIBUTE", -6, 1L);
        fieldArray[10] = new Field(this.connection, "FIXED_PREC_SCALE", -6, 1L);
        fieldArray[11] = new Field(this.connection, "AUTO_INCREMENT", -6, 1L);
        fieldArray[12] = new Field(this.connection, "LOCAL_TYPE_NAME", 12, this.getMaxNameLength());
        fieldArray[13] = new Field(this.connection, "MINIMUM_SCALE", 5, 2L);
        fieldArray[14] = new Field(this.connection, "MAXIMUM_SCALE", 5, 2L);
        fieldArray[15] = new Field(this.connection, "SQL_DATA_TYPE", 4, 4L);
        fieldArray[16] = new Field(this.connection, "SQL_DATETIME_SUB", 4, 4L);
        fieldArray[17] = new Field(this.connection, "NUM_PREC_RADIX", 4, 4L);
        this.appendTypeInfo(vector, "VARCHAR", 12, Integer.MAX_VALUE, "'", "'", "length", 1, 1, 3, null, 0, null, "varchar", null, null, 12, null, null);
        this.appendTypeInfo(vector, "CHARACTER VARYING", 12, Integer.MAX_VALUE, "'", "'", "length", 1, 1, 3, null, 0, null, "character varying", null, null, 12, null, null);
        this.appendTypeInfo(vector, "DECIMAL", 3, 10, null, null, "precision,scale", 1, 0, 2, new Integer(0), 0, new Integer(0), "decimal", new Integer(0), new Integer(15), 3, null, new Integer(10));
        this.appendTypeInfo(vector, "NUMERIC", 2, 10, null, null, "precision,scale", 1, 0, 2, new Integer(0), 0, new Integer(0), "numeric", new Integer(0), new Integer(15), 2, null, new Integer(10));
        this.appendTypeInfo(vector, "INT", 4, 10, null, null, null, 1, 0, 2, new Integer(0), 0, new Integer(0), "int", new Integer(0), new Integer(15), 4, null, new Integer(10));
        this.appendTypeInfo(vector, "DECIMAL", 3, 15, null, null, null, 1, 0, 2, new Integer(0), 0, new Integer(0), "decimal", new Integer(0), new Integer(15), 3, null, new Integer(10));
        this.appendTypeInfo(vector, "DECIMAL", 6, 15, null, null, null, 1, 0, 2, new Integer(0), 0, new Integer(0), "decimal", new Integer(0), new Integer(15), 6, null, new Integer(10));
        this.appendTypeInfo(vector, "DECIMAL", 8, 15, null, null, null, 1, 0, 2, new Integer(0), 0, new Integer(0), "decimal", new Integer(0), new Integer(15), 8, null, new Integer(10));
        this.appendTypeInfo(vector, "BLOB", -4, Integer.MAX_VALUE, "X'", "'", null, 1, 0, 0, null, 0, null, "blob", null, null, -4, null, null);
        this.appendTypeInfo(vector, "VARBINARY", -4, Integer.MAX_VALUE, "X'", "'", null, 1, 0, 0, null, 0, null, "varbinary", null, null, -4, null, null);
        this.appendTypeInfo(vector, "LONGVARBINARY", -4, Integer.MAX_VALUE, "X'", "'", null, 1, 0, 0, null, 0, null, "longvarbinary", null, null, -4, null, null);
        this.appendTypeInfo(vector, "BINARY VARYING", -4, Integer.MAX_VALUE, "X'", "'", null, 1, 0, 0, null, 0, null, "binary varying", null, null, -4, null, null);
        this.appendTypeInfo(vector, "DATE", 91, 10, "{d '", "'}", null, 1, 0, 2, null, 0, null, "date", null, null, 91, new Integer(1), null);
        this.appendTypeInfo(vector, "TIME", 92, 8, "{t '", "'}", "length", 1, 0, 2, null, 0, null, "time", null, null, 91, new Integer(2), null);
        this.appendTypeInfo(vector, "TIMESTAMP", 93, 19, "{ts '", "'}", "length", 1, 0, 2, null, 0, null, "timestamp", new Integer(0), new Integer(0), 91, new Integer(3), null);
        return (ResultSet)((Object)((BaseStatement)((Object)this.connection.createStatement())).createResultSet(fieldArray, vector, "OK", 1, 0L, false));
    }

    public ResultSet getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException {
        Field[] fieldArray = new Field[13];
        Vector<byte[][]> vector = new Vector<byte[][]>();
        fieldArray[0] = new Field(this.connection, "TABLE_CAT", 12, this.getMaxNameLength());
        fieldArray[1] = new Field(this.connection, "TABLE_SCHEM", 12, this.getMaxNameLength());
        fieldArray[2] = new Field(this.connection, "TABLE_NAME", 12, this.getMaxNameLength());
        fieldArray[3] = new Field(this.connection, "NON_UNIQUE", -6, 1L);
        fieldArray[4] = new Field(this.connection, "INDEX_QUALIFIER", 12, this.getMaxNameLength());
        fieldArray[5] = new Field(this.connection, "INDEX_NAME", 12, this.getMaxNameLength());
        fieldArray[6] = new Field(this.connection, "TYPE", 5, 2L);
        fieldArray[7] = new Field(this.connection, "ORDINAL_POSITION", 5, 2L);
        fieldArray[8] = new Field(this.connection, "COLUMN_NAME", 12, this.getMaxNameLength());
        fieldArray[9] = new Field(this.connection, "ASC_OR_DESC", 12, this.getMaxNameLength());
        fieldArray[10] = new Field(this.connection, "CARDINALITY", 4, 4L);
        fieldArray[11] = new Field(this.connection, "PAGES", 4, 4L);
        fieldArray[12] = new Field(this.connection, "FILTER_CONDITION", 12, this.getMaxNameLength());
        ResultSet resultSet = ((CommonJ1Statement)((Object)this.connection.createStatement())).getIndexInfo(string3);
        int n = 1;
        while (resultSet.next()) {
            byte[][] byArrayArray = new byte[][]{null, null, resultSet.getBytes(1), Integer.toString(1).getBytes(), null, resultSet.getBytes(2), Integer.toString(3).getBytes(), Integer.toString(n).getBytes(), resultSet.getBytes(2), null, Integer.toString(1).getBytes(), Integer.toString(1).getBytes(), null};
            vector.addElement(byArrayArray);
            ++n;
        }
        resultSet.close();
        return (ResultSet)((Object)((BaseStatement)((Object)this.connection.createStatement())).createResultSet(fieldArray, vector, "OK", 1, 0L, false));
    }

    private static Vector tokenize(String string, String string2) {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        int n2 = string.length();
        int n3 = string2.length();
        while (n < n2) {
            int n4 = string.indexOf(string2, n);
            if (n4 < 0) {
                vector.addElement(string.substring(n));
                break;
            }
            String string3 = string.substring(n, n4);
            vector.addElement(string3);
            n = n4 + n3;
        }
        return vector;
    }
}

