/*
 * Decompiled with CFR 0.152.
 */
package com.filemaker.jdbc2;

import com.filemaker.jdbc.FMSQLException;
import com.filemaker.jdbc.Field;
import com.filemaker.jdbc1.CommonJ1ResultSetMetaData;
import java.sql.SQLException;
import java.util.Vector;

public abstract class CommonJ2ResultSetMetaData
extends CommonJ1ResultSetMetaData {
    public CommonJ2ResultSetMetaData(Vector vector, Field[] fieldArray) {
        super(vector, fieldArray);
    }

    public int getColumnCount() throws SQLException {
        return this.fields.length;
    }

    public boolean isAutoIncrement(int n) throws SQLException {
        return false;
    }

    public boolean isCaseSensitive(int n) throws SQLException {
        int n2 = this.getField(n).getSQLType();
        switch (n2) {
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 91: 
            case 92: 
            case 93: {
                return false;
            }
        }
        return true;
    }

    public boolean isSearchable(int n) throws SQLException {
        int n2 = this.getField(n).getSQLType();
        switch (n2) {
            case 1111: {
                return true;
            }
        }
        return true;
    }

    public boolean isCurrency(int n) throws SQLException {
        String string = this.getField(n).getFMType();
        return string.equals("cash") || string.equals("money");
    }

    public int isNullable(int n) throws SQLException {
        int n2 = this.getField(n).getMod();
        int n3 = n2 > 0 ? 0 : 1;
        return n3;
    }

    public boolean isSigned(int n) throws SQLException {
        int n2 = this.getField(n).getSQLType();
        switch (n2) {
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
            case 91: 
            case 92: 
            case 93: {
                return false;
            }
        }
        return false;
    }

    public int getColumnDisplaySize(int n) throws SQLException {
        Field field = this.getField(n);
        String string = field.getFMType();
        int n2 = field.getMod();
        if (string.equals("int")) {
            return 11;
        }
        if (string.equals("date")) {
            return 10;
        }
        if (string.equals("time")) {
            return 8;
        }
        if (string.equals("timestamp")) {
            return 22;
        }
        n2 -= 4;
        if (string.equals("varchar") || string.equals("character varying")) {
            return n2;
        }
        if (string.equals("numeric") || string.equals("decimal")) {
            return (n2 >> 16 & 0xFFFF) + 1 + (n2 & 0xFFFF);
        }
        return (int)field.getLength();
    }

    public String getColumnLabel(int n) throws SQLException {
        return this.getColumnName(n);
    }

    public String getColumnName(int n) throws SQLException {
        Field field = this.getField(n);
        if (field != null) {
            return field.getName();
        }
        return "field" + n;
    }

    public String getSchemaName(int n) throws SQLException {
        return "";
    }

    public int getPrecision(int n) throws SQLException {
        int n2 = this.getField(n).getSQLType();
        switch (n2) {
            case 5: {
                return 5;
            }
            case 4: {
                return 10;
            }
            case 7: {
                return 8;
            }
            case 6: {
                return 16;
            }
            case 8: {
                return 16;
            }
            case 12: {
                return 0;
            }
            case 2: {
                Field field = this.getField(n);
                if (field != null) {
                    return (0xFFFF0000 & field.getMod()) >> 16;
                }
                return 0;
            }
        }
        return 0;
    }

    public int getScale(int n) throws SQLException {
        int n2 = this.getField(n).getSQLType();
        switch (n2) {
            case 5: {
                return 0;
            }
            case 4: {
                return 0;
            }
            case 7: {
                return 8;
            }
            case 6: {
                return 16;
            }
            case 8: {
                return 16;
            }
            case 12: {
                return 0;
            }
            case 2: {
                Field field = this.getField(n);
                if (field != null) {
                    return (0xFFFF & field.getMod()) - 4;
                }
                return 0;
            }
        }
        return 0;
    }

    public String getTableName(int n) throws SQLException {
        return "";
    }

    public String getCatalogName(int n) throws SQLException {
        return "";
    }

    public int getColumnType(int n) throws SQLException {
        return this.getField(n).getSQLType();
    }

    public String getColumnTypeName(int n) throws SQLException {
        return this.getField(n).getFMType();
    }

    public boolean isReadOnly(int n) throws SQLException {
        return false;
    }

    public boolean isWritable(int n) throws SQLException {
        return !this.isReadOnly(n);
    }

    public boolean isDefinitelyWritable(int n) throws SQLException {
        return false;
    }

    private Field getField(int n) throws SQLException {
        if (n < 1 || n > this.fields.length) {
            throw new FMSQLException("The column index is out of range.", "22023");
        }
        return this.fields[n - 1];
    }

    public String getColumnClassName(int n) throws SQLException {
        Field field = this.getField(n);
        int n2 = field.getSQLType();
        switch (n2) {
            case -7: {
                return "java.lang.Boolean";
            }
            case 5: {
                return "java.lang.Short";
            }
            case 4: {
                return "java.lang.Integer";
            }
            case -5: {
                return "java.lang.Long";
            }
            case 2: {
                return "java.math.BigDecimal";
            }
            case 7: {
                return "java.lang.Float";
            }
            case 8: {
                return "java.lang.Double";
            }
            case 1: 
            case 12: {
                return "java.lang.String";
            }
            case 91: {
                return "java.sql.Date";
            }
            case 92: {
                return "java.sql.Time";
            }
            case 93: {
                return "java.sql.Timestamp";
            }
            case -3: 
            case -2: {
                return "[B";
            }
            case 2003: {
                return "java.sql.Array";
            }
        }
        String string = field.getFMType();
        if ("unknown".equals(string)) {
            return "java.lang.String";
        }
        return "java.lang.Object";
    }
}

