/*
 * Decompiled with CFR 0.152.
 */
package com.filemaker.jdbc2;

import com.filemaker.jdbc.BaseStatement;
import com.filemaker.jdbc.Driver;
import com.filemaker.jdbc.FMSQLException;
import com.filemaker.jdbc.Field;
import com.filemaker.jdbc1.CommonJ1ResultSet;
import com.filemaker.jdbc2.Array;
import com.filemaker.jdbc2.CommonJ2Statement;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class CommonJ2ResultSet
extends CommonJ1ResultSet {
    protected boolean updateable = false;
    protected boolean doingUpdates = false;
    protected boolean onInsertRow = false;
    protected Hashtable updateValues = new Hashtable();
    private Vector primaryKeys;
    private int numKeys = 0;
    private boolean singleTable = false;
    protected String tableName = null;
    protected PreparedStatement updateStatement = null;
    protected PreparedStatement insertStatement = null;
    protected PreparedStatement deleteStatement = null;
    private PreparedStatement selectStatement = null;

    public CommonJ2ResultSet(BaseStatement baseStatement, Field[] fieldArray, Vector vector, String string, int n, long l, boolean bl) {
        super(baseStatement, fieldArray, vector, string, n, l, bl);
    }

    public CommonJ2ResultSet(BaseStatement baseStatement, Field[] fieldArray, Vector vector, int n, int n2, int n3, int n4) throws SQLException {
        super(baseStatement, fieldArray, vector, n, n2, n3, n4);
    }

    public URL getURL(int n) throws SQLException {
        return null;
    }

    public URL getURL(String string) throws SQLException {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean absolute(int n) throws SQLException {
        int n2;
        if (this.rows == null) {
            throw new FMSQLException("Cursor has been closed.", "HY000");
        }
        if (n == 0) {
            return false;
        }
        int n3 = this.rows.size();
        if (n < 0) {
            if (n < -n3) {
                this.beforeFirst();
                return false;
            }
            n2 = n3 + n;
        } else {
            if (n > n3) {
                this.afterLast();
                return false;
            }
            n2 = n - 1;
        }
        this.current_row = n2;
        this.this_row = (byte[][])this.rows.elementAt(n2);
        this.rowBuffer = new byte[this.this_row.length][];
        System.arraycopy(this.this_row, 0, this.rowBuffer, 0, this.this_row.length);
        return true;
    }

    public void afterLast() throws SQLException {
        if (this.rows == null) {
            throw new FMSQLException("Cursor has been closed.", "HY000");
        }
        int n = this.rows.size();
        if (n > 0) {
            this.current_row = n;
        }
    }

    public void beforeFirst() throws SQLException {
        if (this.rows == null) {
            throw new FMSQLException("Cursor has been closed.", "HY000");
        }
        if (this.rows.size() > 0) {
            this.current_row = -1;
        }
    }

    public boolean first() throws SQLException {
        if (this.rows == null) {
            throw new FMSQLException("Cursor has been closed.", "HY000");
        }
        if (this.rows.size() <= 0) {
            return false;
        }
        this.onInsertRow = false;
        this.current_row = 0;
        this.this_row = (byte[][])this.rows.elementAt(this.current_row);
        this.rowBuffer = new byte[this.this_row.length][];
        System.arraycopy(this.this_row, 0, this.rowBuffer, 0, this.this_row.length);
        return true;
    }

    public java.sql.Array getArray(String string) throws SQLException {
        return this.getArray(this.findColumn(string));
    }

    public java.sql.Array getArray(int n) throws SQLException {
        this.checkResultSet(n);
        boolean bl = this.wasNullFlag = this.this_row[n - 1] == null;
        if (this.wasNullFlag) {
            return null;
        }
        if (n < 1 || n > this.fields.length) {
            throw new FMSQLException("The column index is out of range.", "22023");
        }
        return new Array(this.connection, n, this.fields[n - 1], this);
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        return this.getBigDecimal(n, -1);
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.findColumn(string));
    }

    public abstract Blob getBlob(int var1) throws SQLException;

    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumn(string));
    }

    public Reader getCharacterStream(int n) throws SQLException {
        this.checkResultSet(n);
        boolean bl = this.wasNullFlag = this.this_row[n - 1] == null;
        if (this.wasNullFlag) {
            return null;
        }
        return new CharArrayReader(this.getString(n).toCharArray());
    }

    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.findColumn(string));
    }

    public abstract Clob getClob(int var1) throws SQLException;

    public int getConcurrency() throws SQLException {
        if (this.statement == null) {
            return 1007;
        }
        return this.statement.getResultSetConcurrency();
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        return this.getDate(n);
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        return this.getTime(n);
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        return this.getTimestamp(n);
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(string), calendar);
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(string), calendar);
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    public Object getObject(String string, Map map) throws SQLException {
        return this.getObject(this.findColumn(string), map);
    }

    public Object getObject(int n, Map map) throws SQLException {
        throw Driver.notImplemented();
    }

    public Ref getRef(String string) throws SQLException {
        return this.getRef(this.findColumn(string));
    }

    public Ref getRef(int n) throws SQLException {
        throw new FMSQLException("FileMaker does not support REF types.");
    }

    public int getRow() throws SQLException {
        if (this.rows == null) {
            throw new FMSQLException("Cursor has been closed.", "HY000");
        }
        int n = this.rows.size();
        if (this.current_row < 0 || this.current_row >= n) {
            return 0;
        }
        return this.current_row + 1;
    }

    public Statement getStatement() throws SQLException {
        return (Statement)((Object)this.statement);
    }

    public int getType() throws SQLException {
        return 1004;
    }

    public boolean isAfterLast() throws SQLException {
        if (this.rows == null) {
            throw new FMSQLException("Cursor has been closed.", "HY000");
        }
        int n = this.rows.size();
        return this.current_row >= n && n > 0;
    }

    public boolean isBeforeFirst() throws SQLException {
        if (this.rows == null) {
            throw new FMSQLException("Cursor has been closed.", "HY000");
        }
        return this.current_row < 0 && this.rows.size() > 0;
    }

    public boolean isFirst() throws SQLException {
        if (this.rows == null) {
            throw new FMSQLException("Cursor has been closed.", "HY000");
        }
        return this.current_row == 0 && this.rows.size() >= 0;
    }

    public boolean isLast() throws SQLException {
        if (this.rows == null) {
            throw new FMSQLException("Cursor has been closed.", "HY000");
        }
        int n = this.rows.size();
        return this.current_row == n - 1 && n > 0;
    }

    public boolean last() throws SQLException {
        if (this.rows == null) {
            throw new FMSQLException("Cursor has been closed.", "HY000");
        }
        int n = this.rows.size();
        if (n <= 0) {
            return false;
        }
        this.current_row = n - 1;
        this.this_row = (byte[][])this.rows.elementAt(this.current_row);
        this.rowBuffer = new byte[this.this_row.length][];
        System.arraycopy(this.this_row, 0, this.rowBuffer, 0, this.this_row.length);
        return true;
    }

    public boolean previous() throws SQLException {
        if (this.rows == null) {
            throw new FMSQLException("Cursor has been closed.", "HY000");
        }
        if (this.current_row - 1 < 0) {
            this.current_row = -1;
            return false;
        }
        --this.current_row;
        this.this_row = (byte[][])this.rows.elementAt(this.current_row);
        this.rowBuffer = new byte[this.this_row.length][];
        System.arraycopy(this.this_row, 0, this.rowBuffer, 0, this.this_row.length);
        return true;
    }

    public boolean relative(int n) throws SQLException {
        return this.absolute(this.current_row + 1 + n);
    }

    public void setFetchDirection(int n) throws SQLException {
        throw new FMSQLException("FileMaker does not support this method");
    }

    public synchronized void cancelRowUpdates() throws SQLException {
        if (this.doingUpdates) {
            this.doingUpdates = false;
            this.clearRowBuffer(true);
        }
    }

    public synchronized void deleteRow() throws SQLException {
        if (!this.isUpdateable()) {
            throw new FMSQLException("Result set not updateable. The query that generated this result set must select only one table, and must select all primary keys from that table.");
        }
        if (this.onInsertRow) {
            throw new FMSQLException("Cannot call deleteRow() when on insert row.");
        }
        if (this.rows.size() == 0) {
            throw new FMSQLException("Cannot delete row on empty result set");
        }
        if (this.isBeforeFirst()) {
            throw new FMSQLException("Before start of result set. Cannot delete row.");
        }
        if (this.isAfterLast()) {
            throw new FMSQLException("After end of result set. Cannot delete row.");
        }
        int n = this.primaryKeys.size();
        if (this.deleteStatement == null) {
            StringBuffer stringBuffer = new StringBuffer("DELETE FROM ").append(this.tableName).append(" where ");
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(((PrimaryKey)this.primaryKeys.get((int)i)).name).append(" = ? ");
                if (i >= n - 1) continue;
                stringBuffer.append(" and ");
            }
            this.deleteStatement = ((Connection)((Object)this.connection)).prepareStatement(stringBuffer.toString());
        }
        this.deleteStatement.clearParameters();
        for (int i = 0; i < n; ++i) {
            this.deleteStatement.setObject(i + 1, ((PrimaryKey)this.primaryKeys.get(i)).getValue());
        }
        this.deleteStatement.executeUpdate();
        this.rows.removeElementAt(this.current_row);
    }

    public synchronized void insertRow() throws SQLException {
        if (!this.isUpdateable()) {
            throw new FMSQLException("Result set not updateable. The query that generated this result set must select only one table, and must select all primary keys from that table.");
        }
        if (!this.onInsertRow) {
            throw new FMSQLException("Not on insert row.");
        }
        StringBuffer stringBuffer = new StringBuffer("INSERT INTO ").append(this.tableName).append(" (");
        StringBuffer stringBuffer2 = new StringBuffer(") values (");
        Enumeration enumeration = this.updateValues.keys();
        int n = this.updateValues.size();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            stringBuffer.append(string);
            if (n2 < n - 1) {
                stringBuffer.append(", ");
                stringBuffer2.append("?,");
            } else {
                stringBuffer2.append("?)");
            }
            ++n2;
        }
        stringBuffer.append(stringBuffer2.toString());
        this.insertStatement = ((Connection)((Object)this.connection)).prepareStatement(stringBuffer.toString());
        Enumeration enumeration2 = this.updateValues.keys();
        int n3 = 1;
        while (enumeration2.hasMoreElements()) {
            String string = (String)enumeration2.nextElement();
            Object v = this.updateValues.get(string);
            if (v instanceof NullObject) {
                this.insertStatement.setNull(n3, 0);
            } else {
                this.insertStatement.setObject(n3, v);
            }
            ++n3;
        }
        this.insertStatement.executeUpdate();
        this.updateRowBuffer();
        this.rows.addElement(this.rowBuffer);
        this.this_row = this.rowBuffer;
        this.clearRowBuffer(false);
    }

    public synchronized void moveToCurrentRow() throws SQLException {
        if (!this.updateable) {
            throw new FMSQLException("Result set not updateable. The query that generated this result set must select only one table, and must select all primary keys from that table.");
        }
        if (this.current_row < 0) {
            this.this_row = null;
            this.rowBuffer = null;
        } else {
            this.this_row = (byte[][])this.rows.elementAt(this.current_row);
            this.rowBuffer = new byte[this.this_row.length][];
            System.arraycopy(this.this_row, 0, this.rowBuffer, 0, this.this_row.length);
        }
        this.onInsertRow = false;
        this.doingUpdates = false;
    }

    public synchronized void moveToInsertRow() throws SQLException {
        if (!this.isUpdateable()) {
            throw new FMSQLException("Result set not updateable. The query that generated this result set must select only one table, and must select all primary keys from that table.");
        }
        if (this.insertStatement != null) {
            this.insertStatement = null;
        }
        this.clearRowBuffer(false);
        this.onInsertRow = true;
        this.doingUpdates = false;
    }

    private synchronized void clearRowBuffer(boolean bl) throws SQLException {
        this.rowBuffer = new byte[this.fields.length][];
        if (bl) {
            System.arraycopy(this.this_row, 0, this.rowBuffer, 0, this.this_row.length);
        }
        this.updateValues.clear();
    }

    public boolean rowDeleted() throws SQLException {
        throw Driver.notImplemented();
    }

    public boolean rowInserted() throws SQLException {
        throw Driver.notImplemented();
    }

    public boolean rowUpdated() throws SQLException {
        throw Driver.notImplemented();
    }

    public synchronized void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        byte[] byArray = null;
        try {
            inputStream.read(byArray, 0, n2);
        }
        catch (NullPointerException nullPointerException) {
            throw new FMSQLException("Input stream is null.");
        }
        catch (IOException iOException) {
            throw new FMSQLException(iOException.getMessage());
        }
        this.updateValue(n, byArray);
        if (!this.onInsertRow) {
            this.this_row[n - 1] = byArray;
        }
        this.updateRowBuffer();
    }

    public synchronized void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.updateValue(n, bigDecimal);
    }

    public synchronized void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        byte[] byArray = null;
        try {
            inputStream.read(byArray, 0, n2);
        }
        catch (NullPointerException nullPointerException) {
            throw new FMSQLException("Input stream is null.");
        }
        catch (IOException iOException) {
            throw new FMSQLException(iOException.getMessage());
        }
        this.updateValue(n, byArray);
        if (!this.onInsertRow) {
            this.this_row[n - 1] = byArray;
        }
        this.updateRowBuffer();
    }

    public synchronized void updateBoolean(int n, boolean bl) throws SQLException {
        if (Driver.logDebug) {
            Driver.debug("updating boolean " + this.fields[n - 1].getName() + "=" + bl);
        }
        this.updateValue(n, new Boolean(bl));
        if (!this.onInsertRow) {
            this.this_row[n - 1] = Boolean.toString(bl).getBytes();
        }
        this.updateRowBuffer();
    }

    public synchronized void updateByte(int n, byte by) throws SQLException {
        this.updateValue(n, String.valueOf(by));
        if (!this.onInsertRow) {
            this.this_row[n - 1] = String.valueOf(by).getBytes();
        }
        this.updateRowBuffer();
    }

    public synchronized void updateBytes(int n, byte[] byArray) throws SQLException {
        this.updateValue(n, byArray);
        if (!this.onInsertRow) {
            this.this_row[n - 1] = byArray;
        }
        this.updateRowBuffer();
    }

    public synchronized void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        char[] cArray = null;
        try {
            reader.read(cArray, 0, n2);
        }
        catch (NullPointerException nullPointerException) {
            throw new FMSQLException("Input stream is null");
        }
        catch (IOException iOException) {
            throw new FMSQLException(iOException.getMessage());
        }
        this.updateValue(n, cArray);
    }

    public synchronized void updateDate(int n, Date date) throws SQLException {
        this.updateValue(n, date);
    }

    public synchronized void updateDouble(int n, double d) throws SQLException {
        if (Driver.logDebug) {
            Driver.debug("updating double " + this.fields[n - 1].getName() + "=" + d);
        }
        this.updateValue(n, new Double(d));
        if (!this.onInsertRow) {
            this.this_row[n - 1] = Double.toString(d).getBytes();
        }
        this.updateRowBuffer();
    }

    public synchronized void updateFloat(int n, float f) throws SQLException {
        if (Driver.logDebug) {
            Driver.debug("updating float " + this.fields[n - 1].getName() + "=" + f);
        }
        this.updateValue(n, new Float(f));
        if (!this.onInsertRow) {
            this.this_row[n - 1] = Float.toString(f).getBytes();
        }
        this.updateRowBuffer();
    }

    public synchronized void updateInt(int n, int n2) throws SQLException {
        if (Driver.logDebug) {
            Driver.debug("updating int " + this.fields[n - 1].getName() + "=" + n2);
        }
        this.updateValue(n, new Integer(n2));
        if (!this.onInsertRow) {
            this.this_row[n - 1] = Integer.toString(n2).getBytes();
        }
        this.updateRowBuffer();
    }

    public synchronized void updateLong(int n, long l) throws SQLException {
        if (Driver.logDebug) {
            Driver.debug("updating long " + this.fields[n - 1].getName() + "=" + l);
        }
        this.updateValue(n, new Long(l));
        if (!this.onInsertRow) {
            this.this_row[n - 1] = Long.toString(l).getBytes();
        }
        this.updateRowBuffer();
    }

    public synchronized void updateNull(int n) throws SQLException {
        this.updateValue(n, new NullObject());
        if (!this.onInsertRow) {
            this.this_row[n - 1] = null;
        }
        this.updateRowBuffer();
    }

    public synchronized void updateObject(int n, Object object) throws SQLException {
        if (Driver.logDebug) {
            Driver.debug("updating object " + this.fields[n - 1].getName() + " = " + object);
        }
        this.updateValue(n, object);
        if (!this.onInsertRow) {
            this.this_row[n - 1] = (byte[])object;
        }
        this.updateRowBuffer();
    }

    public synchronized void updateObject(int n, Object object, int n2) throws SQLException {
        if (!this.isUpdateable()) {
            throw new FMSQLException("Result set not updateable. The query that generated this result set must select only one table, and must select all primary keys from that table.");
        }
        this.updateObject(n, object);
        if (!this.onInsertRow) {
            this.this_row[n - 1] = (byte[])object;
        }
        this.updateRowBuffer();
    }

    public void refreshRow() throws SQLException {
        if (!this.isUpdateable()) {
            throw new FMSQLException("Result set not updateable. The query that generated this result set must select only one table, and must select all primary keys from that table.");
        }
        try {
            int n;
            int n2;
            StringBuffer stringBuffer = new StringBuffer("select ");
            int n3 = java.lang.reflect.Array.getLength(this.fields);
            for (n2 = 0; n2 < n3; ++n2) {
                stringBuffer.append(this.fields[n2].getName());
                if (n2 >= n3 - 1) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append(" from ").append(this.tableName).append(" where ");
            n2 = this.primaryKeys.size();
            for (n = 0; n < n2; ++n) {
                PrimaryKey primaryKey = (PrimaryKey)this.primaryKeys.get(n);
                stringBuffer.append(primaryKey.name).append("= ?");
                if (n >= n2 - 1) continue;
                stringBuffer.append(" and ");
            }
            if (Driver.logDebug) {
                Driver.debug("selecting " + stringBuffer.toString());
            }
            this.selectStatement = ((Connection)((Object)this.connection)).prepareStatement(stringBuffer.toString());
            n = 0;
            int n4 = 1;
            while (n < n2) {
                this.selectStatement.setObject(n4, ((PrimaryKey)this.primaryKeys.get(n)).getValue());
                ++n;
                ++n4;
            }
            CommonJ2ResultSet commonJ2ResultSet = (CommonJ2ResultSet)((Object)this.selectStatement.executeQuery());
            if (commonJ2ResultSet.first()) {
                this.rowBuffer = commonJ2ResultSet.rowBuffer;
            }
            this.rows.setElementAt(this.rowBuffer, this.current_row);
            this.this_row = this.rowBuffer;
            if (Driver.logDebug) {
                Driver.debug("done updates");
            }
            commonJ2ResultSet.close();
            this.selectStatement.close();
            this.selectStatement = null;
        }
        catch (Exception exception) {
            if (Driver.logDebug) {
                Driver.debug(exception.getClass().getName() + exception);
            }
            throw new FMSQLException(exception.getMessage());
        }
    }

    public synchronized void updateRow() throws SQLException {
        if (!this.isUpdateable()) {
            throw new FMSQLException("Result set not updateable. The query that generated this result set must select only one table, and must select all primary keys from that table.");
        }
        if (this.doingUpdates) {
            try {
                Object object;
                int n;
                StringBuffer stringBuffer = new StringBuffer("UPDATE " + this.tableName + " SET  ");
                int n2 = this.updateValues.size();
                Enumeration enumeration = this.updateValues.keys();
                int n3 = 0;
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    stringBuffer.append("\"");
                    stringBuffer.append(string);
                    stringBuffer.append("\" = ?");
                    if (n3 < n2 - 1) {
                        stringBuffer.append(", ");
                    }
                    ++n3;
                }
                stringBuffer.append(" WHERE ");
                n3 = this.primaryKeys.size();
                for (n = 0; n < n3; ++n) {
                    object = (PrimaryKey)this.primaryKeys.get(n);
                    stringBuffer.append("\"");
                    stringBuffer.append(((PrimaryKey)object).name);
                    stringBuffer.append("\" = ?");
                    if (n >= n3 - 1) continue;
                    stringBuffer.append(" and ");
                }
                if (Driver.logDebug) {
                    Driver.debug("updating " + stringBuffer.toString());
                }
                this.updateStatement = ((Connection)((Object)this.connection)).prepareStatement(stringBuffer.toString());
                n = 0;
                object = this.updateValues.values().iterator();
                while (object.hasNext()) {
                    Object e = object.next();
                    if (e instanceof NullObject) {
                        this.updateStatement.setNull(n + 1, 0);
                    } else {
                        this.updateStatement.setObject(n + 1, e);
                    }
                    ++n;
                }
                int n4 = 0;
                while (n4 < n3) {
                    this.updateStatement.setObject(n + 1, ((PrimaryKey)this.primaryKeys.get(n4)).getValue());
                    ++n4;
                    ++n;
                }
                this.updateStatement.executeUpdate();
                this.updateStatement.close();
                this.updateStatement = null;
                this.updateRowBuffer();
                if (Driver.logDebug) {
                    Driver.debug("copying data");
                }
                System.arraycopy(this.rowBuffer, 0, this.this_row, 0, this.rowBuffer.length);
                this.rows.setElementAt(this.rowBuffer, this.current_row);
                if (Driver.logDebug) {
                    Driver.debug("done updates");
                }
                this.updateValues.clear();
                this.doingUpdates = false;
            }
            catch (Exception exception) {
                if (Driver.logDebug) {
                    Driver.debug(exception.getClass().getName() + exception);
                }
                throw new FMSQLException(exception.getMessage());
            }
        }
    }

    public synchronized void updateShort(int n, short s) throws SQLException {
        if (Driver.logDebug) {
            Driver.debug("in update Short " + this.fields[n - 1].getName() + " = " + s);
        }
        this.updateValue(n, new Short(s));
        if (!this.onInsertRow) {
            this.this_row[n - 1] = Short.toString(s).getBytes();
        }
        this.updateRowBuffer();
    }

    public synchronized void updateString(int n, String string) throws SQLException {
        if (Driver.logDebug) {
            Driver.debug("in update String " + this.fields[n - 1].getName() + " = " + string);
        }
        this.updateValue(n, string);
        if (!this.onInsertRow) {
            this.this_row[n - 1] = string.getBytes();
        }
        this.updateRowBuffer();
    }

    public synchronized void updateTime(int n, Time time) throws SQLException {
        if (Driver.logDebug) {
            Driver.debug("in update Time " + this.fields[n - 1].getName() + " = " + time);
        }
        this.updateValue(n, time);
    }

    public synchronized void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        if (Driver.logDebug) {
            Driver.debug("updating Timestamp " + this.fields[n - 1].getName() + " = " + timestamp);
        }
        this.updateValue(n, timestamp);
    }

    public synchronized void updateNull(String string) throws SQLException {
        this.updateNull(this.findColumn(string));
    }

    public synchronized void updateBoolean(String string, boolean bl) throws SQLException {
        this.updateBoolean(this.findColumn(string), bl);
    }

    public synchronized void updateByte(String string, byte by) throws SQLException {
        this.updateByte(this.findColumn(string), by);
    }

    public synchronized void updateShort(String string, short s) throws SQLException {
        this.updateShort(this.findColumn(string), s);
    }

    public synchronized void updateInt(String string, int n) throws SQLException {
        this.updateInt(this.findColumn(string), n);
    }

    public synchronized void updateLong(String string, long l) throws SQLException {
        this.updateLong(this.findColumn(string), l);
    }

    public synchronized void updateFloat(String string, float f) throws SQLException {
        this.updateFloat(this.findColumn(string), f);
    }

    public synchronized void updateDouble(String string, double d) throws SQLException {
        this.updateDouble(this.findColumn(string), d);
    }

    public synchronized void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    public synchronized void updateString(String string, String string2) throws SQLException {
        this.updateString(this.findColumn(string), string2);
    }

    public synchronized void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.findColumn(string), byArray);
    }

    public synchronized void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.findColumn(string), date);
    }

    public synchronized void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.findColumn(string), time);
    }

    public synchronized void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    public synchronized void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream, n);
    }

    public synchronized void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream, n);
    }

    public synchronized void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader, n);
    }

    public synchronized void updateObject(String string, Object object, int n) throws SQLException {
        this.updateObject(this.findColumn(string), object);
    }

    public synchronized void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.findColumn(string), object);
    }

    protected void checkResultSet(int n) throws SQLException {
        super.checkResultSet(n);
        if (this.isBeforeFirst() || this.isAfterLast()) {
            throw new FMSQLException("Invalid operation for the current cursor position.", "22023");
        }
    }

    boolean isUpdateable() throws SQLException {
        if (this.updateable) {
            return true;
        }
        if (Driver.logDebug) {
            Driver.debug("checking if rs is updateable");
        }
        this.parseQuery();
        if (!this.singleTable) {
            if (Driver.logDebug) {
                Driver.debug("not a single table");
            }
            return false;
        }
        if (Driver.logDebug) {
            Driver.debug("getting primary keys");
        }
        this.primaryKeys = new Vector();
        int n = 0;
        String[] stringArray = CommonJ2ResultSet.quotelessTableName(this.tableName);
        String string = stringArray[0];
        String string2 = stringArray[1];
        ResultSet resultSet = ((Connection)((Object)this.connection)).getMetaData().getPrimaryKeys("", string2, string);
        while (resultSet.next()) {
            String string3 = resultSet.getString(4);
            int n2 = this.findColumn(string3);
            if (n2 > 0) {
                this.primaryKeys.add(new PrimaryKey(n2, string3));
            }
            ++n;
        }
        resultSet.close();
        this.numKeys = this.primaryKeys.size();
        if (Driver.logDebug) {
            Driver.debug("no of keys=" + n);
        }
        if (n < 1) {
            throw new FMSQLException("No primary keys");
        }
        boolean bl = this.updateable = this.primaryKeys.size() > 0;
        if (Driver.logDebug) {
            Driver.debug("checking primary key " + this.updateable);
        }
        return this.updateable;
    }

    public static String[] quotelessTableName(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        String[] stringArray = new String[]{null, ""};
        StringBuffer stringBuffer2 = new StringBuffer();
        boolean bl = false;
        block4: for (int i = 0; i < stringBuffer.length(); ++i) {
            char c = stringBuffer.charAt(i);
            switch (c) {
                case '\"': {
                    if (i < stringBuffer.length() - 1 && stringBuffer.charAt(i + 1) == '\"') {
                        ++i;
                        stringBuffer2.append(c);
                        continue block4;
                    }
                    bl = !bl;
                    continue block4;
                }
                case '.': {
                    if (bl) {
                        stringBuffer2.append(c);
                        continue block4;
                    }
                    stringArray[1] = stringBuffer2.toString();
                    stringBuffer2 = new StringBuffer();
                    continue block4;
                }
                default: {
                    stringBuffer2.append(bl ? c : Character.toLowerCase(c));
                }
            }
        }
        stringArray[0] = stringBuffer2.toString();
        return stringArray;
    }

    public void parseQuery() {
        String[] stringArray = ((CommonJ2Statement)this.statement).getSqlFragments();
        String string = stringArray[0];
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \r\t\n");
        boolean bl = false;
        boolean bl2 = false;
        String string2 = "";
        this.singleTable = true;
        while (!bl && !bl2 && stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (!bl) {
                if (!string2.toLowerCase().equals("from")) continue;
                this.tableName = stringTokenizer.nextToken();
                bl = true;
                continue;
            }
            bl2 = true;
            this.singleTable = !string2.equalsIgnoreCase(",");
        }
    }

    private void updateRowBuffer() throws SQLException {
        Enumeration enumeration = this.updateValues.keys();
        block4: while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            int n = this.findColumn(string) - 1;
            Object v = this.updateValues.get(string);
            if (v instanceof NullObject) {
                this.rowBuffer[n] = null;
                continue;
            }
            switch (this.connection.getSQLType(this.fields[n].getFMType())) {
                case -7: 
                case -6: 
                case -5: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 12: 
                case 91: 
                case 92: 
                case 93: {
                    this.rowBuffer[n] = this.connection.getEncoding().encode(String.valueOf(v));
                }
                case 0: {
                    continue block4;
                }
            }
            this.rowBuffer[n] = (byte[])v;
        }
    }

    public void setStatement(BaseStatement baseStatement) {
        this.statement = baseStatement;
    }

    protected void updateValue(int n, Object object) throws SQLException {
        if (!this.isUpdateable()) {
            throw new FMSQLException("Result set not updateable. The query that generated this result set must select only one table, and must select all primary keys from that table.");
        }
        boolean bl = this.doingUpdates = !this.onInsertRow;
        if (object == null) {
            this.updateNull(n);
        } else {
            this.updateValues.put(this.fields[n - 1].getName(), object);
        }
    }

    class NullObject {
        NullObject() {
        }
    }

    private class PrimaryKey {
        int index;
        String name;

        PrimaryKey(int n, String string) {
            this.index = n;
            this.name = string;
        }

        Object getValue() throws SQLException {
            return CommonJ2ResultSet.this.getObject(this.index);
        }
    }
}

