/*
 * Decompiled with CFR 0.152.
 */
package com.filemaker.jdbc;

import com.filemaker.jdbc.FMStream;
import com.filemaker.jdbc.MessageBlock;
import com.filemaker.jdbc.ProtocolMessage;
import java.io.UnsupportedEncodingException;

public class FMQueryRequest
extends ProtocolMessage {
    private static final short CMD_FM_QUERY_REQUEST = 113;
    private int parameterCount;
    private String sql;
    private long maxLength;

    public FMQueryRequest(String string, long l) {
        super((short)113);
        this.parameterCount = 0;
        this.sql = string;
        this.maxLength = l;
        this.addParameter16(this.parameterCount);
    }

    public FMQueryRequest(byte[] byArray) {
        super(byArray);
    }

    short addParameterValue(int n, short s, short s2, long l, byte[] byArray) {
        this.addParameter16(n);
        this.addParameter8(s);
        this.addParameter8(s2);
        this.addParameter64(l);
        this.addParameter(byArray);
        ++this.parameterCount;
        return 0;
    }

    short addParameterValue(int n, short s, short s2, long l, String string) {
        this.addParameter16(n);
        this.addParameter8(s);
        this.addParameter8(s2);
        try {
            this.addParameter64(string.getBytes("UTF-8").length);
            this.addParameter(string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        ++this.parameterCount;
        return 0;
    }

    public boolean extract() {
        this.parameterCount = this.getParameter16();
        this.sql = this.getParameter();
        this.maxLength = this.getParameter64();
        this.extracted = true;
        return true;
    }

    public String getSql() {
        if (!this.extracted) {
            this.extract();
        }
        return this.sql;
    }

    public long getMaxLength() {
        if (!this.extracted) {
            this.extract();
        }
        return this.maxLength;
    }

    public boolean send(FMStream fMStream) {
        MessageBlock messageBlock = (MessageBlock)this.messageBlocks.get(0);
        messageBlock.setItemCount(5, this.parameterCount);
        this.addParameter(this.sql);
        this.addParameter64(this.maxLength);
        return super.send(fMStream);
    }
}

