function [handles] = ScreenAnalysis(handles)

tic
%Generate General Variables for screen
handles = GatherVar(handles);

assignin('base', 'Var_start', handles)

for i = 1:handles.File.NumberOfScreen
    handles.Analysis.CurrentScreen = i;
    handles = LoadSavedMeasurements(handles);
end
assignin('base', 'Var_load', handles)

for i = 1:handles.File.NumberOfScreen
    if handles.Plate.LoadedMeas{i} == 0;
        handles.Analysis.CurrentScreen = i;
        handles.Analysis.CurrentPlate = 0;
        %Read Image in the data folder
        FileName = fullfile(handles.File.DataFolder{i},handles.File.SelectedFile{i});
        Img = imread(FileName, 'tif');
        %Check Previously saved Grid files
        [handles] = CheckSavedGrid(handles);
        if handles.Plate.SavedGrid == 0
            %Place grid on picture manualy
            handles.Plate.ManualPosition = 1;
            handles = PlaceGrid(Img, handles);
        end
    end
end




for i = 1:handles.File.NumberOfScreen
    if handles.Plate.LoadedMeas{i} == 0;
        handles.Analysis.CurrentScreen = i;
        for j = 1:handles.File.NumberOfPlates{i}
            handles.Analysis.CurrentPlate = j;
            %Display message on UI
            DisplayStr = ['Alignment: ', handles.File.FileRoot{i}, ' Current Plate: ' num2str(j), ' / ' num2str(handles.File.NumberOfPlates{i}) ];
            set(handles.OutText,'String',DisplayStr)
            drawnow
            %Read Image in the data folder
            FileName = fullfile(handles.File.DataFolder{i},handles.File.FileName{i}(j).name);
            Img = imread(FileName, 'tif');
            if handles.Plate.SavedGrid == 0;
                %Position plate image with reference to the first plate
                handles.Plate.ManualPosition = 0;
                [handles] = AutoPositionPlates(Img, handles);
            end

            %Place grid on picture
            handles = PlaceGrid(Img, handles);
            %assignin('base', 'Var_1', Var)

        end
    end
end
fprintf('\n')
toc
assignin('base', 'Var_grid', handles)


%Measure each image
for i = 1:handles.File.NumberOfScreen
    if handles.Plate.LoadedMeas{i} == 0;
        handles.Analysis.CurrentScreen = i;
        for j = 1:handles.File.NumberOfPlates{i}
            handles.Analysis.CurrentPlate = j;
            %Display message on UI
            DisplayStr = ['Measurement: ', handles.File.FileRoot{i}, ' Current Plate: ' num2str(j), ' / ' num2str(handles.File.NumberOfPlates{i}) ];
            set(handles.OutText,'String',DisplayStr)
            drawnow
            %Read Image in the data folder
            FileName = fullfile(handles.File.DataFolder{i},handles.File.FileName{i}(j).name);
            Img = imread(FileName, 'tif');
            %measure Intensity of each spot
            [handles] = MeasurePlate_SpotSize(Img, handles);
            if handles.Analysis.Type ~= 1 && rem(i,2) == 0
                [handles] = CalculateDiff(handles);
            end
        end
        %Save measurements to text file

        handles = SaveMeasurements(handles);
    end
end

assignin('base', 'Var_Meas', handles)
%Calculations between screens
if ~(isfield(handles.Analysis, 'DiffCalculated') && handles.Analysis.DiffCalculated == handles.Analysis.Type)
if handles.Analysis.Type ~= 1
    for i = 2:2:handles.File.NumberOfScreen
        
            handles.Analysis.CurrentScreen = i;
            for j = 1:handles.File.NumberOfPlates{i}
                handles.Analysis.CurrentPlate = j;
                [handles] = CalculateDiff(handles);
            end
        
    end
end
end
assignin('base', 'Var_Calc', handles)

%Calculate screen average if not already done
%if handles.Display.PlateDisplay == 0 | ~isfield(handles.Analysis, 'AverageMeasured')
    [handles] = ScreenAverage(handles);
%end
fprintf('\n')

assignin('base', 'Var_Avg', handles)

%Display data
if handles.Display.PlateDisplay == 0
    %Display all the plates and save to file
    for j = 1:handles.File.NumberOfPlates{1}
        handles.Analysis.CurrentPlate = j;
        [handles] = CompareScreen(handles);
    end

    DisplayStr = ['Finished Analysis of: '];
    for i = 1:handles.File.NumberOfScreen
        DisplayStr = [DisplayStr, handles.File.FileRoot{i}, '  ' ];
    end
    set(handles.OutText,'String',DisplayStr)
    drawnow
    toc

else
    
    handles.Analysis.CurrentPlate = handles.Display.PlateNum;
    [handles] = CompareScreen(handles);


    DisplayStr = ['Displayed Plate: '];
    DisplayStr = [DisplayStr, num2str(handles.Display.PlateNum) ];
    set(handles.OutText,'String',DisplayStr)
    drawnow
end

% if handles.Analysis.BuildHitList
%     handles = BuildHitList(handles);
% end

assignin('base', 'Var_end', handles)