function Var = PlaceGrid(Img, Var)


if Var.Plate.SavedGrid == 1;
    %Display image
    figure(1); imshow(Img); colormap(gray)
    TitleStr = [Var.File.FileRoot{Var.Analysis.CurrentScreen}, ': Plate #', num2str(Var.File.PlateNumber(Var.Analysis.CurrentScreen,Var.Analysis.CurrentPlate))];
    title(TitleStr)
    hold on

    %load Grid file
    cd(Var.File.ResultFolder{Var.Analysis.CurrentScreen})
    SavedGridName = ['Grid_', Var.File.FileName{Var.Analysis.CurrentScreen}(Var.Analysis.CurrentPlate).name(1:end-4) '.mat'];
    load(SavedGridName)
    cd(Var.File.CodeFolder)
    %Transfer grid info to variables
    DX = GridSpecs.Space(1);
    DY = GridSpecs.Space(2);
    Orig = GridSpecs.Origin;
    HLines = GridSpecs.HLines;
    VLines = GridSpecs.VLines;
else
    if Var.Plate.ManualPosition == 1
        %display image
        figure(1)
        imshow(Img); colormap(gray)
        title('Select Top Left spot of four corner strains')
        %Select the four High concentration spots in the corners of the image
        %to place the grid
        [BW,xi,yi] = roipoly;

        %Calculate the spacing of the grid in X and Y direction
        DX = (xi(2) -xi(1) + xi(3) -xi(4))/(Var.Plate.Spot(1)-Var.Plate.Strain(1))/2;
        DY = (yi(4) -yi(1) + yi(3) -yi(2))/(Var.Plate.Spot(2)-Var.Plate.Strain(1))/2;
        %Calculates the position of the Top-Left spot of the grid
        Orig = [(xi(1)+xi(4)-DX)/2,(yi(1) + yi(2)-DY)/2];
        hold on
        plot(Orig(1), Orig(2), 'og')
        %define the position of the Horizontal and vertical lines
        L = [0:1:Var.Plate.Spot(2)];
        HLines = round(Orig(2)+L*DY);
        V = [0:1:Var.Plate.Spot(1)];
        VLines = round(Orig(1)+V*DX);

    else
        %If Grid values have been measure for first image and Autoposition ran
        %successfully
        figure(1)
        imshow(Img); colormap(gray);
        TitleStr = [Var.File.FileRoot{Var.Analysis.CurrentScreen}, ': Plate #', num2str(Var.File.PlateNumber(Var.Analysis.CurrentScreen,Var.Analysis.CurrentPlate))];
        title(TitleStr)
        hold on
        DX = Var.Plate.RefSpace{Var.Analysis.CurrentScreen}(1);
        DY = Var.Plate.RefSpace{Var.Analysis.CurrentScreen}(2);
        Orig = Var.Plate.RefOrigin{Var.Analysis.CurrentScreen};
        HLines = Var.Plate.RefHLines{Var.Analysis.CurrentScreen};
        VLines = Var.Plate.RefVLines{Var.Analysis.CurrentScreen};
        XOffset = Var.Plate.RefImgCoordinate{Var.Analysis.CurrentScreen}(3) - Var.Analysis.Offset(1);
        YOffset = Var.Plate.RefImgCoordinate{Var.Analysis.CurrentScreen}(1) - Var.Analysis.Offset(2);
        HLines = HLines - YOffset;
        VLines = VLines - XOffset;
    end
end

%Display the grid on the image
XPos(1) = VLines(1);
XPos(2) = VLines(end);
for i = 1:Var.Plate.Spot(2)+1
    YPos(1:2) = HLines(i);
    if mod(i+1,Var.Plate.Strain(2)) == 0;
        color = 'r';
        Lwidth = 2;
    else
        color = 'b';
        Lwidth = 1;
    end
    plot(XPos, YPos, color, 'LineWidth',Lwidth)
end

YPos(1) = HLines(1);
YPos(2) = HLines(end);
for i = 1:Var.Plate.Spot(1)+1
    XPos(1:2) = VLines(i);
    if mod(i+1,Var.Plate.Strain(1)) == 0;
        color = 'r';
        Lwidth = 2;
    else
        color = 'b';
        Lwidth = 1;
    end
    plot(XPos, YPos, color, 'LineWidth',Lwidth)
end
hold off
pause(0.2)




if Var.Analysis.CurrentPlate == 0
%     title('Select Upper and Lower edge of Plate')
%     [BW,xi,yi] = roipoly;
%     LowEdge = round(min(yi));
%     UpperEdge = round(max(yi));

    LowEdge = round(max([HLines(1)-1*DY, DY*1]));
    UpperEdge = round(min([HLines(end)+1*DY, size(Img,1)-DY*1]));
    
    %NormImg = 1-double((Img-min(min(Img)))./(max(max(Img))-min(min(Img))));
    
    Img = double(Img);
    NormImg = (Img-min(Img(:)))./(max(Img(:))-min(Img(:)));
    Var.Plate.RefImg{Var.Analysis.CurrentScreen} = NormImg(LowEdge:UpperEdge,round(DX*1):end-round(DX*1));  %(round(DY*1):end-round(DY*1),round(DX*1):end-round(DX*1));
    Var.Plate.RefImgCoordinate{Var.Analysis.CurrentScreen} = [LowEdge, UpperEdge, round(DX*1), size(Img,2)-round(DX*1)];
    %Transfer the grid info to the Var structure
    Var.Plate.RefSpace{Var.Analysis.CurrentScreen} = [DX,DY];
    Var.Plate.RefOrigin{Var.Analysis.CurrentScreen} = Orig;
    Var.Plate.RefHLines{Var.Analysis.CurrentScreen} = HLines;
    Var.Plate.RefVLines{Var.Analysis.CurrentScreen} = VLines;
else
    %Transfer the grid info to the Var structure
    Var.Plate.Space{Var.Analysis.CurrentScreen, Var.Analysis.CurrentPlate} = [DX,DY];
    Var.Plate.Origin{Var.Analysis.CurrentScreen, Var.Analysis.CurrentPlate} = Orig;
    Var.Plate.HLines{Var.Analysis.CurrentScreen, Var.Analysis.CurrentPlate} = HLines;
    Var.Plate.VLines{Var.Analysis.CurrentScreen, Var.Analysis.CurrentPlate} = VLines;

    %Save the grid specifications to a mat file
    GridSpecs.Space = [DX,DY];
    GridSpecs.Origin = Orig;
    GridSpecs.HLines = HLines;
    GridSpecs.VLines = VLines;
    SaveGridName = ['Grid_', Var.File.FileName{Var.Analysis.CurrentScreen}(Var.Analysis.CurrentPlate).name(1:end-4) '.mat'];
    cd(Var.File.ResultFolder{Var.Analysis.CurrentScreen})
    save(SaveGridName,  'GridSpecs');
    cd(Var.File.CodeFolder)
end


