function [Var] = MeasurePlate_SpotSize(Img, Var)

Debug = 0;


%Transfer grid info to smaller variables
HLines = Var.Plate.HLines{Var.Analysis.CurrentScreen, Var.Analysis.CurrentPlate};
VLines = Var.Plate.VLines{Var.Analysis.CurrentScreen, Var.Analysis.CurrentPlate};
Border = round(mean(Var.Plate.Space{Var.Analysis.CurrentScreen, Var.Analysis.CurrentPlate}(1:2))*Var.Analysis.BorderPercent);


%Invert Image
MaxInt = 2^Var.File.Bit;
InvertImg = double(MaxInt-Img);


SpotImg = zeros(size(Img));
BackgroundImg = zeros(size(Img));
m = 0;
for j = 1:Var.Plate.Spot(1)
    for i = 1:Var.Plate.Spot(2)
        m = m+1;
        if strcmp(Var.Analysis.SegmentationType, 'Edge')
        %Select region of original image that contain the spot
         CutImg = InvertImg(HLines(i)-Border:HLines(i+1)+Border,VLines(j)-Border:VLines(j+1)+Border);
        %Find edge around spot
       	 [EdgeImg, Threshold] = edge(CutImg, 'sobel');       %sobel or canny
        elseif strcmp(Var.Analysis.SegmentationType, 'Intensity')
         %Select region of original image that contain the spot
        CutImg = Img(HLines(i)-Border:HLines(i+1)+Border,VLines(j)-Border:VLines(j+1)+Border);
        %Find threshold and apply on the image
        Threshold = graythresh(CutImg);
        EdgeImg = im2bw(CutImg, Threshold*1.01);
        end
      
        %Grow edge by one pixel
        
        SE = strel('disk',Var.Analysis.GrowSpot);
        EdgeDilateImg = imdilate(EdgeImg,SE);
        %Fill Image
        FillImg = imfill(EdgeDilateImg,8, 'holes');
        %Clear objects that touch borders
        FillImg = imclearborder(FillImg);

        FillImg = imerode(FillImg,SE);

        [LabelImg, NumSpot] = bwlabel(FillImg);
        LabelProps = regionprops(LabelImg, CutImg,'Area','ConvexArea','ConvexImage','BoundingBox',...
            'Centroid', 'PixelList', 'PixelIdxList', 'MeanIntensity','MinIntensity');
        if Debug == 1 
            figure(102)
             subplot(2,2,1); imagesc(CutImg); title('CutImg');
           
            subplot(2,2,3); imagesc(EdgeImg); title('EdgeImg');
            subplot(2,2,2); imagesc(FillImg); title('FillImg');
            %pause(0.1)
        end
        
        if NumSpot == 0
            
            
        
            %Grow edge by one pixel
        SE = strel('disk',Var.Analysis.GrowSpot);
        EdgeDilateImg = imdilate(EdgeImg,SE);
        %Fill Image
        FillImg = imfill(EdgeDilateImg, 'holes');
        %Clear objects that touch borders
        FillImg = imclearborder(FillImg);

        FillImg = imerode(FillImg,SE);

        [LabelImg, NumSpot] = bwlabel(FillImg);
        LabelProps = regionprops(LabelImg,CutImg, 'Area','ConvexArea','ConvexImage','BoundingBox',...
            'Centroid', 'PixelList', 'PixelIdxList', 'MeanIntensity','MinIntensity');
%         subplot(2,2,3); imagesc(FillImg); title('FillImg lower thresh');
%         pause(2)
%         
        end
        
       
            
%                             figure(102)
%              subplot(2,2,1); imagesc(CutImg); title('CutImg');
%  subplot(2,2,2); imagesc(EdgeImg); title('EdgeImg');
%              subplot(2,2,3); imagesc(FillImg); title('FillImg');
        %Find oordinate of box center
        BoxCenter = [round((HLines(i+1)-HLines(i))/2+Border),round((VLines(i+1)-VLines(i))/2+Border)];
        CentralSpot = [];
        Dist2Center = [];
        %If there is more than one spot
        if NumSpot > 1 
            SelectSpot = 'Center';        %Center (Select more central spot) or Intensity (Select spot with highest intensity)
            if strcmp(SelectSpot, 'Center') 
            for k = 1:NumSpot
                %Check if center pixel belongs to one of the object
                CenterIN = ismember(LabelProps(k).PixelList, BoxCenter, 'rows');
                if max(CenterIN) == 1
                    %If yes set this object as valid one
                    CentralSpot = k;
                end
                %Calculate distance to center
                Dist2Center(k) = sqrt((BoxCenter(1)-LabelProps(k).Centroid(1))^2+(BoxCenter(2)-LabelProps(k).Centroid(2))^2);
            end
            %If central spot found
            if ~isempty(CentralSpot)
                %Set fill Img to the convex image of objcet found in center
                FillImg(:,:) = 0;                
               FillImg(LabelProps(CentralSpot).PixelIdxList) = 1;
                [LabelImg, NumSpot] = bwlabel(FillImg);
                LabelProps = regionprops(LabelImg,'Area','ConvexArea','ConvexImage','BoundingBox', 'Centroid', 'PixelList', 'PixelIdxList');
                SegmentationOK = 1;
            else
                %If no pixel of object overlap with center of box take the
                %one which is the closest
                [Min, Close2Center] = min(Dist2Center);
                FillImg(:,:) = 0;
                FillImg(LabelProps(Close2Center).PixelIdxList) = 1;
                [LabelImg, NumSpot] = bwlabel(FillImg);
                LabelProps = regionprops(LabelImg,'Area','ConvexArea','ConvexImage','BoundingBox', 'Centroid', 'PixelList', 'PixelIdxList');
                SegmentationOK = 1;

            end
            elseif strcmp(SelectSpot, 'Intensity')
                MinInt = [];
                for k = 1:NumSpot
                    MinInt(k) = LabelProps(k).MeanIntensity;
                end
                [Min, MinIntSpot] = min(MinInt);
                FillImg(:,:) = 0;
                FillImg(LabelProps(MinIntSpot).PixelIdxList) = 1;
                [LabelImg, NumSpot] = bwlabel(FillImg);
                LabelProps = regionprops(LabelImg,'Area','ConvexArea','ConvexImage','BoundingBox', 'Centroid', 'PixelList', 'PixelIdxList');
                SegmentationOK = 1;
                
            end
                
        end
 
           % if LabelProps(k).ConvexArea > LabelProps(k).Area*4/3
           if NumSpot == 1 
                [ConvY, ConvX] = find(LabelProps(1).ConvexImage == 1);

                ConvInd = sub2ind(size(FillImg),ConvY + floor(LabelProps(1).BoundingBox(2)),ConvX + floor(LabelProps(1).BoundingBox(1)));
                FillImg(ConvInd) = 1;

          end
     

        %Set the spot image to one for all spots
        [SpotY, SpotX] = find(FillImg == 1);
        SpotInd = sub2ind(size(Img),SpotY + HLines(i)-Border-1,SpotX + VLines(j)-Border-1);

        SpotImg(SpotInd) = SpotImg(SpotInd)+1;
        %Create CutSpot Img identical to Fill image
        CutSpotImg = FillImg;
        if Debug == 1
        subplot(2,2,4); imagesc(FillImg); title('FillImg single');
       pause(0.1)
        end
%         

        %         %Extend size of spot to calculate Background
        %         SE = strel('disk',Var.Analysis.BackgroungRingSize);
        %         FillImg = imdilate(FillImg,SE);
        %         %Set Spot pixels to 2 and background pixels to 1
        %         [SpotY, SpotX] = find(FillImg == 1);
        %         SpotInd = sub2ind(size(Img),SpotY + HLines(i)-Border,SpotX + VLines(j)-Border);
        %         SpotImg(SpotInd) = SpotImg(SpotInd)+1;
        %
        %         %Set CutSpot Img to 2 for the spot and the background ring to one
        %         CutSpotImg = CutSpotImg +FillImg;
        %         %Find spot pixels and background pixels
        %         SpotIndCutImg = find(CutSpotImg == 2);
        %         BkgIndCutImg = find(CutSpotImg == 1);
        %         %Calculate average background and subtract it from CutImg
        %         AvgBkg(m) = mean(CutImg(BkgIndCutImg));
        %         CutImg = CutImg - AvgBkg(m);

        %Calculate the intensity of the spot
        Sum(m) = length(SpotInd);
        STD(m) = sqrt(length(SpotInd));

    end
end

%Display segmentation image on Plate picture
%InvertImgNorm = (InvertImg-min(min(InvertImg)))./(max(max(InvertImg))-min(min(InvertImg)));
ThreshLevel = 0.0001;
SortInt = sort(InvertImg(:));
LowInt = SortInt(ceil(ThreshLevel*length(SortInt)));
HiInt = SortInt(round((1-ThreshLevel)*length(SortInt)));
InvertImgNorm = (InvertImg - LowInt)./(HiInt-LowInt);
InvertImgNorm(InvertImgNorm >1) = 1;
InvertImgNorm(InvertImgNorm <0) = 0;
InvertImgNorm= 1-InvertImgNorm;
%InvertImgNorm = InvertImgNorm./mean(InvertImgNorm(:)).*0.5;

% ThreshLevel = 0.0001;
% Img = double(Img);
% SortInt = sort(Img(:));
% LowInt = SortInt(ceil(ThreshLevel*length(SortInt)));
% HiInt = SortInt(round((1-ThreshLevel)*length(SortInt)));
% InvertImgNorm = (Img - LowInt)./(HiInt-LowInt);
% InvertImgNorm(InvertImgNorm >1) = 1;
% InvertImgNorm(InvertImgNorm <0) = 0;
% InvertImgNorm = InvertImgNorm./mean(InvertImgNorm(:)).*0.5;

InvertImgNormSpot = InvertImgNorm;
InvertImgNormSpot(SpotImg>0) = 1;
RGBImg(:,:,1) = InvertImgNormSpot;
RGBImg(:,:,2) = InvertImgNorm;
RGBImg(:,:,3) = InvertImgNorm;


figure(100)
image(RGBImg);
TitleStr = [Var.File.FileRoot{Var.Analysis.CurrentScreen}, ': Plate #', num2str(Var.File.PlateNumber(Var.Analysis.CurrentScreen,Var.Analysis.CurrentPlate))];
title(TitleStr)
set(gca,'XTick',[]);
set(gca,'YTick',[]);
hold on
%Display the grid on the image
XPos(1) = VLines(1);
XPos(2) = VLines(end);
for i = 1:Var.Plate.Spot(2)+1
    YPos(1:2) = HLines(i);
    if mod(i+1,Var.Plate.Strain(2)) == 0;
        color = 'g';
        Lwidth = 1;
    else
        color = 'b';
        Lwidth = 0.5;
    end
    
    plot(XPos, YPos, color, 'LineWidth',Lwidth)
end
YPos(1) = HLines(1);
YPos(2) = HLines(end);
for i = 1:Var.Plate.Spot(1)+1
    XPos(1:2) = VLines(i);
    if mod(i+1,Var.Plate.Strain(1)) == 0;
        color = 'g';
        Lwidth = 1;
    else
        color = 'b';
        Lwidth = 0.5;
    end
    plot(XPos, YPos, color, 'LineWidth',Lwidth)
end
hold off


%Save Segmentation image

FileName = ['Segment_',Var.File.FileRoot{Var.Analysis.CurrentScreen}, '_', num2str(Var.File.PlateNumber(Var.Analysis.CurrentScreen,Var.Analysis.CurrentPlate)), '.png'];

FigStr = ['-f', num2str(100)];
cd(Var.File.ResultFolder{Var.Analysis.CurrentScreen})
print(FigStr, '-dpng',FileName); %,'-r1200'
cd(Var.File.CodeFolder)




%Distribute resuts according to strain placement on plate
Var.Measurement{Var.Analysis.CurrentScreen,Var.File.PlateNumber(Var.Analysis.CurrentScreen, Var.Analysis.CurrentPlate)}.Sum = Plate2Lines(Sum, Var);
