%function ORF = ConvertDatabase(File)
File = '/Users/serge/Documents/Projects/Programms/Seb_Screen/Ingrid/IngridDatabase.txt';
%open file
fid = fopen(File);
%Search through begining of file until it reaches a cell which is a number
%=> marks the begining of the data
NotString = 0;
while NotString == 0
    [Test] = textscan(fid, '%s',1, 'delimiter', '\t');
   % T = char(Test{1})
    if ~isempty(str2num(char(Test{1})))
        NotString = 1;
    end
end
%reset the cursor to the position before the read number
fseek(fid, -4, 'cof');

% [Test] = textscan(fid, '%s',1, 'delimiter', '\t');
% T = char(Test{1})
% return
%Read through database
[Database] = textscan(fid, '%s%s%s%s%s%s%s%s%s%s', 'delimiter', '\t');
%Database is a cell array. the first column of the cell contains the plate
%number, the second, the line number the third the column number and the
%sixth the ORF name

%Finds the number of plates
NbPlates = max(str2num(char(Database{1,1}))) - min(str2num(char(Database{1,1})))+1;
%finds the number of lines
NbLines = max(str2num(char(Database{1,2}(:))));
%Finds the number of columns
NbColones = max(str2num(char(Database{1,3}(:))));
%find the number of ORF
NbORF = size(Database{1,6},1);
NbEntry = size(Database{1,1},1);

   


Var.Plate.StrainDisposition = [NbColones, NbLines];

%Generate a new cell containing all the ORF
ORF{1} = str2num(char(Database{1,1}(:)));
ORF{2} = str2num(char(Database{1,2}(:)));%max(char(Database{1,2}(:)),[],2) - max(char(Database{1,2}(1)))+1;
ORF{3} = str2num(char(Database{1,3}(:)));
ORF{4} = char(Database{1,6}(:));

%Make sure number of ORF in the variable is the same as the number of plate
%indexes regisatered
if NbORF < NbEntry
    for i = NbORF+1:NbEntry
        ORF{6}(i,:) = ' ';
    end
end





%% Screen Disposition
SLines = 8;
SColumn = 12;
LineFact = NbLines/ SLines;
ColFact = NbColones/ SColumn;
SPlates = NbPlates*LineFact*ColFact;


%% Convert Database order into Screen order
List_1D_Data = [1:NbEntry];
List_2D_Data = reshape(List_1D_Data, NbColones, NbLines,NbPlates);

ScPlateList =[];
for P = 1:NbPlates

    for F = 1:ColFact*LineFact
        SingleMat =zeros(2,2);
        SingleMat(F) = 1;
        FullMat = repmat(SingleMat, SColumn,SLines);
        SelectMat = FullMat.*squeeze(List_2D_Data(:,:,P));
        SpotNum = find(SelectMat);        
        ScPlateList = [ScPlateList;SelectMat(SpotNum) ];
    end
end


%% Creat screen matrix with corrected plate column and line numbering
%create empty matrix
ScreenMat = zeros(NbEntry, 4);
%loop through each entry of the matrix
iter = 0;
for P = 1:SPlates
    for L = 1:SLines
        for C = 1:SColumn
            iter = iter + 1;
            ScreenMat(iter,1) = P;
            ScreenMat(iter,2) = L;
            ScreenMat(iter,3) = C;
            ScreenMat(iter,4) = ScPlateList(iter);
        end
    end
end

%% Write to text
OutFile = [File(1:end-4), '_CONV.txt'];
fid = fopen(OutFile, 'w');


iter = 0;
fprintf(fid, 'Plate\tRow\tCol\t \tORF\tOrig Plate\tOrig Row\tOrig Col');

fprintf(fid, '\n');
for L = 1:NbEntry
    fprintf(fid, ['%d\t%d\t%d\t \t',ORF{4}(ScreenMat(L,4),:), '\t%d\t%d\t%d'],ScreenMat(L,1), ScreenMat(L,2), ScreenMat(L,3), ORF{1}(ScreenMat(L,4)), ORF{2}(ScreenMat(L,4)), ORF{3}(ScreenMat(L,4)));
   %fprintf(fid, ['\t%d\t%d\t%d\t \t\t%d\t%d\t%d'],ScreenMat(L,1), ScreenMat(L,2), ScreenMat(L,3), ORF{1}(ScreenMat(L,4)), ORF{2}(ScreenMat(L,4)), ORF{3}(ScreenMat(L,4)));
    %fprintf(fid, ['\t%d\t%d\t%d\t \t'],ScreenMat(L,1), ScreenMat(L,2), ScreenMat(L,3));
    fprintf(fid, '\n');
end


        
