function varargout = ScreenInterface(varargin)
% SCREENINTERFACE M-file for ScreenInterface.fig
%      SCREENINTERFACE, by itself, creates a new SCREENINTERFACE or raises the existing
%      singleton*.
%
%      H = SCREENINTERFACE returns the handle to a new SCREENINTERFACE or the handle to
%      the existing singleton*.
%
%      SCREENINTERFACE('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in SCREENINTERFACE.M with the given input arguments.
%
%      SCREENINTERFACE('Property','Value',...) creates a new SCREENINTERFACE or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before ScreenInterface_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to ScreenInterface_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help ScreenInterface

% Last Modified by GUIDE v2.5 10-May-2012 10:29:49

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
    'gui_Singleton',  gui_Singleton, ...
    'gui_OpeningFcn', @ScreenInterface_OpeningFcn, ...
    'gui_OutputFcn',  @ScreenInterface_OutputFcn, ...
    'gui_LayoutFcn',  [] , ...
    'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before ScreenInterface is made visible.
function ScreenInterface_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to ScreenInterface (see VARARGIN)

% Choose default command line output for ScreenInterface
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes ScreenInterface wait for user response (see UIRESUME)
% uiwait(handles.figure1);


%Add Code Folder to path
handles.File.CodeFolder = cd;
disp(handles.File.CodeFolder)
addpath(handles.File.CodeFolder)

% Update handles structure
guidata(hObject, handles);

% --- Outputs from this function are returned to the command line.
function varargout = ScreenInterface_OutputFcn(hObject, eventdata, handles)
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;

%
%       Add Screen Button
%
% --- Executes on button press in AddScreen.
function AddScreen_Callback(hObject, eventdata, handles)
% hObject    handle to AddScreen (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
%Update number of screen


if isfield(handles.File, 'NumberOfScreen')
    handles.File.NumberOfScreen = handles.File.NumberOfScreen + 1;
else
    handles.File.NumberOfScreen = 1;
end
NbScreen = handles.File.NumberOfScreen;

%File Selection
DialogTitle = ['Select One image from screen ', num2str(NbScreen)];
[FileName,PathName] = uigetfile('*.tif', DialogTitle);
handles.File.DataFolder{NbScreen} = PathName;
handles.File.SelectedFile{NbScreen} = FileName;


%Define File root name given by folder where the screen pictures are
%located
PathStr = fileparts(PathName);
Dashes = strfind(PathStr, filesep);
handles.File.FileRoot{NbScreen} = PathStr(Dashes(end)+1:end);

%Find files in the specified directory
ImgStr = '*.tif';
cd(handles.File.DataFolder{NbScreen})
files = dir(ImgStr);
handles.File.NumberOfPlates{NbScreen} = length(files);
if handles.File.NumberOfPlates{NbScreen} == 0
    ErrorStr = ['No Tif File found in Directory'];
    error(ErrorStr)
end

%Extract Plate number for each screen
handles.File.FileName{NbScreen} = files;
for j = 1:handles.File.NumberOfPlates{1}
    for i = 1:handles.File.NumberOfScreen
        FileName = handles.File.FileName{i}(j).name;
        Point = strfind(FileName, '.');
        handles.File.PlateNumber(i,j) = str2num(FileName(1:Point-1));
    end
    % check if the plate number for the screen are the same
    if std(handles.File.PlateNumber(:,j)) ~= 0
        ErrorStr = ['Plate Number from files do not match between screens'];
        error(ErrorStr)
    end
end

%Create Result folder
try
    %Create Result Folder based on the Root names of the different screens.
    ResultFolder = 'Results';
    ResultFolder = [ResultFolder, '_', handles.File.FileRoot{NbScreen}];
    %Result folder created in the data folder of the fist screen
    handles.File.ResultFolder{NbScreen} = fullfile(handles.File.DataFolder{NbScreen}, ResultFolder);
    mkdir(handles.File.ResultFolder{NbScreen})
catch
    %If Data directory is read only, Select a new folder to save Results
    [FileName,SelectedResultFolder] = uiputfile('*.*','Select Folder to save Results', 'Results_Data_will_Be_Saved_Here');
    handles.File.ResultFolder{NbScreen} = SelectedResultFolder;
end

%update screenlist to display Root name for screens
set(handles.ScreenList,'String',handles.File.FileRoot)

%update threshlist to set threshold of screen as default to zero
ThreshList = get(handles.ThreshList,'String');
if NbScreen == 1
    clear ThreshList
    ThreshList{NbScreen} = '0 / 0';
else
    ThreshList{NbScreen} = '0 / 0';
end
set(handles.ThreshList,'String',ThreshList);
handles.File.ResultFolder{NbScreen}
%Define handle.ThreshList as (0,0)  (default) for current screen
handles.File.ThreshList(NbScreen,1:2) = 0;

% Update handles structure
guidata(hObject, handles);

%Go back to code folder
cd(handles.File.CodeFolder)

% --- Executes on selection change in ScreenList.
function ScreenList_Callback(hObject, eventdata, handles)
% hObject    handle to ScreenList (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns ScreenList contents as cell array
%        contents{get(hObject,'Value')} returns selected item from ScreenList

% --- Executes during object creation, after setting all properties.
function ScreenList_CreateFcn(hObject, eventdata, handles)
% hObject    handle to ScreenList (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: listbox controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Xspot_Callback(hObject, eventdata, handles)
% hObject    handle to Xspot (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Xspot as text
%        str2double(get(hObject,'String')) returns contents of Xspot as a double

%Get Value from Edit Box
Edit1Str = get(handles.Xspot,'String');
handles.Plate.Strain(1) = str2num(Edit1Str);
% Update handles structure
guidata(hObject, handles);



% --- Executes during object creation, after setting all properties.
function Xspot_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Xspot (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% %Get Value from Edit Box
% Edit1Str = get(handles.Xspot,'String');
% handles.Plate.Strain(1) = str2num(Edit1Str);
% % Update handles structure
% guidata(hObject, handles);



function Yspot_Callback(hObject, eventdata, handles)
% hObject    handle to Yspot (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Yspot as text
%        str2double(get(hObject,'String')) returns contents of Yspot as a double

%Get Value from Edit Box
Edit2Str = get(handles.Yspot,'String');
handles.Plate.Strain(2) = str2num(Edit2Str);
% Update handles structure
guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function Yspot_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Yspot (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% %Get Value from Edit Box
% Edit2Str = get(handles.Yspot,'String');
% handles.Plate.Strain(2) = str2num(Edit2Str);
% % Update handles structure
% guidata(hObject, handles);



function DatabasePath_Callback(hObject, eventdata, handles)
% hObject    handle to DatabasePath (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of DatabasePath as text
%        str2double(get(hObject,'String')) returns contents of DatabasePath as a double


% --- Executes during object creation, after setting all properties.
function DatabasePath_CreateFcn(hObject, eventdata, handles)
% hObject    handle to DatabasePath (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% %update databasepath to displayFilepath of Datbase
% handles.File.Datbase = get(handles.DatabasePath,'String')
%
% % Update handles structure
% guidata(hObject, handles);

% --- Executes on button press in SelectDatabase.
function SelectDatabase_Callback(hObject, eventdata, handles)
% hObject    handle to SelectDatabase (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

%File Selection
DialogTitle = ['Select Database'];
[FileName,PathName] = uigetfile('*.txt', DialogTitle);

if FileName ~= 0

    handles.File.Database = fullfile(PathName, FileName);


    %update databasepath to displayFilepath of Datbase
    set(handles.DatabasePath,'String',FileName)

    %Load database from text file
    handles = ReadDatabase(handles);
end

% Update handles structure
guidata(hObject, handles);


% --- Executes on button press in StartScreen.
function StartScreen_Callback(hObject, eventdata, handles)
% hObject    handle to StartScreen (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
cd(handles.File.CodeFolder)
handles.Display.PlateDisplay = 0;
save('handles.mat', 'handles')
%Check if Screen have been selected
if isfield(handles.File, 'NumberOfScreen')
    [handles] = ScreenAnalysis(handles);
else
    ErrorStr = ['No Screen Defined'];
    errordlg(ErrorStr)
end



% --- Executes on button press in DeleteScreen.
function DeleteScreen_Callback(hObject, eventdata, handles)
% hObject    handle to DeleteScreen (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

%update screenlist to display Empty screen list
ScreenStr{1} = 'Screen Selected';
set(handles.ScreenList,'String',ScreenStr);
ThreshList{1} = ' / ';
set(handles.ThreshList,'String',ThreshList);

%remove Fields from handles
handles.File = rmfield(handles.File, 'NumberOfScreen');
handles.File = rmfield(handles.File, 'DataFolder');
handles.File = rmfield(handles.File, 'SelectedFile');
handles.File = rmfield(handles.File, 'FileRoot');
handles.File = rmfield(handles.File, 'FileName');
handles.File = rmfield(handles.File, 'NumberOfPlates');
handles.File = rmfield(handles.File, 'PlateNumber');
handles.File = rmfield(handles.File, 'ResultFolder');
handles.File = rmfield(handles.File, 'ThreshList');

% Update handles structure
guidata(hObject, handles);


% --- Executes on selection change in ORFList.
function ORFList_Callback(hObject, eventdata, handles)
% hObject    handle to ORFList (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns ORFList contents as cell array
%        contents{get(hObject,'Value')} returns selected item from ORFList


% --- Executes during object creation, after setting all properties.
function ORFList_CreateFcn(hObject, eventdata, handles)
% hObject    handle to ORFList (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: listbox controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in AddORF.
function AddORF_Callback(hObject, eventdata, handles)
% hObject    handle to AddORF (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
if isfield(handles.File, 'Database')
    QuestionStr = 'Provide Reference ORF';
    TitleStr = 'ORF Input';
    DefaultAns{1} = ['YALxxxC, YJLxxxW'];
    OrfDialog = inputdlg(QuestionStr,TitleStr,1,DefaultAns);
    if ~isempty(OrfDialog)

        OrfDialog = char(OrfDialog{1});
        Yfind = strfind(OrfDialog, 'Y');
        NbOrfInput = length(Yfind);

        if isfield(handles.File, 'NumberOfOrf')
            handles.File.NumberOfOrf = handles.File.NumberOfOrf + NbOrfInput;
        else
            handles.File.NumberOfOrf = NbOrfInput;
        end
        NbOrf = handles.File.NumberOfOrf;

        Yfind(NbOrfInput+1) = length(OrfDialog)+1;
        iter = 0;
        %Database list has to be converted to cell array for searching
        OrfList = cellstr(handles.Plate.ORF{1,4});
        for i = NbOrf-NbOrfInput+1:NbOrf
            iter = iter+1;
            RawOrf = OrfDialog(Yfind(iter):Yfind(iter+1)-1);
            while( strcmp(RawOrf(end), ' ')| strcmp(RawOrf(end), ',') );
                RawOrf = RawOrf(1:end-1);
            end
            handles.File.ReferenceOrf{i} = RawOrf;

            %Search database list for ORF
            OrfIndice = find(strcmp(OrfList, handles.File.ReferenceOrf{i}) == 1);
            while isempty(OrfIndice)
                QuestionStr = ['ORF ', handles.File.ReferenceOrf{i}, ' Not found in database\nPlease correct the input'];
                TitleStr = 'ORF Input';
                DefaultAns{1} = handles.File.ReferenceOrf{i};
                CorrOrfDialog = inputdlg(QuestionStr,TitleStr,1,DefaultAns);
                handles.File.ReferenceOrf{i} = char(CorrOrfDialog{1});
                OrfIndice = find(strcmp(OrfList, handles.File.ReferenceOrf{i}) == 1);

            end
            handles.File.ReferenceOrfPosition(i,1) = handles.Plate.ORF{1,1}(OrfIndice);
            handles.File.ReferenceOrfPosition(i,2) = handles.Plate.ORF{1,2}(OrfIndice);
            handles.File.ReferenceOrfPosition(i,3) = handles.Plate.ORF{1,3}(OrfIndice);
        end

        %update screenlist to display Root name for screens
        set(handles.ORFList,'String',handles.File.ReferenceOrf)

        % Update handles structure
        guidata(hObject, handles);
        assignin('base','Var_ORFI',handles);
    end
else
    TitleStr = 'ORF Input';
    WarnStr = 'Please specify the database before entering the ORFs';
    h = warndlg(WarnStr,TitleStr);
end


% --- Executes on button press in DeleteORF.
function DeleteORF_Callback(hObject, eventdata, handles)
% hObject    handle to DeleteORF (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

%update orflist to display Empty screen list
OrfStr{1} = 'Orf Selected';
set(handles.ORFList,'String',OrfStr);

%remove Fields from handles
handles.File = rmfield(handles.File, 'ReferenceOrf');
handles.File = rmfield(handles.File, 'NumberOfOrf');
handles.File = rmfield(handles.File, 'ReferenceOrfPosition');

assignin('base','Var_DelORF',handles);

% Update handles structure
guidata(hObject, handles);


% --- Executes on selection change in ThreshList.
function ThreshList_Callback(hObject, eventdata, handles)
% hObject    handle to ThreshList (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns ThreshList contents as cell array
%        contents{get(hObject,'Value')} returns selected item from ThreshList


% --- Executes during object creation, after setting all properties.
function ThreshList_CreateFcn(hObject, eventdata, handles)
% hObject    handle to ThreshList (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: listbox controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in SetThreshold.
function SetThreshold_Callback(hObject, eventdata, handles)
% hObject    handle to SetThreshold (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

%Checks if a screen has been defined
if isfield(handles.File, 'NumberOfScreen')
    %Find which Screen threshold has been selected
    SelectedThresh = get(handles.ThreshList,'Value');
    %Finds the screen name associated with the threshold
    LinkedScreen = handles.File.FileRoot{SelectedThresh};
    %Dialog to provide threshold
    QuestionStr = ['Provide Threshold for ORF in Screen ', LinkedScreen];
    TitleStr = 'Threshold Input';
    DefaultAns{1} = ['0.95 / 1.1'];
    ThreshDialog = inputdlg(QuestionStr,TitleStr,1,DefaultAns);
    ThreshDialog = char(ThreshDialog{1});
    %Find dash in dialog out put to get numbers saved to handles
    Dash = strfind(ThreshDialog, '/');
    handles.File.ThreshList(SelectedThresh,1) = str2num(ThreshDialog(1:Dash-1));
    handles.File.ThreshList(SelectedThresh,2) = str2num(ThreshDialog(Dash+1:end));

    %Update Listbox values
    ThreshList = get(handles.ThreshList,'String');
    ThreshList{SelectedThresh} = ThreshDialog;
    set(handles.ThreshList,'String',ThreshList);

    guidata(hObject, handles);
    assignin('base','Var_Tresh',handles);

else
    TitleStr = 'Threshold Input';
    WarnStr = 'Please specify the Screen before entering the threshold';
    h = warndlg(WarnStr,TitleStr);
end


% --- Executes on button press in UseORFList.
function UseORFList_Callback(hObject, eventdata, handles)
% hObject    handle to UseORFList (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of UseORFList

%% Plate Display Routine

% --- Executes on button press in PlateDisplay.
function PlateDisplay_Callback(hObject, eventdata, handles)
% hObject    handle to PlateDisplay (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

handles.Display.PlateDisplay = 1;
%Start Screen Analysis
if isfield(handles.File, 'NumberOfScreen')
    [handles] = ScreenAnalysis(handles);
else
    ErrorStr = ['No Screen Defined'];
    errordlg(ErrorStr)
end
% Update handles structure
guidata(hObject, handles);

function PlateNumber_Callback(hObject, eventdata, handles)
% hObject    handle to PlateNumber (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

handles.Display.PlateNum = str2double(get(hObject,'String'));
guidata(hObject, handles);
if handles.Display.PlateDisplay == 1
    [handles] = ScreenAnalysis(handles);
end
guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function PlateNumber_CreateFcn(hObject, eventdata, handles)
% hObject    handle to PlateNumber (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
handles.Display.PlateNum = 1;

set(hObject,'String', '1');
guidata(hObject, handles);


% --- Executes on button press in MinPlateNum.
function MinPlateNum_Callback(hObject, eventdata, handles)
% hObject    handle to MinPlateNum (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
if handles.Display.PlateNum > 1
    handles.Display.PlateNum = handles.Display.PlateNum - 1;
    set(handles.PlateNumber, 'String', num2str(handles.Display.PlateNum))
end
% Update handles structure
guidata(hObject, handles);
%Run Display on Callback
if handles.Display.PlateDisplay == 1
    [handles] = ScreenAnalysis(handles);
end
guidata(hObject, handles);

% --- Executes on button press in PlusPlateNum.
function PlusPlateNum_Callback(hObject, eventdata, handles)
% hObject    handle to PlusPlateNum (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
if isfield(handles, 'File') && isfield(handles.File, 'NumberOfPlates')
    if handles.Display.PlateNum < handles.File.NumberOfPlates{1}
        handles.Display.PlateNum = handles.Display.PlateNum + 1;
        set(handles.PlateNumber, 'String', num2str(handles.Display.PlateNum))
    end
end
% Update handles structure
guidata(hObject, handles);
%Run Display on Callback
if handles.Display.PlateDisplay == 1
    [handles] = ScreenAnalysis(handles);
end
guidata(hObject, handles);

function ORFDisp_Callback(hObject, eventdata, handles)
% hObject    handle to ORFDisp (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of ORFDisp as text
%        str2double(get(hObject,'String')) returns contents of ORFDisp as a
%        double
handles.Display.ORFDisplayName = get(hObject,'String');

%Find ORF position in screen
%Database list has to be converted to cell array for searching
OrfList = cellstr(handles.Plate.ORF{1,4});
OrfIndice = find(strcmp(OrfList, handles.Display.ORFDisplayName) == 1);
if isempty(OrfIndice)
    set(handles.OutText, 'String', [handles.Display.ORFDisplayName '  Not Found in Database']);
elseif length(OrfIndice) == 1
    handles.Display.PlateNum = handles.Plate.ORF{1,1}(OrfIndice);
    set(handles.PlateNumber, 'String', num2str(handles.Display.PlateNum))
    handles.Display.ORFDisplayRow = handles.Plate.ORF{1,2}(OrfIndice);
    handles.Display.ORFDisplayCol = handles.Plate.ORF{1,3}(OrfIndice);
    set(handles.OutText, 'String', ['Display ' handles.Display.ORFDisplayName ' on Plate # ', num2str(handles.Display.PlateNum)]);
else
    handles.Display.PlateNum = handles.Plate.ORF{1,1}(OrfIndice(1));
    set(handles.PlateNumber, 'String', num2str(handles.Display.PlateNum))
    handles.Display.ORFDisplayRow = handles.Plate.ORF{1,2}(OrfIndice(1));
    handles.Display.ORFDisplayCol = handles.Plate.ORF{1,3}(OrfIndice(1));
    set(handles.OutText, 'String', [num2str(length(OrfIndice)),' occurances found in Database! Display ' handles.Display.ORFDisplayName ' on Plate # ', num2str(handles.Display.PlateNum)]);
end
guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function ORFDisp_CreateFcn(hObject, eventdata, handles)
% hObject    handle to ORFDisp (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

handles.Display.ORFDisplayName = 'ORF';
guidata(hObject, handles);

%% --- Executes on selection change in DataAnalysis.
function DataAnalysis_Callback(hObject, eventdata, handles)
% hObject    handle to DataAnalysis (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

%Get Data Analysis Type
%1 is Growthrate from spot size
%2 is Difference in spot size between first and second screen
%3 is ratio in spot size between first and second screen

handles.Analysis.Type = get(hObject,'Value');
% Update handles structure
guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function DataAnalysis_CreateFcn(hObject, eventdata, handles)
% hObject    handle to DataAnalysis (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

handles.Analysis.Type = get(hObject,'Value');
% Update handles structure
guidata(hObject, handles);


% --- Executes on button press in HitList.
function HitList_Callback(hObject, eventdata, handles)
% hObject    handle to HitList (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

handles.Analysis.BuildHitList = get(hObject,'Value');
handles.Analysis.NumberHits = 100;
handles.Analysis.ColoniesWeight = [1,1,1,1];
% Update handles structure
guidata(hObject, handles);

% --- Executes on button press in HitListPrefs.
function HitListPrefs_Callback(hObject, eventdata, handles)
% hObject    handle to HitListPrefs (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

%create a dialog to obtain preferences for the hitlist generation
DlgPrompt = {'Number of Hits:','Weight of Spottings:'};
DlgTitle = 'Hit List preferences';
if isfield(handles.Analysis, 'NumberHits')
    DlgDef = {num2str(handles.Analysis.NumberHits), num2str(handles.Analysis.ColoniesWeight)};
else
    DlgDef = {'100','1, 1, 1, 1'};
end
DlgAnswer = inputdlg(DlgPrompt,DlgTitle,1,DlgDef);

handles.Analysis.NumberHits = str2num(DlgAnswer{1});
handles.Analysis.ColoniesWeight = str2num(DlgAnswer{2});

% Update handles structure
guidata(hObject, handles);
