function Var = SaveMeasurements(Var);

assignin('base','Var_Meas',Var);

MeasFile = fullfile(Var.File.ResultFolder{Var.Analysis.CurrentScreen}, ['Meas_', Var.File.FileRoot{Var.Analysis.CurrentScreen},'.txt'])
Var.File.MeasurementFile{Var.Analysis.CurrentScreen} = MeasFile;
fid = fopen(MeasFile, 'w');

NbStrain = Var.Plate.Spot(1)*Var.Plate.Spot(2)/Var.Plate.Dilution;
NbSpot = Var.Plate.Dilution;
NbPlate = Var.File.NumberOfPlates{Var.Analysis.CurrentScreen};

iter = 0;
fprintf(fid, 'ORF\tPlate\tRow\tCol');
for k = 1:Var.Plate.Dilution
    fprintf(fid, '\tSpot %d',k);
end
fprintf(fid, '\n');
for i = 1:NbPlate
    for j = 1:NbStrain
        iter = iter+1;
        fprintf(fid, [Var.Plate.ORF{4}(iter,:), '\t%d\t%d\t%d'],Var.Plate.ORF{1}(iter), Var.Plate.ORF{2}(iter), Var.Plate.ORF{3}(iter));
        for k = 1:Var.Plate.Dilution
            fprintf(fid, '\t%3f',Var.Measurement{Var.Analysis.CurrentScreen,i}.Sum(j,k));
        end
        fprintf(fid, '\n');
    end
end