function Var = ReadDatabase(Var)

%open file
fid = fopen(Var.File.Database);
%Search through begining of file until it reaches a cell which is a number
%=> marks the begining of the data
NotString = 0;
iter = 1;
while NotString == 0 %&& iter <5
    [Test] = textscan(fid, '%s',1, 'delimiter', '\t');
    %C_T = char(Test{1})
    if ~isempty(str2num(char(Test{1})))
        NotString = 1;
    else
        NotString = 0;
        ColumnHead{iter} = char(Test{1});
        iter = iter+1;
    end
end
%reset the cursor to the position before the read number
fseek(fid, -2, 'cof');
%Read through database
[Database] = textscan(fid, '%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s', 'delimiter', '\t');
%assignin('base', 'Database', Database)

%Database is a cell array. the first column of the cell contains the plate
%number, the second, the line lettre or number, the third the column number and the
%fifth the ORF name

%Finds the number of plates
NbPlates = max(str2num(char(Database{1,1})));
%finds the number of lines
%check wether it is a lettre or a number

if ~isempty(str2num(char(Database{1,2}(1))));
    NbLines = max(str2num(char(Database{1,2}(:))));
else
    NbLines = max(char(Database{1,2}(:))) - max(char(Database{1,2}(1)))+1;
end
%Finds the number of columns
NbColones = max(str2num(char(Database{1,3}(:))));
%find the number of ORF
NbORF = size(Database{1,5},1);
NbEntry = size(Database{1,1},1);



Var.Plate.StrainDisposition = [NbColones, NbLines];

%Generate a new cell containing all the ORF
ORF{1} = str2num(char(Database{1,1}(:)));
if ~isempty(str2num(char(Database{1,2}(1))));
    ORF{2} = str2num(char(Database{1,2}(:)));
else
    ORF{2} = max(char(Database{1,2}(:)),[],2) - max(char(Database{1,2}(1)))+1;
end
ORF{3} = str2num(char(Database{1,3}(:)));
ORF{4} = char(Database{1,5}(:));

%Make sure number of ORF in the variable is the same as the number of plate
%indexes regisatered
if NbORF < NbEntry
    for i = NbORF+1:NbEntry
        ORF{4}(i,:) = ' ';
    end
end


Var.Plate.ORF = ORF;
Var.Plate.ColumnHead = ColumnHead;
try
if length(ColumnHead) >5
    for C = 6:length(ColumnHead)
        Var.Plate.(ColumnHead{C}) = char(Database{1,C}(:));
    end
end
catch
    warning('Column larger than 5 will not be loaded from database file') 
end
    
assignin('base','Var_ORF2',Var);