function A_OUT = Plate2Lines(A_IN, Var);
%distribute a linear matrix A_IN according to the dimension of plate and
%spotting pattern given in Var into A_OUt where each line corresponds to a
%different strain

p = 0;
q = 0;
r = Var.Plate.Spot(1)/Var.Plate.Strain(1)+1; %13 %Keeps track of the strains 
for i = 1:Var.Plate.Spot(2) %16 %iterate through all lines
    p = p+1;
    if p > Var.Plate.Strain(2) %2
        p = 1;
    else
        r = r-Var.Plate.Spot(1)/Var.Plate.Strain(1); %13-12 => set r back to 1 to reiterate through the same strains
    end
    for j = 1:Var.Plate.Spot(1) %24 %Iterate through all column
        m = i+(j-1)*Var.Plate.Spot(2); %16*(j-1) + i; index position on plate
        q = q+1;
        if q > Var.Plate.Strain(1)
            q = 1;
            r = r+1;
        end
        s = q+(p-1)*Var.Plate.Strain(2);        
        A_OUT(r,s) = A_IN(m);
    end
end
