function [ProtName, Function] = ORF2name(ORF)
try
%Remove blank characters
ORF = deblank(ORF);
%Set Database specific variables:
%Filemaker filename
Var.Database.Name = 'go_latest';
%Database username and password
Var.Database.User = 'go_select';
Var.Database.Psswd = 'amigo';


%%Make connection to database.  Using JDBC driver.
connection = database(Var.Database.Name,Var.Database.User,Var.Database.Psswd,'com.mysql.jdbc.Driver','jdbc:mysql://mysql.ebi.ac.uk:4085/go_latest');

%Check for connection
if isconnection(connection)
    Var.Database.connection = connection;
    % If the connection failed, print the error message
else
    display(sprintf('Connection failed: %s', connection.Message));
end

%Get gene ID
SelectStr = ['SELECT ALL gene_product_id FROM gene_product_synonym WHERE product_synonym LIKE ''', ORF, ''''];

%Perform database search
Cursor = exec(Var.Database.connection, SelectStr);
Cursor = fetch(Cursor);

ID = Cursor.Data{1};

if isnumeric(ID)
    %Get gene name and function
    SelectStr = ['SELECT ALL * FROM gene_product WHERE id = ', num2str(ID) ];
    %Perform database search
    Cursor = exec(Var.Database.connection, SelectStr);
    Cursor = fetch(Cursor);
    
    ProtName = Cursor.Data{2};
    Function = Cursor.Data{6};
else
    ProtName = 'Not found in database';
    Function = '';
end
catch
 	ProtName = '';
    Function = '';
end
