function handles = GatherVar(handles)


%Strain Spott
%Get Value from Edit Box
XspotStr = get(handles.Xspot,'String');
handles.Plate.Strain(1) = str2double(XspotStr);

YspotStr = get(handles.Yspot,'String');
handles.Plate.Strain(2) = str2double(YspotStr);

handles.Plate.Dilution = handles.Plate.Strain(1)*handles.Plate.Strain(2);
handles.Plate.Spot = handles.Plate.StrainDisposition.*handles.Plate.Strain;

handles.File.DisplayMode = get(handles.UseORFList,'Value');

%Image Bit Depth
handles.File.Bit = 8;


%Variable for the spotting pattern
%Number of spots in X and Y directions
%handles.Plate.Spot = [24, 16];


%Variable for the image analysis
%Type of segmentation:
handles.Analysis.SegmentationType = 'Intensity';  %'Edge' or  'Intensity'

% Percent of overlap between each grid cell
handles.Analysis.BorderPercent = 0.2;
% Number of pixels for SPot enlargment
handles.Analysis.GrowSpot = 2;
% Number of Pixels around Spot used as Background
handles.Analysis.BackgroungRingSize = 2;
%Size of artificial spot if no correct borders are found.
handles.Analysis.ArtificialSpot = 5;
%Resize factor for image alignment set lower than zero to spped up alignment process
handles.Analysis.ResizeFactor = 1;


%Variables for display of results
%Size of color regions in display
handles.Display.DispGrid = 11;