function [Var] = AutoPositionPlates(Img, Var)
Debug = 0;
%Normalize Intensity image
%NormImg = 1-double((Img-min(Img(:)))./(max(Img(:))-min(Img(:))));
Img = double(Img);
NormImg = (Img-min(Img(:)))./(max(Img(:))-min(Img(:)));
NormImg = imresize(NormImg, Var.Analysis.ResizeFactor);
RefImg = imresize(Var.Plate.RefImg{Var.Analysis.CurrentScreen}, Var.Analysis.ResizeFactor);
%RefImg = Var.Plate.RefImg{Var.Analysis.CurrentScreen};
%Routine to align two images
if Debug == 1
figure(100)
subplot(2,2,1); imagesc(Img); title('Orig Img')
subplot(2,2,2); imagesc(NormImg); title('NormImg')
subplot(2,2,3); imagesc(RefImg); title('RefImg')
pause(0.2)
end

[im1, im2, Var.Analysis.Offset] = autoposition(NormImg, RefImg);

% figure(101)
% imagesc(im1)
% figure(102)
% imagesc(im2)

Var.Analysis.Offset = Var.Analysis.Offset./ Var.Analysis.ResizeFactor;
%If autoposition didn't work the size of the resulting images and the input
%ref image are not the same. If this happens, set ManPos to one in order to
%force the user to define the grid on the plate
if size(im2,1) ~= size(RefImg,1) | size(im2,2) ~= size(RefImg,2)
    Var.Plate.ManualPosition = 1;
    disp('ManPos active')
end

%Uncomment the following line to display an image that show the alignment
%between the ref image and the normalized image
if Debug == 1
RGB_im(:,:,1) = im1;
RGB_im(:,:,2) = im2;
RGB_im(:,:,3) = 0;
figure; image(RGB_im); title('RGB alignment')
pause(2)
end



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


function [im1, im2, varargout] = autoposition(im1, im2)
%AUTOPOSITION automatically registers two images.
%  [image1 image2] = AUTOPOSITION(image1, image2) will register image1 to
%  image2.  Image2 must be smaller in both dimensions than image2.  Image1
%  is cropped to image2's size, and image2 may be cropped if it is found to
%  lie outside of image1.  Most of the code is taken from an Image
%  Processing Toolbox demo, but some extra lines have been added for
%  robustness.  Both images must be grayscale images.
%  [image1 image2 offset] = AUTOPOSITION(image1, image2) returns the offset
%  generated by the normxcorr2 function.
%
%  Example:
%  ---------------
%  % If you have the IP Toolbox 4.0, you may have to change the TIF
%  % extenstions to PNG
%  im1 = imread('bacteria.tif');
%  im2 = im1(50:170, 100:150);
%  figure, subplot(2,2,1), imagesc(im1, [0 239]), title('Original')
%  axis image
%  subplot(2,2,2), imagesc(im2, [0 239]), axis image, title('Cropped')
%  [im3 im4 offset] = autoposition(im1, im2);
%  subplot(2,2,3), imagesc(im3, [0 239]), axis image, title('Aligned')
%  subplot(2,2,4), imagesc(imsubtract(im4,im3), [-5 5]), axis image, colorbar
%  title('Difference of registered images');
%  offset

[y x z] = size(im2);
[y1 x1 z2] = size(im1);

if (x1 <= x) || (y1 <= y)
    errordlg('The first image must be larger in both dimensions than the second image.',...
        'First must be larger than second');
    return
end

if (z + z2) > 2
    errordlg('Both images must be grayscale (intensity) images.', ...
        'Color images used');
    return
end

%hbar = waitbar(0,'Calculating autoposition coordinates...');
% This is code from an Imaging processing toolbox demo
c = normxcorr2(im2,im1);

% offset found by correlation
[max_c, imax] = max(abs(c(:)));
[ypeak, xpeak] = ind2sub(size(c),imax(1));
corr_offset = [(xpeak-size(im2,2)) (ypeak-size(im2,1))];

offset = corr_offset;
xoffset = offset(1);
yoffset = offset(2);

% Images begin at (1,1), so add one to the offset values for coordinates
xbegin = xoffset + 1;
xend   = xoffset + size(im2,2);
ybegin = yoffset + 1;
yend   = yoffset + size(im2,1);

% Trim the boundaries in case the measured image is larger than the
% first in some dimensions
if xend > x1 % This means the second image will hang over on the right side of the first
    disp('Warning - the second image is to the right of the first image.')
    xend = x1;
    im2 = im2(:,1:(x1-xbegin+1),:);
end

if yend > y1 % Second image hangs below first image
    disp('Warning - the second image is below the first image.')
    yend = y1;
    im2 = im2(1:(y1-ybegin+1),:,:);
end

if xbegin < 1 % Second image is to the left of first image
    disp('Warning - the second image is to the left of the first image.')
    im2 = im2(:,(-xbegin+2):end,:);
    xbegin = 1;
end

if ybegin < 1 % Second image is above first image
    disp('Warning - the second image is above the first image.')
    im2 = im2((-ybegin+2):end,:,:);
    ybegin = 1;
end

im1 = im1(ybegin:yend,xbegin:xend,:);

if nargout > 2
    varargout{1} = offset;
end
%close(hbar);