#Title: runGetFeatures.R
#Type: Script
#Version: 1.0
#Date: 2014-03-07
#Author: Martial Sankar
#Maintainer: Martial Sankar <martial.sankar@unil.ch>
#Description: command line R tool for automated cellular features extraction
#License: GPL (>= 2)
#Depends: R (>= 2.14.0)
#OS_type: unix
#Depends on: postSeg_function.R
#URL: http://www3.unil.ch/wpmu/hardtkelab/

source("postSeg_function.R")

args <- commandArgs(trailingOnly = TRUE)
folder <- args[1]
dag <- args[2]
fns <- dir(folder, full.names = TRUE)
segs <- grep( "segmented.tif", fns, value=T)
rayThresh <- NULL

for (i in 1:length(segs)){
	rawNm <-  gsub( "_segmented", "",segs[i])
	raw <- readImage(rawNm)
	cat("#Raw::",rawNm,"\n")
	cat("#Segs::",segs[i],"\n")
	outfn <- gsub( "_segmented.tif", "_features.txt",segs[i])	
	res <- 	getFeaturesOverall(imSeg=segs[i], imRaw=raw, rayThresh = rayThresh, methodExt = "geomean")
	write.table(res, outfn, sep ="\t", row.names=F, quote=F,col.names=T)
	cat('output table::', outfn, '\n')
}
	
